package jp.sourceforge.projects.ee2e.core.ttledit;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class TtlConfiguration extends SourceViewerConfiguration {
	private TtlScanner scanner;
	private TtlColorProvider provider;

	public TtlConfiguration(TtlColorProvider provider) {
		this.provider = provider;
	}
	protected TtlScanner getXMLScanner() {
		if (scanner == null) {
			scanner = new TtlScanner(provider);
			scanner.setDefaultReturnToken(
				new Token(
					new TextAttribute(provider.getColor(TtlColorProvider.DEFAULT))));
		}
		return scanner;
	}
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		PresentationReconciler reconciler = new PresentationReconciler();

		DefaultDamagerRepairer dr = new DefaultDamagerRepairer(getXMLScanner());
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);

		return reconciler;
	}
}