/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.validator;

import elazyrest.core.annotation.RestParam;
import elazyrest.core.validator.RestParamErrors;
import java.util.regex.Pattern;

public class RestParamValidator {
    public static boolean validate(String methodName, Object value, RestParam annotation, RestParamErrors errors) {
        int n;
        String description = annotation.description();
        if (value == null || value.toString().length() <= 0) {
            if (annotation.required()) {
                errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "required");
                return false;
            }
            return true;
        }
        if (value instanceof Object[]) {
            boolean isEmpty = true;
            Object[] vals = (Object[])value;
            if (vals.length > 0) {
                Object[] objectArray = vals;
                n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Object val = objectArray[n];
                    if (val != null && val.toString().length() > 0) {
                        isEmpty = false;
                        break;
                    }
                    ++n;
                }
            }
            if (isEmpty) {
                if (annotation.required()) {
                    errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "required");
                    return false;
                }
                return true;
            }
        }
        if (value instanceof Object[]) {
            Object[] values;
            Object[] objectArray = values = (Object[])value;
            int n3 = 0;
            n = objectArray.length;
            while (n3 < n) {
                String[] params;
                Object val = objectArray[n3];
                if (!RestParamValidator.validateMaxLength(val, annotation)) {
                    params = new String[]{String.valueOf(annotation.maxLength())};
                    errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "max_length", params);
                    return false;
                }
                if (!RestParamValidator.validateMinLength(val, annotation)) {
                    params = new String[]{String.valueOf(annotation.minLength())};
                    errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "min_length", params);
                    return false;
                }
                if (!RestParamValidator.validatePattern(val, annotation)) {
                    errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "pattern");
                    return false;
                }
                ++n3;
            }
        } else {
            if (!RestParamValidator.validateMaxLength(value, annotation)) {
                String[] params = new String[]{String.valueOf(annotation.maxLength())};
                errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "max_length", params);
                return false;
            }
            if (!RestParamValidator.validateMinLength(value, annotation)) {
                String[] params = new String[]{String.valueOf(annotation.minLength())};
                errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "min_length", params);
                return false;
            }
            if (!RestParamValidator.validatePattern(value, annotation)) {
                errors.add(String.valueOf(methodName) + "." + annotation.name(), description, "pattern");
                return false;
            }
        }
        return true;
    }

    public static boolean validateMaxLength(Object value, RestParam annotation) {
        return annotation.maxLength() <= 0 || value.toString().length() <= annotation.maxLength();
    }

    public static boolean validateMinLength(Object value, RestParam annotation) {
        return annotation.minLength() <= 0 || value.toString().length() >= annotation.minLength();
    }

    public static boolean validatePattern(Object value, RestParam annotation) {
        return annotation.pattern().length() <= 0 || Pattern.matches(annotation.pattern(), value.toString());
    }
}

