/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CharIndexFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;

public class SybaseDialect
extends Dialect {
    public SybaseDialect() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.INTEGER));
        this.registerFunction("char", new StandardSQLFunction("char", Hibernate.CHARACTER));
        this.registerFunction("len", new StandardSQLFunction("len", Hibernate.LONG));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("str", new StandardSQLFunction("str", Hibernate.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("reverse", new StandardSQLFunction("reverse"));
        this.registerFunction("space", new StandardSQLFunction("space", Hibernate.STRING));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("getdate", Hibernate.TIMESTAMP));
        this.registerFunction("current_time", new NoArgSQLFunction("getdate", Hibernate.TIME));
        this.registerFunction("current_date", new NoArgSQLFunction("getdate", Hibernate.DATE));
        this.registerFunction("getdate", new NoArgSQLFunction("getdate", Hibernate.TIMESTAMP));
        this.registerFunction("getutcdate", new NoArgSQLFunction("getutcdate", Hibernate.TIMESTAMP));
        this.registerFunction("day", new StandardSQLFunction("day", Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction("month", Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction("year", Hibernate.INTEGER));
        this.registerFunction("datename", new StandardSQLFunction("datename", Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction("log10", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction("pi", Hibernate.DOUBLE));
        this.registerFunction("square", new StandardSQLFunction("square"));
        this.registerFunction("rand", new StandardSQLFunction("rand", Hibernate.FLOAT));
        this.registerFunction("radians", new StandardSQLFunction("radians", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("isnull", new StandardSQLFunction("isnull"));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "+", ")"));
        this.registerFunction("length", new StandardSQLFunction("len", Hibernate.INTEGER));
        this.registerFunction("trim", new SQLFunctionTemplate(Hibernate.STRING, "ltrim(rtrim(?1))"));
        this.registerFunction("locate", new CharIndexFunction());
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getNullColumnString() {
        return " null";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select @@identity";
    }

    public String getIdentityColumnString() {
        return "identity not null";
    }

    public boolean supportsInsertSelectIdentity() {
        return true;
    }

    public String appendIdentitySelectToInsert(String insertSQL) {
        return insertSQL + "\nselect @@identity";
    }

    public String appendLockHint(LockMode mode, String tableName) {
        if (mode.greaterThan(LockMode.READ)) {
            return tableName + " holdlock";
        }
        return tableName;
    }

    public String applyLocksToSql(String sql, Map aliasedLockModes, Map keyColumnNames) {
        Iterator itr = aliasedLockModes.entrySet().iterator();
        StringBuffer buffer = new StringBuffer(sql);
        int correction = 0;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            LockMode lockMode = (LockMode)entry.getValue();
            if (!lockMode.greaterThan(LockMode.READ)) continue;
            String alias = (String)entry.getKey();
            int start = -1;
            int end = -1;
            if (sql.endsWith(" " + alias)) {
                start = sql.length() - alias.length() + correction;
                end = start + alias.length();
            } else {
                int position = sql.indexOf(" " + alias + " ");
                if (position <= -1) {
                    position = sql.indexOf(" " + alias + ",");
                }
                if (position > -1) {
                    start = position + correction + 1;
                    end = start + alias.length();
                }
            }
            if (start <= -1) continue;
            String lockHint = this.appendLockHint(lockMode, alias);
            buffer.replace(start, end, lockHint);
            correction += lockHint.length() - alias.length();
        }
        return buffer.toString();
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select getdate()";
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String baseTableName) {
        return "#" + baseTableName;
    }

    public boolean dropTemporaryTableAfterUse() {
        return true;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }
}

