/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.i18n;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlResourceBundle
extends ResourceBundle {
    private String path = null;
    protected Document xmlData = null;
    public static final String TAG_MSG = "MSG";
    public static final String ATR_ID = "id";
    protected Locale locale = null;
    private URL url = null;

    public XmlResourceBundle(String path, Locale locale) {
        this.path = path;
        this.locale = locale;
        this.init();
    }

    public XmlResourceBundle(URL url, Locale locale) {
        this.url = url;
        this.locale = locale;
        this.init();
    }

    public Enumeration getKeys() {
        Vector<String> vec = new Vector<String>();
        NodeList nl = this.xmlData.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            vec.add(this.getAttrValue(nl.item(i), ATR_ID));
            ++i;
        }
        return vec.elements();
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected Object handleGetObject(String key) {
        String value = "";
        if (this.xmlData == null) {
            return value;
        }
        value = this.getValue(this.xmlData.getElementsByTagName(TAG_MSG), TAG_MSG, ATR_ID, key);
        return value != null ? value : "";
    }

    public void init() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (this.path != null) {
                File file = new File(this.path);
                this.xmlData = db.parse(file);
            } else if (this.url != null) {
                this.xmlData = db.parse(this.url.openStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Document getXMLData() {
        return this.xmlData;
    }

    protected String getValue(NodeList nodeList, String tagName) {
        String value = null;
        if (nodeList == null) {
            nodeList = this.xmlData.getElementsByTagName(tagName);
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            if (item.getNodeName().equals(tagName)) {
                value = this.getTargetValue(item);
                break;
            }
            ++i;
        }
        return value;
    }

    protected String getValue(NodeList nodeList, String tagName, String attrName, String attrValue) {
        String value = null;
        if (nodeList == null) {
            nodeList = this.xmlData.getElementsByTagName(tagName);
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node attribute;
            Node item = nodeList.item(i);
            if (item.getNodeName().equals(tagName) && (attribute = item.getAttributes().getNamedItem(attrName)).getNodeValue().toString().trim().equals(attrValue)) {
                value = this.getTargetValue(item);
                break;
            }
            ++i;
        }
        return value;
    }

    protected String getTargetValue(Node node) {
        if (node.getNodeValue() != null) {
            return node.getNodeValue().trim();
        }
        Node curNode = node.getFirstChild();
        while (curNode != null) {
            if (curNode.getNodeType() == 3) {
                String val = curNode.getNodeValue().trim();
                if (val.length() != 0) {
                    return val;
                }
            } else if (curNode.getNodeType() == 4) {
                if (curNode.getNodeValue() != null) {
                    return curNode.getNodeValue().trim();
                }
                if (curNode.hasChildNodes()) {
                    return this.getTargetValue(curNode);
                }
            }
            curNode = curNode.getNextSibling();
        }
        return null;
    }

    protected String getAttrValue(Node node, String attrName) {
        String value = null;
        Node attribute = node.getAttributes().getNamedItem(attrName);
        if (attribute != null) {
            value = this.getTargetValue(attribute);
        }
        return value;
    }

    protected NodeList getChildNodeList(String tagName, String attrName, String attrValue) {
        NodeList retList = null;
        NodeList nList = this.xmlData.getElementsByTagName(tagName);
        int i = 0;
        while (i < nList.getLength()) {
            Node attribute = nList.item(i).getAttributes().getNamedItem(attrName);
            if (attribute.getNodeValue().toString().trim().equals(attrValue)) {
                retList = nList.item(i).getChildNodes();
                break;
            }
            ++i;
        }
        return retList;
    }
}

