<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
 version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns="http://www.w3.org/1999/xhtml"
>

<xsl:output method="text" encoding="utf-8" />

<xsl:template match="/">
	<xsl:call-template name="xml2vars">
		<xsl:with-param name="nodes" select="*"/>
		
	</xsl:call-template>
</xsl:template>

<xsl:template name="xml2vars">
	<xsl:param name="parent_name"/>
	<xsl:param name="nodes"/>
	<xsl:param name="delim"/>
	<xsl:param name="attr_delim"/>
	<xsl:param name="multi"/>

	<xsl:for-each select="$nodes">
		<xsl:choose>
			<xsl:when test ="not(child::*) and not(@*)">
				<xsl:value-of select="$parent_name"/><xsl:value-of select="$delim"/><xsl:value-of select="$attr_delim"/><xsl:value-of select="local-name()"/><xsl:text>=</xsl:text>
				<xsl:call-template name="escape">
				<xsl:with-param name="str" select="."/>
				</xsl:call-template>
				<xsl:text>&amp;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="target_name" select="local-name()"/>
				<!-- multi -->
				<xsl:if test="count(../*[local-name() = $target_name]) &gt; 1">
					<xsl:choose>
					<!-- first node -->
					<xsl:when test="not($multi = '1')">
					<xsl:if test="not(preceding::*[local-name() = $target_name])">
						<xsl:call-template name="xml2vars">
							<xsl:with-param name="nodes" select="../*[local-name() = $target_name]"/>
							<xsl:with-param name="parent_name" select="$parent_name"/>
							<xsl:with-param name="delim" select="$delim"/>
							<xsl:with-param name="attr_delim" select="$attr_delim"/>
							<xsl:with-param name="multi" select="'1'"/>
						</xsl:call-template>
					</xsl:if>
					</xsl:when>
					<!-- multi node -->
					<xsl:when test="$multi = '1'">
						<xsl:if test="@*">
							<xsl:call-template name="xml2vars">
								<xsl:with-param name="nodes" select="@*"/>
								<xsl:with-param name="parent_name" select="concat($parent_name, $delim, local-name(), position())"/>
								<xsl:with-param name="delim" select="'.'"/>
								<xsl:with-param name="attr_delim" select="'@'"/>
								<xsl:with-param name="multi" select="'0'"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="*">
							<xsl:call-template name="xml2vars">
								<xsl:with-param name="nodes" select="*"/>
								<xsl:with-param name="parent_name" select="concat($parent_name, $delim, local-name(), position())"/>
								<xsl:with-param name="delim" select="'.'"/>
								<xsl:with-param name="multi" select="'0'"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:when>
					</xsl:choose>
				</xsl:if>
				<!-- simple -->
				<xsl:if test="count(../*[local-name() = $target_name]) = 1">
					<xsl:if test="@*">
						<xsl:call-template name="xml2vars">
							<xsl:with-param name="nodes" select="@*"/>
							<xsl:with-param name="parent_name" select="concat($parent_name, $delim, local-name())"/>
							<xsl:with-param name="delim" select="'.'"/>
							<xsl:with-param name="attr_delim" select="'@'"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="*">
						<xsl:call-template name="xml2vars">
							<xsl:with-param name="nodes" select="*"/>
							<xsl:with-param name="parent_name" select="concat($parent_name, $delim, local-name())"/>
							<xsl:with-param name="delim" select="'.'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>

<xsl:template name="escape">
	<xsl:param name="str"/>
	<xsl:variable name="tmp">
		<xsl:call-template name="replace">
			<xsl:with-param name="str" select="$str"/>
			<xsl:with-param name="match" select="'&amp;'"/>
			<xsl:with-param name="replace" select="'%26'"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:text>
	<xsl:call-template name="replace">
		<xsl:with-param name="str" select="$str"/>
		<xsl:with-param name="match" select="'='"/>
		<xsl:with-param name="replace" select="'%3D'"/>
	</xsl:call-template>
	</xsl:text>
	<xsl:text>
</xsl:template>

<xsl:template name="replace">
	<xsl:param name="str"/>
	<xsl:param name="match"/>
	<xsl:param name="replace"/>
	<xsl:choose>
	<xsl:when test="contains($str,$match)"
	><xsl:value-of select="substring-before($str,$match)"
	/><xsl:value-of select="$replace"
		/><xsl:call-template name="replace">
			<xsl:with-param name="str" select="substring-after($str,$match)"/>
			<xsl:with-param name="match" select="$match"/>
			<xsl:with-param name="replace" select="$replace"/>
		</xsl:call-template></xsl:when>
	<xsl:otherwise><xsl:value-of select="$str"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>