package elazyrest.core.validator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * ValidatorNX
 * RestParamAme[V`Ăp[^p
 * @author kaz
 *
 */
public class RestParamErrors {
	private HashMap<String, RestParamError> errors = new HashMap<String, RestParamError>();

	public void add(RestParamError error) {
		errors.put(error.getKey(), error);
	}
	
	public void add(String key, String keyDescription, String resourceKey) {
		RestParamError error = new RestParamError(key, keyDescription, resourceKey);
		errors.put(key, error);
	}
	
	public void add(String key, String keyDescription, String resourceKey, String[] params) {
		RestParamError error = new RestParamError(key, keyDescription, resourceKey, params);
		errors.put(key, error);
	}
	
	public boolean isEmpty() {
		return errors.isEmpty();
	}
	
	public String getMessage() {
		if (errors.isEmpty()) {
			return null;
		}
		StringBuffer errorMessage = new StringBuffer();
		Iterator keyIter = errors.keySet().iterator();
		while (keyIter.hasNext()) {
			String key = (String)keyIter.next();
			RestParamError error = errors.get(key);
			errorMessage.append(error.getMessage());
		}
		
		return errorMessage.toString();
	}
	
	public Map<String, RestParamError> getErrors() {
		return errors;
	}
	
}