#include "TestCase.h"
#include "TestResult.h"

TestResultRef _result;
TestCaseRef _self;

void TestCase_run(TestCaseRef self,TestResultRef result)
{
	if (result && result->startTest) {
		result->startTest(result, (TestRef)self);
	}
	if (self->setUp) {
		self->setUp();
	}
	if (self->runTest) {
		_result = result;
		_self = self;
		self->runTest();
	}
	if (self->tearDown) {
		self->tearDown();
	}
	if (result && result->endTest) {
		result->endTest(result, (TestRef)self);
	}
}

int TestCase_countTestCases(TestCaseRef testCase)
{
	return 1;
}

void addFailure(const char* msg, long line, const char* file)
{
	_result->addFailure(_result, (TestRef)_self, (char*)msg, line, (char*)file);
}

void assertEqualsImplInt(int expected,int actual, long line, const char* file)
{
	char buffer[64];
	embunit_sprintf(buffer, "exp<%d> act<%d>", expected, actual);
	addFailure(buffer, line, file);
}

void assertEqualsImplCStr(const char* expected,const char* actual, long line, const char* file)
{
/*	char buffer[64];*/
/*	embunit_sprintf(buffer, "exp<%s> act<%s>", expected, actual);*/
	addFailure("fail", line, file);
}
