#ifndef	__TESTCASE_H__
#define	__TESTCASE_H__

#include "Test.h"

typedef struct __TestCase	TestCase;
typedef struct __TestCase*	TestCaseRef;

struct __TestCase {
	TestInterface(TestCaseRef)
	void(*setUp)(void);
	void(*runTest)(void);
	void(*tearDown)(void);
};

void TestCase_run(TestCaseRef self,TestResultRef result);
int TestCase_countTestCases(TestCaseRef self);

void addFailure(const char* msg, long line, const char* file);
void assertEqualsImplInt(int expected,int actual, long line, const char* file);
void assertEqualsImplCStr(const char* expected,const char* actual, long line, const char* file);

#define new_TestCase(name,setUp,runTest,tearDown)	{\
														name,\
														TestCase_run,\
														TestCase_countTestCases,\
														setUp,\
														runTest,\
														tearDown,\
													}

extern int embunit_strcmp(const char *s1, const char *s2);
extern int embunit_sprintf(char *buffer,const char *format, ...);

#define TEST_ASSERT_EQUAL_STRING(expected,actual)\
	do {\
		if (!embunit_strcmp(expected,actual)) {\
			assertEqualsImplInt(expected,actual,__LINE__,__FILE__);\
		}\
	} while(0);

#define TEST_ASSERT_EQUAL_INT(expected,actual)\
	do {\
		if (expected != actual) {\
			assertEqualsImplInt(expected,actual,__LINE__,__FILE__);\
		}\
	} while(0);

#define TEST_ASSERT_MESSAGE(cond, msg)\
	do {\
		if (!(x)) {\
			TEST_FAIL(msg);\
		}\
	} while(0)

#define TEST_ASSERT(x)\
	do {\
		if (!(x)) {\
			TEST_FAIL(#x);\
		}\
	} while(0)

#define TEST_FAIL(msg)\
	addFailure(msg,__LINE__,__FILE__)

#endif/*__TESTCASE_H__*/
