#include "TestResult.h"

void TestResult_startTest(TestResultRef self,TestRef test)
{
	self->numberOfTestsRun++;
	if (self->listener) {
		self->listener->startTest(self->listener, test);
	}
}

void TestResult_endTest(TestResultRef self,TestRef test)
{
	if (self->listener) {
		self->listener->endTest(self->listener, test);
	}
}

void TestResult_addError(TestResultRef self,TestRef test,char *msg,int line,char *file)
{
	self->numberOfErrors++;
	if (self->listener) {
		self->listener->addError(self->listener, test, msg, line, file);
	}
}

void TestResult_addFailure(TestResultRef self,TestRef test,char *msg,int line,char *file)
{
	self->numberOfFailures++;
	if (self->listener) {
		self->listener->addFailure(self->listener, test, msg, line, file);
	}
}
