#ifndef	__TESTRESULT_H__
#define	__TESTRESULT_H__

#include "Test.h"
#include "TestListener.h"

/*typedef struct __TestResult		TestResult;*//* -> Test.h*/
/*typedef struct __TestResult*		TestResultRef;*//* -> Test.h*/

struct __TestResult {
	TestListnerInterface(TestResultRef)
	int numberOfTestsRun;
	int numberOfFailures;
	int numberOfErrors;
	TestListnerRef listener;
};

void TestResult_startTest(TestResultRef self,TestRef test);
void TestResult_endTest(TestResultRef self,TestRef test);
void TestResult_addError(TestResultRef self,TestRef test,char *msg,int line,char *file);
void TestResult_addFailure(TestResultRef self,TestRef test,char *msg,int line,char *file);

#define new_TestResult(listener)	{\
										TestResult_startTest,\
										TestResult_endTest,\
										TestResult_addError,\
										TestResult_addFailure,\
										0,0,0,\
										(TestListnerRef)listener,\
									}
#endif/*__TESTRESULT_H__*/
