#include "TestResult.h"
#include "TestRunner.h"
#include <stdio.h>

void runner_startTest(TestListnerRef self,TestRef test)
{
	printf(".");
}

void runner_endTest(TestListnerRef self,TestRef test)
{
}

void runner_addError(TestListnerRef self,TestRef test,char *msg,int line,char *file)
{
}

void runner_addFailure(TestListnerRef self,TestRef test,char *msg,int line,char *file)
{
	printf("%s %d %s\n",test->name, line, msg);
}

enum {	TESTRUNNER_MAX_TEST_STORE = 8	};

int runner_numberOfTests;
TestRef runner_tests[TESTRUNNER_MAX_TEST_STORE];

static const TestListner listner = {
	runner_startTest,
	runner_endTest,
	runner_addError,
	runner_addFailure,
};

void TestRunner_init(void)
{
	runner_numberOfTests = 0;
}

int TestRunner_numberOfTests(void)
{
	return runner_numberOfTests;
}

void TestRunner_addt(TestRef test)
{
	if (runner_numberOfTests < aNumber(runner_tests)) {
		runner_tests[runner_numberOfTests++] = test;
	}
}

void TestRunner_runt(TestRef test)
{
	TestResult result = new_TestResult(&listner);
	test->run(test, &result);
}

void TestRunner_run(void)
{
	TestResult result = new_TestResult(&listner);

	{
		TestRef test;
		int i;
		for (i=0; i<runner_numberOfTests; i++) {
			test = runner_tests[i];
			test->run(test, &result);
		}
	}

	if (result.numberOfFailures) {
		printf("\nrun %d failures %d errors %d\n", result.numberOfTestsRun, result.numberOfFailures, result.numberOfErrors);
	} else {
		printf("\nOK (%d tests)\n", result.numberOfTestsRun);
	}
}
