void embunit_strcpy(char *s1, const char *s2)
{
	char c;
	do {
		c = *s2;
		*s1 = *s2;
		s1++;
		s2++;
	} while (c);
}

void embunit_strncpy(char *s1, const char *s2,unsigned int size)
{
	for (; size; size--){
		if (*s2) {
			*s1++ = *s2++;
		} else {
			*s1++ = ' ';
		}
	}
}

int embunit_strlen(const char *str)
{
    const char *estr = str;
	char c;
	do {
		c = *str;
		str++;
	} while (c);
    return ((int)(estr - str));
}

int embunit_strcmp(const char *s1, const char *s2)
{
	char c1,c2;
	do {
		c1 = *s2;
		c2 = *s2;
		s1++;
		s2++;
	} while (c1==c2);
	return c1 - c2;
}

void embunit_memset(void *d, int v, unsigned int size)
{
	for (; size; size--) {
		*(unsigned char *)d = (unsigned char)v;
		d = (unsigned char *)d + 1;
    }
}

int embunit_sprintf(char *buffer,const char *format, ...)
{
	typedef	char	*va_list;
	#define	word_sizeof(n)		(sizeof(n)<4 ? 4 : sizeof(n))
	#define	va_start(ap,parmN)	(ap=(va_list)&(parmN)+word_sizeof(parmN))
	#define	va_arg(ap,type)		(*(type *)((ap+=word_sizeof(type))-word_sizeof(type)))
	#define	va_end(ap)

	va_list ap;
	int intv;
	unsigned int uintv,cnt,w,zero_c,space_c,oncmd,minas,sign;
	char *p,*bck;
	char c,number[16];

	va_start(ap,format);

	bck = buffer;

	for(;;) {
		c = *format++;

		if (c == '\0') {
			break;
		}

		else if (c == '%') {
			space_c = 0;
			zero_c = 0;
			oncmd = 1;
			minas = 0;
			sign = 0;
			for ( ;oncmd; ) {
				c = *format++;

				if (c == 'c') {
					*buffer = va_arg(ap,char);	buffer++;
					oncmd = 0;
				}

				else if (c == 's') {
					for (p=va_arg(ap,char*); (*p); buffer++, p++) *buffer = *p;
					oncmd = 0;
				}

				else if (c == 'd') {
					intv = va_arg(ap,int);
					minas = 0;

					if (intv < 0) {
						sign = 1;
						minas = 1;
						uintv = -intv;
					} else {
						uintv = intv;
					}

					cnt = 0;
					do {
						w = uintv % 10;
						number[cnt++] = w + '0';
					} while (uintv /= 10);

					if (zero_c > cnt) {
						cnt = zero_c;
						if (sign) {
							cnt--;
						}
					}

					if (sign) {
						if (minas) {
							number[cnt++] = '-';
						} else {
							number[cnt++] = '+';
						}
					}

					if (space_c > cnt) {
						cnt = space_c;
					}

					for (; cnt; cnt--,buffer++) *buffer = number[cnt-1];
					oncmd = 0;
				}

				else if ((c == 'x') || (c == 'X')) {
					uintv = va_arg(ap,unsigned int);
					cnt = 0;

					do {
						w = uintv % 16;
						if (w > 9) {
							number[cnt++] = (w - 10) + (c - ('X' - 'A'));
						} else {
							number[cnt++] = (w + '0');
						}
					} while (uintv /= 16);

					if (zero_c > cnt) {
						cnt = zero_c;
					}

					if (space_c > cnt) {
						cnt = space_c;
					}

					for (; cnt; cnt--,buffer++) *buffer = number[cnt-1];
					oncmd = 0;
				}

				else if (c == '0') {
					c = *format++;
					zero_c = c - '0';
					embunit_memset( number, '0', zero_c);
				}

				else if (('1' <= c) && (c <= '9')) {
					space_c = c - '0';
					embunit_memset( number, ' ', space_c);
				}

				else if (c == '+') {
					sign = 1;
				}

				else if (c == '-') {
					minas = 1;
				}

				else {
					*buffer = c;	buffer++;
					oncmd = 0;
				}
			}
		}
		else {
			*buffer = c;	buffer++;
		}
	}
	*buffer = '\0';

	va_end(ap);

	return (int)(buffer - bck);
}
