#ifndef	__TESTCALLER_H__
#define	__TESTCALLER_H__

#include "Test.h"

typedef struct __TestFixture	TestFixture;
typedef struct __TestFixture*	TestFixtureRef;

struct __TestFixture {
	char *name;
	void(*test)(void);
};

typedef struct __TestCaller	TestCaller;
typedef struct __TestCaller*TestCallerRef;

struct __TestCaller {
	TestInterface(TestCallerRef)
	void(*setUp)(void);
	void(*tearDown)(void);
	int numberOfFixtuers;
	TestFixture	*fixtuers;
};

void TestCaller_run(TestCallerRef self,TestResultRef result);
int TestCaller_countTestCases(TestCallerRef self);

#define new_TestCaller(name,sup,tdw,numberOfFixtuers,fixtuers)\
	{\
		name,\
		TestCaller_run,\
		TestCaller_countTestCases,\
		sup,\
		tdw,\
		numberOfFixtuers,\
		fixtuers,\
	}

#define new_TestFixture(name,test)\
	{\
		name,\
		test,\
	}

#endif/*__TESTCALLER_H__*/
