#include "TestResult.h"

void TestResult_result(TestResultRef self,TestListnerRef listner)
{
	self->startTest = TestResult_startTest;
	self->endTest = TestResult_endTest;
	self->addFailure = TestResult_addFailure;
	self->numberOfTestsRun = 0;
	self->numberOfFailures = 0;
	self->listener = listner;
}

void TestResult_startTest(TestResultRef self,TestRef test)
{
	self->numberOfTestsRun++;
	if (self->listener) {
		self->listener->startTest(self->listener, test);
	}
}

void TestResult_endTest(TestResultRef self,TestRef test)
{
	if (self->listener) {
		self->listener->endTest(self->listener, test);
	}
}

void TestResult_addFailure(TestResultRef self,TestRef test,char *msg,int line,char *file)
{
	self->numberOfFailures++;
	if (self->listener) {
		self->listener->addFailure(self->listener, test, msg, line, file);
	}
}
