#include "TestResult.h"
#include "TestRunner.h"
#include <stdio.h>

TestResult	result;

void TestRunner_startTest(TestListnerRef self,TestRef test)
{
	printf(".");
}

void TestRunner_endTest(TestListnerRef self,TestRef test)
{
}

void TestRunner_addFailure(TestListnerRef self,TestRef test,char *msg,int line,char *file)
{
	printf("%s:%d %s\n",file, line, msg);
}

const TestListner runner = {
	TestRunner_startTest,
	TestRunner_endTest,
	TestRunner_addFailure,
};

void TestRunner_init(void)
{
	TestResult_result(&result, (TestListnerRef)&runner);
}

void TestRunner_runt(TestRef test)
{
	test->run(test, &result);
}

void TestRunner_printResult(void)
{
	if (result.numberOfFailures) {
		printf("\nrun %d failures %d\n", result.numberOfTestsRun, result.numberOfFailures);
	} else {
		printf("\nOK (%d tests)\n", result.numberOfTestsRun);
	}
}
