#include <embUnit/embUnit.h>
#include "WasRun.h"

static void setUp(void)
{
	WasRun_init();
}

static void tearDown(void)
{
}

static void testTestCase_run(void)
{
	TestCase tcase = new_TestCase("",NULL,WasRun_runTest,NULL);

	tcase.run(&tcase,NULL);

	TEST_ASSERT_EQUAL_INT(1, WasRun_wasRun());
}

static void testTestCase_countTestCases(void)
{
	TestCase tcase = new_TestCase("",NULL,NULL,NULL);

	TEST_ASSERT_EQUAL_INT(1, tcase.countTestCases(&tcase));
}

TestCallerRef TestCaseTest_caller(void)
{
	EMB_UNIT_TESTFIXTURES(fixtures) {
		new_TestFixture("testRepeatedTest_countTestCases",testTestCase_run),
		new_TestFixture("testTestCase_countTestCases",testTestCase_countTestCases),
	};

	EMB_UNIT_TESTCALLER(TestCaseTest,"TestCaseTest",setUp,tearDown,fixtures);

	return (TestCallerRef)&TestCaseTest;
}
