#include "stdImpl.h"

char* stdimpl_strcpy(char *s1, const char *s2)
{
	char c;
	do {
		c = *s2;
		*s1 = *s2;
		s1++;
		s2++;
	} while (c);
	return s1-1;
}

char* stdimpl_strncpy(char *s1, const char *s2,unsigned int size)
{
	for (; size; size--){
		if (*s2) {
			*s1++ = *s2++;
		} else {
			*s1++ = '\0';
		}
	}
	return s1;
}

int stdimpl_strlen(const char *str)
{
    const char *estr = str;
	char c;
	do {
		c = *estr;
		estr++;
	} while (c);
    return ((int)(estr - str-1));
}

int stdimpl_strcmp(const char *s1, const char *s2)
{
	char c1,c2;
	do {
		c1 = *s1;
		c2 = *s2;
		s1++;
		s2++;
	} while ((c1) && (c2) && (c1==c2));
	return c1 - c2;
}

int stdimpl_itoa(int v,char *string,int r)
{
	char buf[33],*p;
	unsigned int vv,w,i,j,sign;

	sign = 0;
	vv = v;
	if (v < 0) {
		sign = 1;
		vv = -v;
	}

	i=0;
	p=buf;
	do {
		w = vv % r;
		*p = "0123456789abcdef"[w];
		p++;
		i++;
		vv /= r;
	} while (vv);

	if (sign) {
		*p = '-';
		p++;
	}

	j=i;
	do {
		j--;
		p--;
		*string = *p;
		string++;
	} while (j);

	*string = '\0';

	return i;
}
