#ifndef	__TESTCASE_H__
#define	__TESTCASE_H__

#include "Test.h"

typedef struct __TestCase	TestCase;
typedef struct __TestCase*	TestCaseRef;

struct __TestCase {
	TestImplementRef isa;
	char* name;
	void(*setUp)(void);
	void(*runTest)(void);
	void(*tearDown)(void);
};

extern const TestImplement TestCaseImplement;

#define new_TestCase(name,setUp,runTest,tearDown)\
	{\
		(TestImplementRef)&TestCaseImplement,\
		name,\
		setUp,\
		runTest,\
		tearDown,\
	}

#endif/*__TESTCASE_H__*/
