#include "config.h"
#include "stdImpl.h"
#include "TestResult.h"
#include "TestRunner.h"

static TestResult result_;

void TestRunner_startTest(TestListnerRef self,TestRef test)
{
	stdimpl_puts("\t");
	stdimpl_puts(Test_name(test));
	stdimpl_puts("\n");
}

void TestRunner_endTest(TestListnerRef self,TestRef test)
{
}

void TestRunner_addFailure(TestListnerRef self,TestRef test,char *msg,int line,char *file)
{
	char buf[34];
	stdimpl_puts("\t");
	stdimpl_puts(file);
	stdimpl_puts(":");
	stdimpl_itoa(line, buf, 10);
	stdimpl_puts(buf);
	stdimpl_puts(" ");
	stdimpl_puts(msg);
	stdimpl_puts("\n");
}

static const TestListnerImplement TestRunnerImplement = {
	(TestListnerImplStartTest)TestRunner_startTest,
	(TestListnerImplEndTest)TestRunner_endTest,
	(TestListnerImplAddFailure)TestRunner_addFailure,
};

static const TestRunner runner_ = {
	(TestListnerImplementRef)&TestRunnerImplement,
};

void TestRunner_init(void)
{
	TestResult_init(&result_, (TestListnerRef)&runner_);
}

void TestRunner_runt(TestRef test)
{
	stdimpl_puts(Test_name(test));
	stdimpl_puts(" :\n");
	Test_run(test, &result_);
}

TestResultRef TestRunner_result(void)
{
	return (TestResultRef)&result_;
}

void TestRunner_printResult(void)
{
	if (result_.numberOfFailures) {
		char buf[34];
		stdimpl_puts("\nrun ");
		stdimpl_itoa(result_.numberOfTestsRun, buf, 10);
		stdimpl_puts(buf);
		stdimpl_puts(" failures ");
		stdimpl_itoa(result_.numberOfFailures, buf, 10);
		stdimpl_puts(buf);
		stdimpl_puts("\n");
	} else {
		char buf[34];
		stdimpl_puts("\nOK (");
		stdimpl_itoa(result_.numberOfTestsRun, buf, 10);
		stdimpl_puts(buf);
		stdimpl_puts(" tests)\n");
	}
}
