#include "stdImpl.h"

char* stdimpl_strcpy(char *s1, const char *s2)
{
	char c;
	do {
		c = *s2;
		*s1 = c;
		s1++;
		s2++;
	} while (c);
	return s1 - 1;
}

char* stdimpl_strncpy(char *s1, const char *s2,unsigned int size)
{
	char *ret = s1;
	for (; size; size--){
		if (*s2) {
			*s1++ = *s2++;	ret = s1;
		} else {
			*s1++ = '\0';
		}
	}
	return ret;
}

int stdimpl_strlen(const char *str)
{
    const char *estr = str;
	char c;
	do {
		c = *estr++;
	} while (c);
    return ((int)(estr - str - 1));
}

int stdimpl_strcmp(const char *s1, const char *s2)
{
	char c1,c2;
	do {
		c1 = *s1++;
		c2 = *s2++;
	} while ((c1) && (c2) && (c1==c2));
	return c1 - c2;
}

char* stdimpl_itoa(int v,char *string,int r)
{
	char buf[33],*p;
	unsigned int vv,nega;

	nega = 0;
	vv = v;
	if (v < 0) {
		nega = 1;
		vv = -v;
	}

	p=buf;

	do {
		*p++ = "0123456789abcdef"[vv % r];
	} while (vv /= r);

	if (nega) {
		*p++ = '-';
	}

	do {
		*string++ = *--p;
	} while (buf != p);

	*string = '\0';

	return string;
}
