#include "stdImpl.h"
#include "AssertImpl.h"

void assertEqualsImplInt(int expected,int actual, long line, const char* file)
{
	char buffer[40],*bp;

	bp = stdimpl_strcpy( buffer, "exp<"		);
	bp = stdimpl_itoa( expected, bp, 10);
	bp = stdimpl_strcpy( bp, "> was<"	);
	bp = stdimpl_itoa( actual, bp, 10);
	stdimpl_strcpy( bp, ">"			);

	addFailure(buffer, line, file);
}

void assertEqualsImplCStr(const char* expected,const char* actual, long line, const char* file)
{
	char buffer[64],*bp;
	int el,al;

	if (expected) {
		el = stdimpl_strlen(expected);
	} else {
		el = 4;
		expected = "null";
	}

	if (actual) {
		al = stdimpl_strlen(actual);
	} else {
		al = 4;
		actual = "null";
	}

	if (el > 26) {
		if (al > 26) {
			al = 26;
			el = 26;
		} else {
			int w = 26 + (26 - al);
			if (el > w) {
				el = w;
			}
		}
	} else {
		int w = 26 + (26 - el);
		if (al > w) {
			al = w;
		}
	}

	bp = stdimpl_strcpy( buffer, "exp<"		);
	bp = stdimpl_strncpy(bp, expected, el);
	bp = stdimpl_strcpy( bp, "> was<"	);
	bp = stdimpl_strncpy(bp, actual,	  al);
	stdimpl_strcpy( bp, ">"			);

	addFailure(buffer, line, file);
}
