#include "TestCase.h"
#include "TestResult.h"
#include "TestCaller.h"

char* TestCaller_name(TestCallerRef self)
{
	return self->name;
}

void TestCaller_run(TestCallerRef self,TestResultRef result)
{
	int i;
	for (i=0; i<self->numberOfFixtuers; i++) {
		TestCase cs = new_TestCase( self->fixtuers[i].name,
									self->setUp,
									self->tearDown,
									self->fixtuers[i].test);
		cs.isa->run(&cs,result);
	}
}

int TestCaller_countTestCases(TestCallerRef self)
{
	return self->numberOfFixtuers;
}

const TestImplement TestCallerImplement = {
	(TestImplName)TestCaller_name,
	(TestImplRun)TestCaller_run,
	(TestImplCountTestCases)TestCaller_countTestCases,
};