#ifndef	__TESTLISTENER_H__
#define	__TESTLISTENER_H__

#include "Test.h"

typedef struct __TestListner	TestListner;
typedef struct __TestListner*	TestListnerRef;

typedef struct __TestListnerImplement	TestListnerImplement;
typedef struct __TestListnerImplement*	TestListnerImplementRef;

typedef void(*TestListnerImplStartTest)(void*,TestRef);
typedef void(*TestListnerImplEndTest)(void*,TestRef);
typedef void(*TestListnerImplAddFailure)(void*,TestRef,char*,int,char*);

struct __TestListnerImplement {
	TestListnerImplStartTest startTest;
	TestListnerImplEndTest endTest;
	TestListnerImplAddFailure addFailure;
};

struct __TestListner {
	TestListnerImplementRef isa;
};

#define TestListner_startTest(s,t)			(s)->isa->startTest(s,t)
#define TestListner_endTest(s,t)			(s)->isa->endTest(s,t)
#define TestListner_addFailure(s,t,m,l,f)	(s)->isa->addFailure(s,t,m,l,f)

#endif/*__TESTLISTENER_H__*/
