#include "config.h"
#include "stdImpl.h"
#include "TestResult.h"
#include "TestRunner.h"

static TestResult result_;

void TestRunner_startTest(TestListnerRef self,TestRef test)
{
	stdimpl_print("\t");
	stdimpl_print(Test_name(test));
	stdimpl_print("\n");
}

void TestRunner_endTest(TestListnerRef self,TestRef test)
{
}

void TestRunner_addFailure(TestListnerRef self,TestRef test,char *msg,int line,char *file)
{
	char buf[34];
	stdimpl_print("\t");
	stdimpl_print(file);
	stdimpl_print(":");
	stdimpl_itoa(line, buf, 10);
	stdimpl_print(buf);
	stdimpl_print(" ");
	stdimpl_print(msg);
	stdimpl_print("\n");
}

static const TestListnerImplement TestRunnerImplement = {
	(TestListnerImplStartTest)TestRunner_startTest,
	(TestListnerImplEndTest)TestRunner_endTest,
	(TestListnerImplAddFailure)TestRunner_addFailure,
};

static const TestRunner runner_ = {
	(TestListnerImplementRef)&TestRunnerImplement,
};

void TestRunner_init(void)
{
	TestResult_init(&result_, (TestListnerRef)&runner_);
}

void TestRunner_runt(TestRef test)
{
	stdimpl_print(Test_name(test));
	stdimpl_print(" :\n");
	Test_run(test, &result_);
}

TestResultRef TestRunner_result(void)
{
	return (TestResultRef)&result_;
}

void TestRunner_printResult(void)
{
	if (result_.numberOfFailures) {
		char buf[34];
		stdimpl_print("\nrun ");
		stdimpl_itoa(result_.numberOfTestsRun, buf, 10);
		stdimpl_print(buf);
		stdimpl_print(" failures ");
		stdimpl_itoa(result_.numberOfFailures, buf, 10);
		stdimpl_print(buf);
		stdimpl_print("\n");
	} else {
		char buf[34];
		stdimpl_print("\nOK (");
		stdimpl_itoa(result_.numberOfTestsRun, buf, 10);
		stdimpl_print(buf);
		stdimpl_print(" tests)\n");
	}
}
