#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "person.h"

PersonRef Person_alloc(void)
{
	return (PersonRef)malloc(sizeof(Person));
}

PersonRef Person_init(PersonRef self)
{
	return Person_initWithName(self, NULL);
}

PersonRef Person_initWithName(PersonRef self,char *fullname)
{
	self->fullname = NULL;
	self->firstname = NULL;
	self->lastname = NULL;
	Person_setFullName(self,fullname);
	return self;
}

PersonRef Person_personWithName(char *fullname)
{
	return Person_initWithName(Person_alloc(),fullname);
}

void Person_dealloc(PersonRef self)
{
	if (self) {
		free(self->fullname);
		free(self->firstname);
		free(self->lastname);
		free(self);
	}
}

char* Person_fullName(PersonRef self)
{
	return self->fullname;
}

char* Person_firstName(PersonRef self)
{
	return self->firstname;
}

char* Person_lastName(PersonRef self)
{
	return self->lastname;
}

static void setfullname(PersonRef self,char *fullname)
{
	free(self->fullname);
	self->fullname = NULL;
	if (fullname) {
		self->fullname = (char*)malloc(strlen(fullname)+1);
		strcpy(self->fullname,fullname);
	}
}

static void setfirstname(PersonRef self,char *firstname)
{
	free(self->firstname);
	self->firstname = NULL;
	if (firstname) {
		self->firstname = (char*)malloc(strlen(firstname)+1);
		strcpy(self->firstname,firstname);
	}
}

static void setlastname(PersonRef self,char *lastname)
{
	free(self->lastname);
	self->lastname = NULL;
	if (lastname) {
		self->lastname = (char*)malloc(strlen(lastname)+1);
		strcpy(self->lastname,lastname);
	}
}

void Person_setFullName(PersonRef self,char *fullname)
{
	setfullname(self,fullname);

	if (fullname) {
		char *p;
		int len;
		p = strchr(fullname, ' ');
		if (p) {
			len = p - fullname;
		} else {
			len = 0;
		}
		p = (char*)malloc(len + 1);
		strncpy(p,fullname,len);
		p[len] = '\0';
		setfirstname(self,p);
		free(p);
	} else {
		setfirstname(self,NULL);
	}
	if (fullname) {
		char *p = strchr(fullname, ' ');
		if (p)
			setlastname(self,p+1);
		else
			setlastname(self,"");
	} else {
		setlastname(self,NULL);
	}
}

void Person_setFirstName(PersonRef self,char *firstname)
{
	if (firstname) {
		char *p = (char*) malloc(strlen(firstname) + 1 + strlen(self->lastname) + 1);
		sprintf(p,"%s %s",firstname,self->lastname);
		setfirstname(self,firstname);
		setfullname(self,p);
	}
}

void Person_setLastName(PersonRef self,char *lastname)
{
	if (lastname) {
		char *p = (char*) malloc(strlen(self->firstname) + 1 + strlen(lastname) + 1);
		sprintf(p,"%s %s",self->firstname,lastname);
		setlastname(self,lastname);
		setfullname(self,p);
	}
}
