#include <embUnit/embUnit.h>
#include "person.h"

PersonRef personRef;

static void setUp(void)
{
	personRef = Person_personWithName("test tarou");
}

static void tearDown(void)
{
	Person_dealloc(personRef);
}

static void testfullname(void)
{
	TEST_ASSERT_EQUAL_STRING("test tarou", Person_fullName(personRef));
}

static void testfirstname(void)
{
	TEST_ASSERT_EQUAL_STRING("test", Person_firstName(personRef));
}

static void testlastname(void)
{
	TEST_ASSERT_EQUAL_STRING("tarou", Person_lastName(personRef));
}

static void testsetfullname(void)
{
	Person_setFullName(personRef, "sample hanako");

	TEST_ASSERT_EQUAL_STRING("sample hanako", Person_fullName(personRef));
	TEST_ASSERT_EQUAL_STRING("sample", Person_firstName(personRef));
	TEST_ASSERT_EQUAL_STRING("hanako", Person_lastName(personRef));
}

static void testsetfirstname(void)
{
	Person_setFirstName(personRef, "sample");

	TEST_ASSERT_EQUAL_STRING("sample tarou", Person_fullName(personRef));
	TEST_ASSERT_EQUAL_STRING("sample", Person_firstName(personRef));
	TEST_ASSERT_EQUAL_STRING("tarou", Person_lastName(personRef));
}

static void testsetlastname(void)
{
	Person_setLastName(personRef, "hanako");

	TEST_ASSERT_EQUAL_STRING("test hanako", Person_fullName(personRef));
	TEST_ASSERT_EQUAL_STRING("test", Person_firstName(personRef));
	TEST_ASSERT_EQUAL_STRING("hanako", Person_lastName(personRef));
}

static void testsetfullname_nullchar(void)
{
	Person_setFullName(personRef, "");

	TEST_ASSERT_EQUAL_STRING("", Person_fullName(personRef));
	TEST_ASSERT_EQUAL_STRING("", Person_firstName(personRef));
	TEST_ASSERT_EQUAL_STRING("", Person_lastName(personRef));
}

static void testsetfullname_null(void)
{
	Person_setFullName(personRef, NULL);

	TEST_ASSERT_NULL(Person_fullName(personRef));
	TEST_ASSERT_NULL(Person_firstName(personRef));
	TEST_ASSERT_NULL(Person_lastName(personRef));
}

TestCallerRef PersonTest_caller(void)
{
	EMB_UNIT_TESTFIXTURES(fixtures) {
		new_TestFixture("testfullname",testfullname),
		new_TestFixture("testfirstname",testfirstname),
		new_TestFixture("testlastname",testlastname),
		new_TestFixture("testsetfullname",testsetfullname),
		new_TestFixture("testsetfirstname",testsetfirstname),
		new_TestFixture("testsetlastname",testsetlastname),
		new_TestFixture("testsetfullname_nullchar",testsetfullname_nullchar),
		new_TestFixture("testsetfullname_null",testsetfullname_null),
	};
	EMB_UNIT_TESTCALLER(vPersonTest,"PersonTest",setUp,tearDown,fixtures);

	return (TestCallerRef)&vPersonTest;
}
