#ifndef	__TESTCALLER_H__
#define	__TESTCALLER_H__

#include "Test.h"

typedef struct __TestFixture	TestFixture;
typedef struct __TestFixture*	TestFixtureRef;

struct __TestFixture {
	char *name;
	void(*test)(void);
};

typedef struct __TestCaller		TestCaller;
typedef struct __TestCaller*	TestCallerRef;

struct __TestCaller {
	TestImplementRef isa;
	char *name;
	void(*setUp)(void);
	void(*tearDown)(void);
	int numberOfFixtuers;
	TestFixture	*fixtuers;
};

extern const TestImplement TestCallerImplement;

#define new_TestCaller(name,sup,tdw,numberOfFixtuers,fixtuers)\
	{\
		(TestImplementRef)&TestCallerImplement,\
		name,\
		sup,\
		tdw,\
		numberOfFixtuers,\
		fixtuers,\
	}

#define new_TestFixture(name,test)\
	{\
		name,\
		test,\
	}

#define TestCallerTypeID MakeTestTypeID('c','a','l','l')

#endif/*__TESTCALLER_H__*/
