#include "TestCase.h"
#include "TestResult.h"

static TestResultRef result_;
static TestCaseRef self_;

char* TestCase_name(TestCaseRef self)
{
	return self->name;
}

void TestCase_run(TestCaseRef self,TestResultRef result)
{
	if (result) {
		result->isa->startTest(result, self);
	}
	if (self->setUp) {
		self->setUp();
	}
	if (self->runTest) {
		TestResultRef wr =result_;	/*push*/
		TestCaseRef ws = self_;	/*push*/
		result_ = result;
		self_ = self;
		self->runTest();
		result_ = wr;	/*pop*/
		self_ = ws;	/*pop*/
	}
	if (self->tearDown) {
		self->tearDown();
	}
	if (result) {
		result->isa->endTest(result, self);
	}
}

int TestCase_countTestCases(TestCaseRef self)
{
	return 1;
}

const TestImplement TestCaseImplement = {
	(TestTypeID)				TestCaseTypeID,
	(TestNameFunction)			TestCase_name,
	(TestRunFunction)			TestCase_run,
	(TestCountTestCasesFunction)TestCase_countTestCases,
};

void addFailure(const char* msg, long line, const char* file)
{
	if (result_) {
		result_->isa->addFailure(result_, self_, (char*)msg, line, (char*)file);
	}
}
