#ifndef	__TESTCASE_H__
#define	__TESTCASE_H__

#include "Test.h"

typedef struct __TestCase	TestCase;
typedef struct __TestCase*	TestCaseRef;

struct __TestCase {
	TestImplementRef isa;
	char *name;
	void(*setUp)(void);
	void(*tearDown)(void);
	void(*runTest)(void);
};

extern const TestImplement TestCaseImplement;

#define new_TestCase(name,setUp,tearDown,runTest)\
	{\
		(TestImplementRef)&TestCaseImplement,\
		name,\
		setUp,\
		tearDown,\
		runTest,\
	}

#define TestCaseTypeID MakeTestTypeID('c','a','s','e')

#endif/*__TESTCASE_H__*/
