#ifndef	__TESTLISTENER_H__
#define	__TESTLISTENER_H__

#include "Test.h"

typedef struct __TestListnerImplement	TestListnerImplement;
typedef struct __TestListnerImplement*	TestListnerImplementRef;

typedef void(*TestListnerStartTestCallBack)(void*,void*);
typedef void(*TestListnerEndTestCallBack)(void*,void*);
typedef void(*TestListnerAddFailureCallBack)(void*,void*,char*,int,char*);

struct __TestListnerImplement {
	TestListnerStartTestCallBack startTest;
	TestListnerEndTestCallBack endTest;
	TestListnerAddFailureCallBack addFailure;
};

typedef struct __TestListner	TestListner;
typedef struct __TestListner*	TestListnerRef;

struct __TestListner {
	TestListnerImplementRef isa;
};

#define TestListner_startTest(s,t)			(s)->isa->startTest(s,t)
#define TestListner_endTest(s,t)			(s)->isa->endTest(s,t)
#define TestListner_addFailure(s,t,m,l,f)	(s)->isa->addFailure(s,t,m,l,f)

#endif/*__TESTLISTENER_H__*/
