#include "TestResult.h"

void TestResult_init(TestResultRef self,TestListnerRef listner)
{
	self->isa = (TestListnerImplementRef)&TestResultImplement;
	self->runCount = 0;
	self->failureCount = 0;
	self->listener = listner;
}

void TestResult_startTest(TestResultRef self,TestRef test)
{
	self->runCount++;
	if (self->listener) {
		TestListner_startTest(self->listener, test);
	}
}

void TestResult_endTest(TestResultRef self,TestRef test)
{
	if (self->listener) {
		TestListner_endTest(self->listener, test);
	}
}

void TestResult_addFailure(TestResultRef self,TestRef test,char *msg,int line,char *file)
{
	self->failureCount++;
	if (self->listener) {
		TestListner_addFailure(self->listener, test, msg, line, file);
	}
}

const TestListnerImplement TestResultImplement = {
	(TestListnerStartTestCallBack)	TestResult_startTest,
	(TestListnerEndTestCallBack)	TestResult_endTest,
	(TestListnerAddFailureCallBack)	TestResult_addFailure,
};
