#include "config.h"
#include "stdImpl.h"
#include "TestResult.h"
#include "TestRunner.h"

static TestResult result_;
static TestRef root_;

static void TestRunner_startTest(TestListnerRef self,TestRef test)
{
	stdimpl_print(".");
}

static void TestRunner_endTest(TestListnerRef self,TestRef test)
{
}

static void TestRunner_addFailure(TestListnerRef self,TestRef test,char *msg,int line,char *file)
{
	stdimpl_print("\n");
	stdimpl_print(Test_name(root_));
	stdimpl_print(".");
	stdimpl_print(Test_name(test));
	{
		char buf[16];
		stdimpl_print(" (");
		stdimpl_print(file);
		stdimpl_print(" ");
		stdimpl_itoa(line, buf, 10);
		stdimpl_print(buf);
		stdimpl_print(") ");
	}
	stdimpl_print(msg);
	stdimpl_print("\n");
}

static const TestListnerImplement TestRunnerImplement = {
	(TestListnerStartTestCallBack)	TestRunner_startTest,
	(TestListnerEndTestCallBack)	TestRunner_endTest,
	(TestListnerAddFailureCallBack)	TestRunner_addFailure,
};

static const TestListner testrunner_ = {
	(TestListnerImplementRef)		&TestRunnerImplement,
};

void TestRunner_start(void)
{
	TestResult_init(&result_, (TestListnerRef)&testrunner_);
}

void TestRunner_runTest(TestRef test)
{
	root_ = test;
	Test_run(test, &result_);
}

void TestRunner_end(void)
{
	char buf[16];
	if (result_.failureCount) {
		stdimpl_print("\nrun ");
		stdimpl_itoa(result_.runCount, buf, 10);
		stdimpl_print(buf);
		stdimpl_print(" failures ");
		stdimpl_itoa(result_.failureCount, buf, 10);
		stdimpl_print(buf);
		stdimpl_print("\n");
	} else {
		stdimpl_print("\nOK (");
		stdimpl_itoa(result_.runCount, buf, 10);
		stdimpl_print(buf);
		stdimpl_print(" tests)\n");
	}
}
