using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameView
{
	internal static class ButtonStringCreator
	{
		public static List<string> Split(StringBuilder printBuffer)
		{
			return syn(printBuffer);
		}

		private static List<string> syn(StringBuilder printBuffer)
		{
			string printString = printBuffer.ToString();
			if (printString.Length == 0)
				goto nonButton;
			List<string> strs = null;
			if ((!printString.Contains("[")) || (!printString.Contains("]")))
				goto nonButton;
			strs = lex(new StringStream(printString));
			if (strs == null)
				goto nonButton;
			int state = 0;
			List<string> ret = new List<string>();
			StringBuilder buffer = new StringBuilder();
			int buttonCount = 0;
			VoidMethod reduce = delegate
			{
				if (buffer.Length == 0)
					return;
				ret.Add(buffer.ToString());
				buffer.Remove(0, buffer.Length);
			};
			for (int i = 0; i < strs.Count; i++)
			{
				if (strs[i].Length == 0)
					continue;
				char c = strs[i][0];
				if (TokenReader.IsWhiteSpace(c))
				{//̋
					if ((state & 2) == 2)
					{
						reduce();
						buffer.Append(strs[i]);
						state = 0;
					}
					else
					{
						buffer.Append(strs[i]);
					}
				}
				//lȊO̓{^ȂɂB
				//else if ((c == '[') && (!isSymbols(strs[i])))
				else if ((c == '[') && (IsNumericWord(strs[i])))
				{//[]ň͂܂ꂽőI̊jƂȂ
					buttonCount++;
					if ((state & 1) == 1)
					{//bufferj܂ł
						reduce();
						buffer.Append(strs[i]);
						state = 1;
					}
					else
					{
						if ((state & 2) == 2)
						{//buffer܂ł
							buffer.Append(strs[i]);
							reduce();
							state = 0;
						}
						else
						{//buffer܂͋󔒕
							buffer.Append(strs[i]);
							state = 1;
						}
					}
				}
				else
				{//I̐ɂȂ邩Ȃ
					buffer.Append(strs[i]);
					state |= 2;
				}
			}
			reduce();
			if (buttonCount <= 1)
				goto nonButton;
			printBuffer.Remove(0, printBuffer.Length);
			return ret;
		nonButton:
			strs = new List<string>();
			strs.Add(printString);
			printBuffer.Remove(0, printBuffer.Length);
			return strs;
		}

		//readonly static IList<char> symbols = new char[]
		//{
		//    '+', '-', '*', '/', '%', '=', '!', '<', '>', '|', '&', '^', '~', 
		//    ' ', '@', '\t' ,
		//    '(', '[', '{',')', '}', ']', ',', '.', ':', ';',
		//    '#', '$', '\\', '@', '\"', '\'', '`',
		//    'E','',
		//};
		//private static bool isSymbols(string str)
		//{
		//    foreach (char c in str)
		//    {
		//        if (symbols.Contains(c))
		//            continue;
		//        return false;
		//    }
		//    return true;
		//}

		static Regex numReg = new Regex(@"\[\s*([0][xXbB])?[+-]?[0-9]+([eEpP][0-9]+)?\s*\]");

		/// <summary>
		/// []t񂪐lIł邩ǂ𒲂ׂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsNumericWord(string str)
		{
			return numReg.IsMatch(str);
		}

		delegate void VoidMethod();

		/// <summary>
		/// 啪
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		private static List<string> lex(StringStream st)
		{
			List<string> strs = new List<string>();
			int state = 0;
			int startIndex = 0;
			VoidMethod reduce = delegate
			{
				if (st.CurrentPosition == startIndex)
					return;
				int length = st.CurrentPosition - startIndex;
				strs.Add(st.Substring(startIndex, length));
				startIndex = st.CurrentPosition;
			};
			while (!st.EOS)
			{
				if (st.Current == '[')
				{
					if (state == 1)//"["
						goto unanalyzable;
					reduce();
					state = 1;
					st.ShiftNext();
				}
				else if (st.Current == ']')
				{
					if (state != 1)//"["O
						goto unanalyzable;
					st.ShiftNext();
					reduce();
					state = 0;
				}
				else if ((state == 0) && (TokenReader.IsWhiteSpace(st.Current)) && (TokenReader.IsWhiteSpace(st.Next)))
				{
					//reduce();
					TokenReader.SkipWhiteSpace(st);
					reduce();
				}
				else
				{
					st.ShiftNext();
				}
			}
			reduce();
			//while (strs.Count != 0)
			//{
			//    if (TokenReader.IsWhiteSpace(strs[strs.Count - 1][0]))
			//        strs.RemoveAt(strs.Count - 1);
			//    break;
			//}
			return strs;
		unanalyzable:
			return null;
		}
	}
}
