/*̂܂ܕ
using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameProc;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.GameData;

namespace MinorShift.Emuera.Decompiler.ERB
{
	internal static class ErbDeparser
	{




		public static void AppendErbScript(StringBuilder builder, InstructionLine line)
		{
			switch (line.Function)
			{
				case BuiltInFunctionCode.SET://SpSetArgument
					{
						SpSetArgument arg = (SpSetArgument)line.Argument;
						AppendErbScript(builder, arg.VariableDest);
						builder.Append(" = ");
						AppendErbScript(builder, arg.Term);
					}
					break;
				case BuiltInFunctionCode.SETS://SpSetsArgument
					{
						SpSetsArgument arg = (SpSetsArgument)line.Argument;
						AppendErbScript(builder, arg.VariableDest);
						builder.Append(" = ");
						AppendErbScript(builder, arg.StrForm);
					}
					break;
				case BuiltInFunctionCode.PRINT://StrArgument
				case BuiltInFunctionCode.PRINTL:
				case BuiltInFunctionCode.PRINTW:
				case BuiltInFunctionCode.PRINTC:
				case BuiltInFunctionCode.BEGIN://FLOW_CONTROL
				case BuiltInFunctionCode.GOTO://FLOW_CONTROL
				case BuiltInFunctionCode.JUMP://FLOW_CONTROL
				case BuiltInFunctionCode.CALL://FLOW_CONTROL
					{
						StrArgument arg = (StrArgument)line.Argument;
						AppendErbScript(builder, line.Function);
						builder.Append(" ");
						builder.Append(arg.Str);
					}
					break;
				case BuiltInFunctionCode.PRINTS://ExpressionArgument
				case BuiltInFunctionCode.PRINTSL:
				case BuiltInFunctionCode.PRINTSW:
				case BuiltInFunctionCode.PRINTFORMS:
				case BuiltInFunctionCode.PRINTFORMSL:
				case BuiltInFunctionCode.PRINTFORMSW:
				case BuiltInFunctionCode.PRINT_ABL://\́B͓o^ԍ
				case BuiltInFunctionCode.PRINT_TALENT://f
				case BuiltInFunctionCode.PRINT_MARK://
				case BuiltInFunctionCode.PRINT_EXP:
				case BuiltInFunctionCode.PRINT_PALAM:
				case BuiltInFunctionCode.ADDCHARA:
				case BuiltInFunctionCode.ADDSPCHARA:
				case BuiltInFunctionCode.DELCHARA:
				case BuiltInFunctionCode.SIF://FLOW_CONTROL
				case BuiltInFunctionCode.IF://FLOW_CONTROL
				case BuiltInFunctionCode.ELSEIF://FLOW_CONTROL
				case BuiltInFunctionCode.REPEAT://FLOW_CONTROL
				case BuiltInFunctionCode.RETURN://FLOW_CONTROL
					{
						ExpressionArgument arg = (ExpressionArgument)line.Argument;
						AppendErbScript(builder, line.Function);
						builder.Append(" ");
						AppendErbScript(builder, arg.Term);
					}
					break;
				case BuiltInFunctionCode.PRINTFORM://FormStrArgument
				case BuiltInFunctionCode.PRINTFORML:
				case BuiltInFunctionCode.PRINTFORMW:
				case BuiltInFunctionCode.PUTFORM:
					{
						FormStrArgument arg = (FormStrArgument)line.Argument;
						AppendErbScript(builder, line.Function);
						builder.Append(" ");
						AppendErbScript(builder, arg.StrForm);
					}
					break;
				case BuiltInFunctionCode.WAIT://VoidArgument
				case BuiltInFunctionCode.INPUT:
				case BuiltInFunctionCode.INPUTS:
				case BuiltInFunctionCode.DRAWLINE:
				case BuiltInFunctionCode.PRINT_ITEM:
				case BuiltInFunctionCode.PRINT_SHOPITEM:
				case BuiltInFunctionCode.UPCHECK:
				case BuiltInFunctionCode.QUIT:
				case BuiltInFunctionCode.SAVEGAME://FLOW_CONTROL
				case BuiltInFunctionCode.LOADGAME://FLOW_CONTROL
				case BuiltInFunctionCode.ELSE://FLOW_CONTROL
				case BuiltInFunctionCode.ENDIF://FLOW_CONTROL
				case BuiltInFunctionCode.CONTINUE://FLOW_CONTROL
				case BuiltInFunctionCode.BREAK://FLOW_CONTROL
				case BuiltInFunctionCode.REND://FLOW_CONTROL
				case BuiltInFunctionCode.RESTART://FLOW_CONTROL
					AppendErbScript(builder, line.Function);
					break;

				case BuiltInFunctionCode.PRINTV://SpPrintVArgument
				case BuiltInFunctionCode.PRINTVL:
				case BuiltInFunctionCode.PRINTVW:
					{
						SpPrintVArgument arg = (SpPrintVArgument)line.Argument;
						AppendErbScript(builder, line.Function);
						builder.Append(" ");
						for (int i = 0; i < arg.Terms.Count; i++)
						{
							if (i != 0)
								builder.Append(",");
							if ((arg.Terms[i] is SingleTerm) && (arg.Terms[i].GetOperandType() == typeof(string)))
							{
								builder.Append("'");
								AppendErbScript(builder, arg.Terms[i]);
							}
							else
							{
								if (i != 0)
									builder.Append(" ");
								AppendErbScript(builder, arg.Terms[i]);
							}
						}
					}
					break;
				case BuiltInFunctionCode.BAR://SpBarArgument
				case BuiltInFunctionCode.BARL:
					{
						SpBarArgument arg = (SpBarArgument)line.Argument;
						AppendErbScript(builder, line.Function);
						builder.Append(" ");
						AppendErbScript(builder, arg.Terms[0]);
						builder.Append(", ");
						AppendErbScript(builder, arg.Terms[1]);
						builder.Append(", ");
						AppendErbScript(builder, arg.Terms[2]);
					}
					break;
				case BuiltInFunctionCode.TIMES://SpTimesArgument
					{
						SpTimesArgument arg = (SpTimesArgument)line.Argument;
						AppendErbScript(builder, line.Function);
						builder.Append(" ");
						AppendErbScript(builder, arg.VariableDest);
						builder.Append(", ");
						builder.Append(arg.DoubleValue.ToString());
					}
					break;
				default:
					throw new ExeEE("`̊֐");
			}
			return;
		}


		static void AppendErbScript(StringBuilder buffer, IOperandTerm term)
		{
			if (term is SingleTerm)
				AppendErbScript(buffer, (SingleTerm)term);
			else if (term is VariableToken)
				AppendErbScript(buffer, (VariableToken)term);
			else if (term is UnaryExpressionTerm)
				AppendErbScript(buffer, (UnaryExpressionTerm)term);
			else if (term is BinaryExpressionTerm)
				AppendErbScript(buffer, (BinaryExpressionTerm)term);
			else
				throw new ExeEE("`̃Iyh");
		}


		static void AppendErbScript(StringBuilder buffer, SingleTerm term)
		{
			if(term.GetOperandType() == typeof(Int64))
				buffer.Append(term.Int.ToString());
			else if (term.GetOperandType() == typeof(string))
			{
				buffer.Append("\"");
				buffer.Append(term.Str.ToString());
				buffer.Append("\"");
			}
		}

		static void AppendErbScript(StringBuilder buffer, VariableToken term)
		{
			AppendErbScript(buffer, term.Identifier);
			if (IsSingle(term))
				return;
			IOperandTerm elem = null;
			for (int i = 0; i < 2; i++)
			{
				if (i == 0)
					elem = term.Element1;
				else
					elem = term.Element2;
				if (elem == null)
					break;
				buffer.Append(":");
				if ((elem is SingleTerm) || ((elem is VariableToken) && IsSingle((VariableToken)elem)))
				{
					AppendErbScript(buffer, elem);
				}
				else
				{
					buffer.Append("(");
					AppendErbScript(buffer, elem);
					buffer.Append(")");
				}
			}
		}


		static void AppendErbScript(StringBuilder buffer, UnaryExpressionTerm term)
		{
			AppendErbScript(buffer, term.Operator);
			if (GetPriority(term.Operand) >= 0)
			{
				buffer.Append("(");
				AppendErbScript(buffer, term.Operand);
				buffer.Append(")");
			}
			else
				AppendErbScript(buffer, term.Operand);
		}

		static void AppendErbScript(StringBuilder buffer, BinaryExpressionTerm term)
		{
			int priority = GetPriority(term.Operator);
			int leftP = GetPriority(term.Left);
			int rightP = GetPriority(term.Right);
			if ((leftP > 0) || (leftP < priority))
			{
				buffer.Append("(");
				AppendErbScript(buffer, term.Left);
				buffer.Append(")");
			}
			else
				AppendErbScript(buffer, term.Left);
			buffer.Append(" ");
			AppendErbScript(buffer, term.Operator);
			buffer.Append(" ");
			if ((rightP > 0) || (rightP <= priority))
			{
				buffer.Append("(");
				AppendErbScript(buffer, term.Right);
				buffer.Append(")");
			}
			else
				AppendErbScript(buffer, term.Right);
		}

		static int GetPriority(IOperandTerm term)
		{
			if (term is SingleTerm)
				return -1;
			else if (term is VariableToken)
				return -1;
			else if (term is UnaryExpressionTerm)
				return 0x100;
			else if (term is BinaryExpressionTerm)
				return GetPriority(((BinaryExpressionTerm)term).Operator);
			else
				throw new ExeEE("`̃Iyh");
		}



		static int GetPriority(OperatorCode code)
		{
			return OperatorManager.GetPriority(code);
		}

		static void AppendErbScript(StringBuilder buffer, StringForm form)
		{
			string baseStr = form.Format;
			baseStr.Replace("\\", "\\\\");
			baseStr.Replace("%", "\\%");
			baseStr.Replace("{{", "\\{{");
			baseStr.Replace("}}", "\\}}");
			List<IOperandTerm> argList = form.ArgList;
			string[] objArgList = new string[argList.Count];
			for (int i = 0; i < objArgList.Length; i++)
			{
				IOperandTerm term = argList[i];
				StringBuilder build = new StringBuilder();
				if (term.GetOperandType() == typeof(Int64))
				{
					build.Append("{");
					AppendErbScript(build, term);
					build.Append("}");
					objArgList[i] = build.ToString();
				}
				else if (term.GetOperandType() == typeof(string))
				{
					build.Append("%");
					AppendErbScript(build, term);
					build.Append("%");
					objArgList[i] = build.ToString();
				}
			}
			buffer.Append(string.Format(baseStr, objArgList));
		}

		static void AppendErbScript(StringBuilder buffer, OperatorCode code)
		{
			buffer.Append(OperatorManager.ToOperatorString(code));
		}

		static void AppendErbScript(StringBuilder buffer, BuiltInFunctionCode code)
		{
			buffer.Append(code.ToString());
		}

		static void AppendErbScript(StringBuilder buffer, VariableIdentifier id)
		{
			buffer.Append(id.Code.ToString());
		}

		static bool IsSingle(VariableToken var)
		{
			if (var.Element1 == null)
				return true;
			if (var.Element2 != null)
				return false;
			if ((var.Identifier.IsCharacterData) || !(var.Element1 is SingleTerm))
				return false;
			Int64 i = ((SingleTerm)var.Element1).Int;
			return i == 0;
		}


	}
}
*/