using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace MinorShift.Emuera.GameView
{
	internal enum DisplayLineLastState
	{
		None = 0,
		Normal = 1,
		Selected = 2,
		BackLog = 3,
	}
	internal sealed class DisplayLine
	{
        public DisplayLine(EmueraConsole parentWindow, string line, Color c, bool bold, bool italic)
        {
            parent = parentWindow;
            strs = new List<DisplayString>();
            DisplayString str = new DisplayString(parentWindow, line, c, bold, italic);
            str.ParentLine = this;
            strs.Add(str);
        }
        
        public DisplayLine(EmueraConsole parentWindow, List<DisplayString> buttons)
		{
			parent = parentWindow;
			if (buttons == null)
			{
				strs = new List<DisplayString>();
				return;
			}
			foreach (DisplayString str in buttons)
				str.ParentLine = this;
			strs = buttons;
		}
		public int LineNo = -1;
        public int StringLine = -1;
		EmueraConsole parent;
		List<DisplayString> strs = null;
        public void changeStr(List<DisplayString> str)
        {
            strs = null;
            foreach (DisplayString st in str)
                st.ParentLine = this;
            strs = str;
        }
		public void Clear(Brush brush, Graphics graph, int pointY)
		{
			Rectangle rect = new Rectangle(0, pointY, Config.Instance.WindowX, Config.Instance.LineHeight);
			graph.FillRectangle(brush, rect);
		}

		public void DrawTo(Graphics graph, int pointY, bool isBackLog, bool force)
		{
			foreach (DisplayString str in strs)
				str.DrawTo(graph, pointY, isBackLog);
		}

		public DisplayString getSelecting(int pointX)
		{
			foreach (DisplayString str in strs)
			{
				if (str.Width == -1)
					return str;
				if ((str.PointX <= pointX) && (str.PointX + str.Width >= pointX))
					return str;
			}
			return null;
		}

		public override string ToString()
		{
			if (strs == null)
				return "";
			StringBuilder builder = new StringBuilder();
			foreach (DisplayString str in strs)
				builder.Append(str.ToString());
			return builder.ToString();
		}
	}
}
