using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using MinorShift._Library;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameProc;
using MinorShift.Emuera.GameView;
namespace MinorShift.Emuera
{
	internal partial class MainWindow : Form
	{

		public MainWindow()
		{
			InitializeComponent();
			this.ResizeEnd += new EventHandler(MainWindow_ResizeEnd);
			this.Resize += new EventHandler(MainWindow_Resize);
			lastState = WindowState;
			winY = Config.Instance.WindowY;
			if (Config.Instance.SizableWindow)
				this.FormBorderStyle = FormBorderStyle.Sizable;
			else
				this.FormBorderStyle = FormBorderStyle.Fixed3D;
			setWindowSize(Config.Instance.WindowX, winY);

			int winX = Config.Instance.WindowX;
			int minimamY = 100;
			if (minimamY > this.Height)
				minimamY = this.Height;
			int maximamY = 2560;
			if (maximamY < this.Height)
				maximamY = this.Height;
			this.MinimumSize = new Size(this.Width, minimamY);
			this.MaximumSize = new Size(this.Width, maximamY);
			mainText.ForeColor = Config.Instance.ForeColor;
			mainText.BackColor = Config.Instance.BackColor;
			mainPicBox.BackColor = Config.Instance.BackColor;
			this.BackColor = Config.Instance.BackColor;

			mainText.Font = Config.Instance.Font;
			this.MaximizeBox = Config.Instance.SizableWindow;

			console = new EmueraConsole(this);
			timer.Enabled = true;
		}

		public PictureBox MainPicBox { get { return mainPicBox; } }
		public VScrollBar ScrollBar { get { return vScrollBar; } }
		private EmueraConsole console = null;
		private void timer_Tick(object sender, EventArgs e)
		{
			if (!this.Created)
				return;
			timer.Enabled = false;
			console.Initialize();
		}
		int winY;

		void MainWindow_ResizeEnd(object sender, EventArgs e)
		{
			windowResized();
		}

		FormWindowState lastState;
		//ő剻AŏResizeEndł͕߂܂Ȃ̂B
		void MainWindow_Resize(object sender, EventArgs e)
		{
			if (WindowState == lastState)
				return;
			if (WindowState == FormWindowState.Minimized)
				return;
			lastState = WindowState;
			windowResized();
		}

		private void windowResized()
		{
			int height = this.ClientSize.Height;

			if (Config.Instance.UseMenu)
			{
				height -= menuStrip.Height;
			}
			if (winY == height)
				return;
			winY = height;
			setWindowSize(Config.Instance.WindowX, winY);
		}

		private void setWindowSize(int windowX, int windowY)
		{
			this.SuspendLayout();
			Size menuSize = new Size(0, 0);
			if (Config.Instance.UseMenu)
			{
				menuStrip.Enabled = true;
				menuStrip.Visible = true;
				menuStrip.Size = new Size(windowX + vScrollBar.Width, menuStrip.Height);
				menuSize = menuStrip.Size;
			}
			else
			{
				menuStrip.Enabled = false;
				menuStrip.Visible = false;
			}
			this.ClientSize = new Size(windowX + vScrollBar.Width, windowY + menuSize.Height);
			vScrollBar.Size = new Size(vScrollBar.Width, windowY);
			vScrollBar.Location = new Point(this.ClientSize.Width - vScrollBar.Width, menuSize.Height);//new Point(windowX, menuSize.Height);
			mainPicBox.Size = new Size(windowX, windowY - (int)Config.Instance.Font.Size);
			mainPicBox.Location = new Point(0, menuSize.Height);
			if (mainPicBox.Image != null)
				mainPicBox.Image.Dispose();
			mainPicBox.Image = new Bitmap(mainPicBox.Size.Width, mainPicBox.Size.Height);
			mainText.Size = new Size(windowX, (int)Config.Instance.Font.Size);
			mainText.Location = new Point(0, menuSize.Height + mainPicBox.Height);
			this.ResumeLayout();
			if (console != null)
			{
				console.MainPicBoxSizeChanged();
				console.RefreshStrings(true);
			}
		}


		private void mainPicBox_MouseMove(object sender, MouseEventArgs e)
		{
			if (!Config.Instance.UseMouse)
				return;
			console.MoveMouse(e.Location);
		}

		private void mainPicBox_MouseDown(object sender, MouseEventArgs e)
		{
			if (!Config.Instance.UseMouse)
				return;
			if (vScrollBar.Value != vScrollBar.Maximum)
			{//\
				if ((e.Button == MouseButtons.Left) || (e.Button == MouseButtons.Right))
				{
					vScrollBar.Value = vScrollBar.Maximum;
					console.RefreshStrings(true);
				}
				return;
			}
			if (console.IsWaitingAnyKey)
			{
				if ((e.Button == MouseButtons.Left) || (e.Button == MouseButtons.Right))
				{
					if (e.Button == MouseButtons.Right)
						PressEnterKey(true);
					else
						PressEnterKey(false);
					return;
				}

			}
			if (!console.ButtonIsSelected)//I𒆂łȂȂ疳
				return;
			//ꂽȂIB
			if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
			{
				string str = console.SelectedString;
				if (str == null)
					return;
				mainText.Text = str;
				//EςȂȂXLbvǉB
				if ((Control.MouseButtons & MouseButtons.Right) == MouseButtons.Right)
					PressEnterKey(true);
				else
					PressEnterKey(false);
				return;
			}
		}



		private void vScrollBar_Scroll(object sender, ScrollEventArgs e)
		{
			//[ł[łȂȂ`T߂ɁB
			console.RefreshStrings((vScrollBar.Value == vScrollBar.Maximum) || (vScrollBar.Value == vScrollBar.Minimum));

		}


		void mainText_MouseWheel(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			//if (!Config.UseMouse)
			//	return;
			if (!vScrollBar.Enabled)
				return;
			//e.Deltaɂ͑傫ȒlĂ̂ŕ̂ݍ̗p
			int move = -Math.Sign(e.Delta) * vScrollBar.SmallChange;
			int value = vScrollBar.Value + move;
			if (value >= vScrollBar.Maximum)
				vScrollBar.Value = vScrollBar.Maximum;
			else if (value <= vScrollBar.Minimum)
				vScrollBar.Value = vScrollBar.Minimum;
			else
				vScrollBar.Value = value;
			//[ł[łȂȂ`T߂ɁB
			console.RefreshStrings((vScrollBar.Value == vScrollBar.Maximum) || (vScrollBar.Value == vScrollBar.Minimum));
		}

		private void mainText_KeyDown(object sender, KeyEventArgs e)
		{
			if (vScrollBar.Value != vScrollBar.Maximum)
			{
				vScrollBar.Value = vScrollBar.Maximum;
				console.RefreshStrings(true);
			}
			if (e.KeyCode == Keys.Return)
			{
				e.SuppressKeyPress = true;
				if (!console.IsRunning)
					PressEnterKey(false);
				return;
			}
			if(e.KeyCode == Keys.Escape)
			{
				e.SuppressKeyPress = true;
				if (!console.IsRunning)
					PressEnterKey(true);
				return;
			}
			if (console.IsRunning)
				return;
			if (e.KeyCode == Keys.Up)
			{
				e.SuppressKeyPress = true;
				movePrev(-1);
				return;
			}
			if (e.KeyCode == Keys.Down)
			{
				e.SuppressKeyPress = true;
				movePrev(1);
				return;
			}

		}
		public void PressEnterKey(bool mesSkip)
		{
			string str = mainText.Text;
			updateInputs();
			console.PressEnterKey(mesSkip, str);
		}

		string[] prevInputs = new string[100];
		int selectedInputs = 100;
		void updateInputs()
		{
			string cur = mainText.Text;
			if (string.IsNullOrEmpty(cur))
				return;
			for (int i = 0; i < prevInputs.Length - 1; i++)
			{
				prevInputs[i] = prevInputs[i + 1];
			}
			prevInputs[prevInputs.Length - 1] = cur;
			mainText.Text = "";
			selectedInputs = prevInputs.Length;
		}

		void movePrev(int move)
		{
			if(move == 0)
				return;
			if((selectedInputs != prevInputs.Length) &&(prevInputs[selectedInputs] != mainText.Text))
				selectedInputs =  prevInputs.Length;
			int next = selectedInputs + move;
			if((next<0)||(next>prevInputs.Length))
				return;
			if(next == prevInputs.Length)
			{
				selectedInputs = next;
				mainText.Text = "";
				return;
			}
			if(string.IsNullOrEmpty(prevInputs[next]))
				return;
		
			selectedInputs = next;
			mainText.Text = prevInputs[next];
			mainText.SelectionStart = 0;
			mainText.SelectionLength = mainText.Text.Length;
			return;
		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("Q[I܂", "I", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.Close();

		}

		private void rebootToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("Q[ċN܂", "ċN", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.Reboot();
		}

		private void loadToolStripMenuItem_Click(object sender, EventArgs e)
		{
			openFileDialog.InitialDirectory = Program.ExeDir;
			DialogResult result = openFileDialog.ShowDialog();
			string filepath = openFileDialog.FileName;
			if (!File.Exists(filepath))
			{
				MessageBox.Show("t@C܂", "File Not Found");
				return;
			}
		}

		public void Reboot()
		{
			Program.Reboot = true;
			this.Close();
		}

        public void GotoTitle()
        {
            console.GotoTitle(); 
        }

        public void ReloadErb()
        {
            console.ReloadErb();
        }

        private void mainPicBox_MouseLeave(object sender, EventArgs e)
        {
			if (Config.Instance.UseMouse)
                console.LeaveMouse();
        }

		private void RtBOCToolStripMenuItem_Click(object sender, EventArgs e)
		{
			ConfigDialog dialog = new ConfigDialog();
			dialog.SetConfig();
			dialog.ShowDialog();
			if (dialog.Result == ConfigDialogResult.SaveReboot)
			{
				Program.Reboot = true;
				this.Close();
			}
		}

        private void ^Cg֖߂TToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("^Cgʂ֖߂܂", "^Cgʂɖ߂", MessageBoxButtons.OKCancel);
            if (result != DialogResult.OK)
                return;
            this.GotoTitle();
        }

        private void R[hǂݒcToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("ERBt@Cǂݒ܂", "ERBt@Cǂݒ", MessageBoxButtons.OKCancel);
            if (result != DialogResult.OK)
                return;
            this.ReloadErb();

        }
	}
}