﻿using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.GameData.Variable
{
	internal class VariableLocal
	{
		public VariableLocal(int size)
		{
			this.size = size;
		}
		readonly int size;
		public int Size
		{
			get
			{
				return size;
			}
		}
		Dictionary<string, long[]> localVars = new Dictionary<string, long[]>();

		public Int64 GetValue(string key, long index)
		{
			long[] varList = getVarList(key);
			return varList[index];
		}
		public void SetValue(string key, long index, long value)
		{
			long[] varList = getVarList(key);
			varList[index] = value;
		}

		public void Clear()
		{
			localVars.Clear();
		}

		private long[] getVarList(string key)
		{

			long[] varList = null;
			if (localVars.ContainsKey(key))
				varList = localVars[key];
			else
			{
				varList = new long[size];
				localVars.Add(key, varList);
			}
			return varList;
		}
	}

    internal class VariableLocalString
    {
        public VariableLocalString(int size)
        {
            this.size = size;
        }
        readonly int size;
        public int Size
        {
            get
            {
                return size;
            }
        }
        Dictionary<string, String[]> localVars = new Dictionary<string, String[]>();

        public String GetValue(string key, long index)
        {
            String[] varList = getVarList(key);
            return varList[index];
        }
        public void SetValue(string key, long index, String value)
        {
            String[] varList = getVarList(key);
            varList[index] = value;
        }

        public void Clear()
        {
            localVars.Clear();
        }

        private String[] getVarList(string key)
        {

            String[] varList = null;
            if (localVars.ContainsKey(key))
                varList = localVars[key];
            else
            {
                varList = new String[size];
                localVars.Add(key, varList);
            }
            return varList;
        }
    }

    internal class VariableArg
    {
        public VariableArg(int size)
        {
            this.size = size;
        }
        readonly int size;
        public int Size
        {
            get
            {
                return size;
            }
        }
        Dictionary<string, long[]> localVars = new Dictionary<string, long[]>();

        public Int64 GetValue(string key, long index)
        {
            long[] varList = getVarList(key);
            return varList[index];
        }
        public void SetValue(string key, long index, long value)
        {
            long[] varList = getVarList(key);
            varList[index] = value;
        }

        public void Clear()
        {
            localVars.Clear();
        }

        private long[] getVarList(string key)
        {

            long[] varList = null;
            if (localVars.ContainsKey(key))
                varList = localVars[key];
            else
            {
                varList = new long[size];
                localVars.Add(key, varList);
            }
            return varList;
        }
    }

    internal class VariableArgString
    {
        public VariableArgString(int size)
        {
            this.size = size;
        }
        readonly int size;
        public int Size
        {
            get
            {
                return size;
            }
        }
        Dictionary<string, String[]> localVars = new Dictionary<string, String[]>();

        public String GetValue(string key, long index)
        {
            String[] varList = getVarList(key);
            return varList[index];
        }
        public void SetValue(string key, long index, String value)
        {
            String[] varList = getVarList(key);
            varList[index] = value;
        }

        public void Clear()
        {
            localVars.Clear();
        }

        private String[] getVarList(string key)
        {

            String[] varList = null;
            if (localVars.ContainsKey(key))
                varList = localVars[key];
            else
            {
                varList = new String[size];
                localVars.Add(key, varList);
            }
            return varList;
        }
    }
}
