using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameView
{
	internal sealed class ButtonPrimitive
	{
		public string Str = "";
		public Int64 Input;
		public bool CanSelect = false;
	}

	internal static class ButtonStringCreator
	{
		public static List<string> Split(string printBuffer)
		{
			List<ButtonPrimitive> list = syn(printBuffer);
			List<string> ret = new List<string>();
			foreach(ButtonPrimitive p in list)
				ret.Add(p.Str);
			return ret;
		}
		//public static List<ButtonPrimitive> Split(string printBuffer)
		//{
		//    return syn(printBuffer);
		//}

		private static List<ButtonPrimitive> syn(string printBuffer)
		{
			string printString = printBuffer.ToString();
			List<ButtonPrimitive> ret = new List<ButtonPrimitive>();
			if (printString.Length == 0)
				goto nonButton;
			List<string> strs = null;
			if ((!printString.Contains("[")) || (!printString.Contains("]")))
				goto nonButton;
			strs = lex(new StringStream(printString));
			if (strs == null)
				goto nonButton;
			bool beforeButton = false;//ŏ̃{^i"[1]"ƂjOɃeLXg
			bool afterButton = false;//Ō̃{^i"[1]"ƂjɃeLXg
			int buttonCount = 0;
			for (int i = 0; i < strs.Count; i++)
			{
				if (strs[i].Length == 0)
					continue;
				char c = strs[i][0];
				if (TokenReader.IsWhiteSpace(c))
				{//̋
				}
				//lȊO̓{^ȂɂB
				//else if ((c == '[') && (!isSymbols(strs[i])))
				else if (c == '[')
				{//[]ň͂܂ꂽBI̊jƂȂ邩ǂ͂̒iKł͔肵ȂB
					buttonCount++;
					afterButton = false;
				}
				else
				{//I̐ɂȂ邩Ȃ
					afterButton = true;
					if (buttonCount == 0)
						beforeButton = true;
				}
			}
			//if (buttonCount <= 1)
			//	goto nonButton;//{^̏ꍇsvB
			buttonCount = 0;
			bool alignmentRight = !beforeButton && afterButton;//̓{^̉EŒ
			bool alignmentLeft = beforeButton && !afterButton;//̓{^̍Œ
			bool alignmentEtc = !alignmentRight && !alignmentLeft;//Ջ@ς
			bool canSelect = false;
			Int64 input = 0;

			int state = 0;
			StringBuilder buffer = new StringBuilder();
			VoidMethod reduce = delegate
			{
				if (buffer.Length == 0)
					return;
				ButtonPrimitive button = new ButtonPrimitive();
				button.Str = buffer.ToString();
				button.CanSelect = canSelect;
				button.Input = input;
				ret.Add(button);
				buffer.Remove(0, buffer.Length);
				canSelect = false;
				input = 0;
			};
			for (int i = 0; i < strs.Count; i++)
			{
				if (strs[i].Length == 0)
					continue;
				char c = strs[i][0];
				if (TokenReader.IsWhiteSpace(c))
				{//̋
					if (((state & 3) == 3) && (alignmentEtc) && (strs[i].Length >= 2))
					{//jƐ܂񂾂̂Ă΃{^B
						//ꕶȉ̃Xy[X̓LjViCBLwʑ΍
                        reduce();
						buffer.Append(strs[i]);
						state = 0;
					}
					else
					{
						buffer.Append(strs[i]);
					}
					continue;
				}
				//lȊO̓{^ȂɂB
				//else if ((c == '[') && (!isSymbols(strs[i])))
				if ((c == '[') && (strs[i].Length > 2) && (isNumericWord(strs[i])))
				{//[]ň͂܂ꂽőI̊jƂȂ

					StringStream stInt = new StringStream(strs[i].Substring(1, strs[i].Length - 2));
					TokenReader.SkipWhiteSpace(stInt);
					Int64 inpL = 0;
					bool b = true;
					try
					{
						inpL = TokenReader.ReadInt64(stInt).Int;
					}
					catch
					{ b = false; }
					if (b)
					{
						buttonCount++;
						if (((state & 1) == 1) || alignmentRight)
						{//bufferɊj܂łA͋IɉEzu
							reduce();
							buffer.Append(strs[i]);
							input = inpL;
							canSelect = true;
							state = 1;
						}//((state & 2) == 2) || 
						else if (alignmentLeft)
						{//buffer܂łA͋Iɍzu
							buffer.Append(strs[i]);
							input = inpL;
							canSelect = true;
							reduce();
							state = 0;
						}
						else
						{//buffer܂͋󔒕
							buffer.Append(strs[i]);
							input = inpL;
							canSelect = true;
							state = 1;
						}
						continue;
					}
				}
				else
				{//I̐ɂȂ邩Ȃ
					
					buffer.Append(strs[i]);
					state |= 2;
				}
				
			};
			reduce();
			return ret;
		nonButton:
			ret = new List<ButtonPrimitive>();
			ButtonPrimitive singleButton = new ButtonPrimitive();
			singleButton.Str = printString;
			ret.Add(singleButton);
			return ret;
		}
		readonly static Regex numReg = new Regex(@"\[\s*([0][xXbB])?[+-]?[0-9]+([eEpP][0-9]+)?\s*\]");

		/// <summary>
		/// []t񂪐lIł邩ǂ𒲂ׂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		private static bool isNumericWord(string str)
		{
			return numReg.IsMatch(str);
		}
		public static bool IsNumericWord(string str)
		{
			return numReg.IsMatch(str);
		}

		delegate void VoidMethod();

		/// <summary>
		/// 啪
		/// "[1]  [2]  ""[1]"," ", ""," ","[2]"," ",""," "ɕ
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		private static List<string> lex(StringStream st)
		{
			List<string> strs = new List<string>();
			int state = 0;
			int startIndex = 0;
			VoidMethod reduce = delegate
			{
				if (st.CurrentPosition == startIndex)
					return;
				int length = st.CurrentPosition - startIndex;
				strs.Add(st.Substring(startIndex, length));
				startIndex = st.CurrentPosition;
			};
			while (!st.EOS)
			{
				if (st.Current == '[')
				{
					if (state == 1)//"["
						goto unanalyzable;
					reduce();
					state = 1;
					st.ShiftNext();
				}
				else if (st.Current == ']')
				{
					if (state != 1)//"["O
						goto unanalyzable;
					st.ShiftNext();
					reduce();
					state = 0;
				}
				else if ((state == 0) && (TokenReader.IsWhiteSpace(st.Current)))
				{
					reduce();
					TokenReader.SkipWhiteSpace(st);
					reduce();
				}
				else
				{
					st.ShiftNext();
				}
			}
			reduce();
			return strs;
		unanalyzable:
			return null;
		}

	}
}
