using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using MinorShift.Emuera.Sub;
using System.Windows.Forms;

namespace MinorShift.Emuera.GameView
{
	internal sealed class DisplayString
	{
		public DisplayString(EmueraConsole parentWindow, string line, StringStyle theStyle)
		{
			parent = parentWindow;
			if (line == null)
			{
				Str = "";
				return;
			}
			Str = line;
			style = theStyle;
			//'['ΏI
			if (line.IndexOf('[') < 0)
				return;
			StringStream st = new StringStream(line);
			int nest = 0;
			List<string> inputsList = new List<string>();
			StringBuilder builder = new StringBuilder();
			bool lastIsOpenBracet = false;
			while (!st.EOS)
			{
				if (st.Current == '[')
				{
					st.ShiftNext();
					builder.Remove(0, builder.Length);
					nest++;
					lastIsOpenBracet = true;
					continue;
				}
				if (st.Current == ']')
				{
					st.ShiftNext();
					if ((lastIsOpenBracet) && (builder.Length != 0))
						inputsList.Add(builder.ToString());
					builder.Remove(0, builder.Length);
					lastIsOpenBracet = false;
					nest--;
					continue;
				}
				if (nest != 0)
					builder.Append(st.Current);
				st.ShiftNext();
			}
			if (nest != 0)//Ή֌WȂ疳
				return;
			if (inputsList.Count == 0)//g[NȂI
				return;
			Inputs = null;
			string str = null;
			for (int i = 0; i < inputsList.Count; i++)
			{
				if (string.IsNullOrEmpty(inputsList[i]))
					continue;
				str = inputsList[i].Trim();
				if (str.Length == 0)
					continue;
				if (Inputs == null)
					Inputs = str;
				//ƂĔFł̂΍ŗD
				if (ButtonStringCreator.IsNumericWord("["+str+"]"))
				{
					StringStream stInt = new StringStream(str);
					TokenReader.SkipWhiteSpace(stInt);
					try
					{
						Input = TokenReader.ReadInt64(stInt).Int;
					}
					catch
					{
						continue;
					}
					IsInteger = true;
					Inputs = str;
					break;
				}

				if (Int64.TryParse(str, out Input))
				{
				}
				//[***...]ƂEĂĂ̂ŃV{Ŏn܂ꍇ͋p
				if (!char.IsSymbol(str[0]))
					continue;
			}
			if (Inputs == null)
				return;
			IsButton = true;
			Generation = parent.NewButtonGeneration;
			parent.LastButtonGeneration = Generation;

		}
		EmueraConsole parent;

		public DisplayLine ParentLine;
		public string Str;
		public bool IsButton;
		public bool IsInteger;
		public Int64 Input;
		public string Inputs;
		public int PointX;
		public int Width = -1;
		public int Generation;
		private StringStyle style;
		public void DrawTo(Graphics graph, int pointY, bool isBackLog)
		{
			Font font = Config.Instance.GetFont(style.FontStyle);
			Color color = style.Color;
			if ((IsButton) && (parent.SelectingButton == this))
				color = Config.Instance.FocusColor;
			else if (isBackLog && style.Color == Config.Instance.ForeColor)
				color = Config.Instance.LogColor;

			if (Config.Instance.UseGDIplus)
			{
				graph.DrawString(Str, font, new SolidBrush(color), new Point(PointX, pointY));
			}
			else
			{
				TextRenderer.DrawText(graph, Str, font, new Point(PointX, pointY), color, TextFormatFlags.NoPrefix);
			}
		}

		public override string ToString()
		{
			if (Str == null)
				return "";
			return Str;
		}
	}
}
