using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using MinorShift._Library;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameProc;
using System.Drawing.Imaging;

namespace MinorShift.Emuera.GameView
{
    //o͑҂̏󋵁B
    internal enum ConsoleState
    {
        Initializing = 0,
        WaitKey = 1,//WAIT
        WaitSystemInteger = 2,//SystemvInput
        WaitInteger = 3,//INPUT
        WaitString = 4,//INPUTS
        Quit = 5,//QUIT
        Error = 6,//Exceptionɂ鋭I
        Running = 7,
        WaitIntegerWithTimer = 8,
        WaitStringWithTimer = 9,
        Timeout = 10,
        Timeouts = 11,
    }
    internal sealed class EmueraConsole
    {
        public EmueraConsole(MainWindow parent)
        {
            window = parent;

			lineHeight = Config.Instance.LineHeight;
            setStBar();
            state = ConsoleState.Initializing;
			if (Config.Instance.FPS > 0)
				msPerFrame = 1000 / (uint)Config.Instance.FPS;
            displayLineList = new List<DisplayLine>();
            MainPicBoxSizeChanged();
        }

        private readonly MainWindow window;
        private readonly int lineHeight;
        private readonly List<DisplayLine> displayLineList;

		public bool Enabled
		{
			get { return window.Created; }
		}
        Process emuera;
        ConsoleState state = ConsoleState.Initializing;
        DisplayString selectingButton = null;

        string stBar;
        StringBuilder printBuffer = new StringBuilder();

        internal DisplayString SelectingButton { get { return selectingButton; } }
		internal bool IsRunning
		{
			get
			{
				if (state == ConsoleState.Initializing)
					return true;
				return state == ConsoleState.Running;
			}
		}
        internal bool IsWaitingAnyKey
        {
            get
            {
                return ((state == ConsoleState.WaitKey) || (state == ConsoleState.Quit) || (state == ConsoleState.Error));
            }
        }

        internal ConsoleState State { get { return state; } }
        internal bool ButtonIsSelected { get { return selectingButton != null; } }

        internal string SelectedString
        {
            get
            {
                if (selectingButton == null)
                    return null;
                if ((state == ConsoleState.WaitInteger) && (selectingButton.IsInteger))
                    return selectingButton.Input.ToString();
                if ((state == ConsoleState.WaitSystemInteger) && (selectingButton.IsInteger))
                    return selectingButton.Input.ToString();
                if (state == ConsoleState.WaitString)
                    return selectingButton.Inputs;
                return null;
            }
        }

        bool lastButoonIsInput = true;
        int lastButtonGeneration = 0;//ŌɒǉꂽI̐BƐオvȂI͑IłȂB
        int newButtonGeneration = 0;//ɒǉI̐BInputInputsƂɑ

        public int LastButtonGeneration
        {
            get { return lastButtonGeneration; }
            set { lastButtonGeneration = value; }
        }
        public int NewButtonGeneration
        {
            get { return newButtonGeneration; }
            set { newButtonGeneration = value; }
        }

        public void Initialize()
        {
            emuera = new Process(this);
            if (!emuera.Initialize())
            {
                state = ConsoleState.Error;
                outputEmueraLog();
                PrintFlash(false);
                RefreshStrings(true);
                return;
            }
            CallEmueraProgram("");
            RefreshStrings(true);
        }

        public void ReadInteger() { state = ConsoleState.WaitInteger; }
        public void ReadSystemInteger() { state = ConsoleState.WaitSystemInteger; }
        public void ReadString() { state = ConsoleState.WaitString; }
        public void ReadAnyKey() { state = ConsoleState.WaitKey; }
        public void Quit() { state = ConsoleState.Quit; }
        public void ThrowError() { state = ConsoleState.Error; }

        private Timer timer;
        private Int64 result = 0;
        int countTime = 0;
        int timeLimit = 0;
        bool isDisp;
        private void setTimer(int time)
        {
            countTime = 0;
            timeLimit = time;
            timer = new Timer();
            timer.Tick += new EventHandler(endTimer);
            timer.Interval = 100;
            timer.Enabled = true;
            int start = timeLimit / 100;
            if (isDisp)
            {
                string timeString1 = "c ";
                string timeString2 = ((double)start / 10.0).ToString();
                PrintLine(timeString1 + timeString2);
            }
        }

        public void ReadIntegerWithTimer(Int64 time, Int64 def_result, Int64 isDisplay) 
        {
            result = def_result;
            state = ConsoleState.WaitIntegerWithTimer;
            isDisp = isDisplay != 0;
            setTimer((int)time);
        }

        string results = "";
        public void ReadStringWithTimer(Int64 time, string def_result, Int64 isDisplay)
        {
            results = def_result;
            state = ConsoleState.WaitStringWithTimer;
            isDisp = isDisplay != 0;
            setTimer((int)time);
        }

        private void stopTimer()
        {
            timer.Enabled = false;
        }

        private void endTimer(object sender, EventArgs e)
        {
            countTime += 100;
            if (countTime >= timeLimit)
            {
                stopTimer();
                if (isDisp)
                    changeLastLine("Ԑ؂");
                else
                    PrintLine("Ԑ؂");
                if (state == ConsoleState.WaitIntegerWithTimer)
                    state = ConsoleState.Timeout;
                else
                    state = ConsoleState.Timeouts;
                CallEmueraProgram("");
                return;
            }
            if (!isDisp)
                return;
            int time = (timeLimit - countTime) / 100;
            string timeString1 = "c ";
            string timeString2 = ((double)time / 10.0).ToString();
            changeLastLine(timeString1 + timeString2);
        }

        private void CallEmueraProgram(string str)
        {
            Int64 input = 0;
            if (state == ConsoleState.WaitInteger)
            {
                if (!Int64.TryParse(str, out input))
                    return;
                emuera.InputInteger(input);
            }
            else if (state == ConsoleState.WaitSystemInteger)
            {
                if (!Int64.TryParse(str, out input))
                    return;
                emuera.InputSystemInteger(input);
            }
            else if (state == ConsoleState.WaitString)
            {
                emuera.InputString(str);
            }
            else if (state == ConsoleState.WaitIntegerWithTimer)
            {
                if (!Int64.TryParse(str, out input))
                    return;
                stopTimer();
                emuera.InputInteger(input);
            }
            else if (state == ConsoleState.WaitStringWithTimer)
            {
                stopTimer();
                emuera.InputString(str);
            }
            else if (state == ConsoleState.Timeout)
            {
                emuera.InputInteger(result);
                str = result.ToString();
            }
            else if (state == ConsoleState.Timeouts)
            {
                emuera.InputString(results);
                str = results;
            }
            Print(str);
            PrintFlash(false);
            RefreshStrings(false);
            state = ConsoleState.Running;
            emuera.DoScript();
            if (state == ConsoleState.Error)
            {
                state = ConsoleState.Error;
                outputEmueraLog();
            }
            else if (state == ConsoleState.Running)
            {//RunningȂProcess͏pׂ
                state = ConsoleState.Error;
                PrintLine("emuera.exẽG[FvȌԂł܂");
                outputEmueraLog();
            }
            PrintFlash(false);
            //ÂIIłȂ悤ɁBINPUTŎgIINPUTSɂ͗płȂ悤ɁB
            if ((state == ConsoleState.WaitInteger) || (state == ConsoleState.WaitSystemInteger))
            {
                if (lastButtonGeneration == newButtonGeneration)
                    unchecked { newButtonGeneration++; }
                else if (!lastButoonIsInput)
                    lastButtonGeneration = newButtonGeneration;
                lastButoonIsInput = true;
            }
            if (state == ConsoleState.WaitString)
            {
                if (lastButtonGeneration == newButtonGeneration)
                    unchecked { newButtonGeneration++; }
                else if (lastButoonIsInput)
                    lastButtonGeneration = newButtonGeneration;
                lastButoonIsInput = false;
            }
        }

        readonly string[] spliter = new string[] { "\\n", "\r\n", "\n", "\r" };//{̉sR[h邱Ƃ͖͂ǈꉞ
        public void PressEnterKey(bool mesSkip, string str)
        {
			if ((state == ConsoleState.Running) || (state == ConsoleState.Initializing))
				return;
            if ((state == ConsoleState.Error) || (state == ConsoleState.Quit))
            {
                window.Close();
                return;
            }
            if (str.StartsWith("@"))
            {
                doSystemCommand(str);
                return;
            }
            string[] text = str.Split(spliter, StringSplitOptions.None);
            for (int i = 0; i < text.Length; i++)
            {
                string inputs = text[i];
                if (inputs.IndexOf("\\e") >= 0)
                {
                    inputs = inputs.Replace("\\e", "");//\ȅ
                    mesSkip = true;
                }
                CallEmueraProgram(inputs);
                if (mesSkip)
                    while (state == ConsoleState.WaitKey)
                        CallEmueraProgram("");
                mesSkip = false;
                if (state == ConsoleState.Error)
                    break;
            }
            RefreshStrings(true);
        }

        void doSystemCommand(string command)
        {
			if (!Config.Instance.UseDebugCommand)
            {
                PrintLine("fobOR}hgpłȂݒɂȂĂ܂");
                RefreshStrings(true);
                return;
            }
            StringComparison sc = StringComparison.CurrentCultureIgnoreCase;
			if (!Config.Instance.IgnoreCase)
                sc = StringComparison.Ordinal;
            Print(command);
            PrintFlash(false);
            RefreshStrings(true);
            string com = command.Substring(1);
            if (com.Length == 0)
                return;
            if (com.Equals("REBOOT", sc))
            {
                window.Reboot();
                return;
            }
            else if (com.Equals("OUTPUT", sc))
            {
                this.outputEmueraLog();
                return;
            }
            else if ((com.Equals("QUIT", sc)) || (com.Equals("EXIT", sc)))
            {
                window.Close();
                return;
            }
            else
            {
                try
                {
                    LogicalLine line = LogicalLineParser.ParseLine(com, null);
                    if (line is InvalidLine)
                        throw new CodeEE(line.ErrMes);
                    if (!(line is InstructionLine))
                        throw new CodeEE("fobOR}hŎgpł̂͑ߕł");
                    InstructionLine func = (InstructionLine)line;
                    if (BuiltInFunctionManager.IsFlowContorol(func.Function))
                        throw new CodeEE("t[䖽߂͎gpł܂");
                    switch (func.Function)
                    {
                        case BuiltInFunctionCode.PUTFORM:
                        case BuiltInFunctionCode.UPCHECK:
                        case BuiltInFunctionCode.WAIT:
                        case BuiltInFunctionCode.INPUT:
                        case BuiltInFunctionCode.INPUTS:
                        case BuiltInFunctionCode.PRINTW:
                        case BuiltInFunctionCode.PRINTVW:
                        case BuiltInFunctionCode.PRINTSW:
                        case BuiltInFunctionCode.PRINTFORMW:
                        case BuiltInFunctionCode.PRINTFORMSW:
                            throw new CodeEE(func.Function.ToString() + "߂͎gpł܂");
                    }
                    LogicalLineParser.SetArgumentTo(func, null);
                    if (func.IsError)
                        throw new CodeEE(func.ErrMes);
                    emuera.DoDebugNormalFunction(func);
                    if ((func.Function == BuiltInFunctionCode.SET) || (func.Function == BuiltInFunctionCode.SETS))
                        PrintLine(func.Position.RowLine);
                    PrintFlash(false);
                }
                catch (Exception e)
                {
                    PrintLine(e.Message);
                }
            }
            RefreshStrings(true);

        }

        public void MainPicBoxSizeChanged()
        {
            lastLineNo = -1;
            rgbValues = new int[window.MainPicBox.Width * (window.MainPicBox.Height * 2)];
        }

        DisplayString lastSelectingButton = null;
        int lastLineNo = -1;
        int lineNo = 0;
        int StringNo = 0;
        bool deletedLine = false;
        private void addDisplayLine(DisplayLine line)
        {
            if (reUse)
            {
                changeLastLine(line.ToString());
                reUse = false;
                return;
            }
            line.LineNo = lineNo;
            line.StringLine = StringNo;
            displayLineList.Add(line);
            lineNo++;
            if (lineNo == int.MaxValue)
            {
                lastLineNo = -1;
                lineNo = 0;
            }
			if (displayLineList.Count > Config.Instance.MaxLog)
                displayLineList.RemoveAt(0);
        }

        public void deleteLine(Int32 argNum)
        {
            int dLine = displayLineList[displayLineList.Count - 1].StringLine;
            int deleted = 0;
            int delNum = 0;
			Int32 num = argNum;
			if (argNum > displayLineList.Count)
				num = displayLineList.Count;
            while (delNum < num)
            {
                displayLineList.RemoveAt(displayLineList.Count - 1);
                deleted++;
                if (displayLineList[displayLineList.Count - 1].StringLine != dLine)
                {
                    delNum++;
                }
            }
            lineNo -= deleted;
            if (lineNo < 0)
            {
                lineNo += int.MaxValue;
            }
            lastLineNo = lineNo - 1;
            deletedLine = true;
            StringNo = displayLineList[displayLineList.Count - 1].StringLine + 1;
            if (StringNo == int.MaxValue)
            {
                StringNo = 0;
            }
            RefreshStrings(true);
        }

        bool reUse = false;
        public bool ReUse 
        {
            get { return reUse; } 
            set { reUse = value; }
        }
        //ŏIs{̍sǉɂ͂̍sėp悤ɐݒ
        public void reuseLastLine(string str)
        {
            reUse = true;
            changeLastLine(str);
        }

        //ŏIs
        public void changeLastLine(string str)
        {
            DisplayString new_str = new DisplayString(this, str, StringStyle);
            List<DisplayString> button = new List<DisplayString>();

            button.Add(new_str);
            displayLineList[displayLineList.Count - 1].changeStr(button);
            int pointY = window.MainPicBox.Height - lineHeight;
            Graphics graph = Graphics.FromImage(window.MainPicBox.Image); 
            displayLineList[displayLineList.Count - 1].Clear(new SolidBrush(Config.Instance.BackColor), graph, pointY);
            displayLineList[displayLineList.Count - 1].DrawTo(graph, pointY, false, true);
            if (graph != null)
                graph.Dispose();
            window.Refresh();
        }

        uint lastUpdate = 0;
        uint msPerFrame = 1000 / 60;//60FPS
        int skippedFrame = 0;
        public bool needRefresh = false;
        public bool hasWaitRefresh = false;
        public void RefreshStrings(bool force)
        {
            bool isBackLog = window.ScrollBar.Value != window.ScrollBar.Maximum;
            if (selectingButton != null)
            {
                //\͑I
                if (isBackLog)
                    selectingButton = null;
                //l̓͑҂ԂłȂΖ
                else if ((state != ConsoleState.WaitInteger) && (state != ConsoleState.WaitString)
                && (state != ConsoleState.WaitSystemInteger))
                    selectingButton = null;
                //IŐVłȂȂ疳
                else if (selectingButton.Generation != lastButtonGeneration)
                    selectingButton = null;
            }
            if ((!isBackLog) && (lastLineNo == lineNo) && (lastSelectingButton == selectingButton))
                return;
            //Environment.TickCount͕\̂winmm̃^C}[Ăŗ
            uint sec = WinmmTimer.TickCount - lastUpdate;
            //܂^C~OłȂȂ玟̍XV҂Ă݂
            //A͑҂ȂǁA΂炭XṼ^C~OȂꍇɂ͋IɏĂ݂
            if (sec < msPerFrame && (state == ConsoleState.Running || state == ConsoleState.Initializing))
            {
                if (emuera.isInitialized)
                    needRefresh = true;
                return;
            }
            //forcełȂȂł邾ĕ`T
            if (!force && !isBackLog)
            {
                int nSkipped = (int)(sec / msPerFrame);
                skippedFrame += nSkipped;
                //܂XLbvłꍇɂ͂Ŗ߂
                //ߋO̓XLbv񐔂炵ĂȂׂ`悪N₷
				if (skippedFrame <= Config.Instance.SkipFrame)
                {
                    lastUpdate = WinmmTimer.TickCount;
                    hasWaitRefresh = true;
                    return;
                }
            }
            needRefresh = false;
            hasWaitRefresh = false;
            skippedFrame = 0;
            lastUpdate = WinmmTimer.TickCount;
            barUpdate();
            int pointY = window.MainPicBox.Height - lineHeight;
            Graphics graph = null;
            if ((!isBackLog) && (lastLineNo > 0) && ((lineNo - lastLineNo - 1) < window.MainPicBox.Height / lineHeight) && (!deletedLine))
            {//ʂɈړ
                int newLineNum = lineNo - lastLineNo;
                if (newLineNum != 0)
                    shiftBitmap((Bitmap)window.MainPicBox.Image, newLineNum * lineHeight);
				graph = Graphics.FromImage(window.MainPicBox.Image);
				//graph.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SingleBitPerPixel;
				//graph.PixelOffsetMode = System.Drawing.Drawing2D.PixelOffsetMode.HighSpeed;
                if (newLineNum != 0)
                {
                    for (int i = window.ScrollBar.Value - 1; i >= window.ScrollBar.Value - newLineNum; i--)
                    {
						displayLineList[i].Clear(new SolidBrush(Config.Instance.BackColor), graph, pointY);
                        displayLineList[i].DrawTo(graph, pointY, isBackLog, true);
                        pointY -= lineHeight;
                        if (pointY < (0 - lineHeight))
                            break;
                    }
                }
                if (lastSelectingButton != selectingButton)
                {
                    DisplayLine target = null;
                    if (lastSelectingButton != null)
                    {
                        target = lastSelectingButton.ParentLine;
                        int pointCount = displayLineList[window.ScrollBar.Value - 1].LineNo - target.LineNo;
                        pointY = window.MainPicBox.Height - lineHeight - pointCount * lineHeight;
						target.Clear(new SolidBrush(Config.Instance.BackColor), graph, pointY);
                        target.DrawTo(graph, pointY, isBackLog, true);
                    }
                    if ((selectingButton != null) &&
                    !((lastSelectingButton != null) && (lastSelectingButton.ParentLine == selectingButton.ParentLine)))
                    {
                        target = selectingButton.ParentLine;
                        int pointCount = displayLineList[window.ScrollBar.Value - 1].LineNo - target.LineNo;
                        pointY = window.MainPicBox.Height - lineHeight - pointCount * lineHeight;
						target.Clear(new SolidBrush(Config.Instance.BackColor), graph, pointY);
                        target.DrawTo(graph, pointY, isBackLog, true);
                    }
                }
            }
            else
            {//S`
                graph = Graphics.FromImage(window.MainPicBox.Image);
				//graph.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SingleBitPerPixel;
				//graph.PixelOffsetMode = System.Drawing.Drawing2D.PixelOffsetMode.HighSpeed;
                graph.Clear(Config.Instance.BackColor);
                for (int i = window.ScrollBar.Value - 1; i >= 0; i--)
                {
                    displayLineList[i].DrawTo(graph, pointY, isBackLog, true);
                    pointY -= lineHeight;
                    if (pointY < 0 - lineHeight)
                        break;
                }
            }
            if (graph != null)
                graph.Dispose();
            window.Refresh();
            if (isBackLog)
                lastLineNo = -1;
            else
                lastLineNo = lineNo;
            if (deletedLine)
                deletedLine = false;
            lastSelectingButton = selectingButton;
            /*fobOpB`悪dz
            System.Threading.Thread.Sleep(50);
            */
            //Initializing͂ɕpxFǂݍ݂𑁂邽߁B
            if (state == ConsoleState.Initializing)
                lastUpdate = WinmmTimer.TickCount;
        }

        public void clearDisplay()
        {
            Graphics graph = Graphics.FromImage(window.MainPicBox.Image);
            graph.Clear(Config.Instance.BackColor);
            displayLineList.Clear();
        }

        int[] rgbValues;
        private void shiftBitmap(Bitmap bmp, int shiftY)
        {
            Rectangle rect = new Rectangle(0, 0, bmp.Width, bmp.Height);
            System.Drawing.Imaging.BitmapData bmpData =
                bmp.LockBits(rect, ImageLockMode.ReadWrite, PixelFormat.Format32bppArgb);
            IntPtr ptr = bmpData.Scan0;
            int lineBytes = bmp.Width;
            int totalBytes = lineBytes * bmp.Height;
            System.Runtime.InteropServices.Marshal.Copy(ptr, rgbValues, 0, totalBytes);
            System.Runtime.InteropServices.Marshal.Copy(rgbValues, lineBytes * shiftY, ptr, totalBytes);
            bmp.UnlockBits(bmpData);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="str"></param>
        /// <param name="position"></param>
        /// <param name="level">xx.0:yȃ~X.1:łs.2:ssȂΖQ.3:vI</param>
        public void PrintWarning(string str, ScriptPosition position, int level)
        {
			if (level < Config.Instance.DisplayWarningLevel)
                return;
            if (position != null)
            {
                PrintLine(string.Format("xLv{0}:{1}:{2}s:{3}", level, position.Filename, position.LineNo, str));
                PrintLine(position.RowLine);
            }
            else
            {
                PrintLine(string.Format("xLv{0}:{1}", level, str));
            }
        }

        /// <summary>
        /// EBhETCYlmɈsŏɍBVXepB
        /// </summary>
        /// <param name="str"></param>
        public void PrintLine(string str)
        {
            if (string.IsNullOrEmpty(str))
                return;
            if (printBuffer.Length != 0)
                NewLine();
            addDisplayLine(new DisplayLine(this, str, StringStyle));
            RefreshStrings(false);
            return;
        }

        /// <summary>
        /// KsŒɕ`悷B^Cg\pB
        /// </summary>
        /// <param name="str"></param>
        public void PrintCenter(string str)
        {
            if (string.IsNullOrEmpty(str))
                return;
            if (printBuffer.Length != 0)
                NewLine();
            Graphics stringMeasure = Graphics.FromImage(window.MainPicBox.Image);
			int width = (int)stringMeasure.MeasureString(str, Config.Instance.Font).Width;
            stringMeasure.Dispose();
			DisplayString disStr = new DisplayString(this, str, StringStyle);
            disStr.PointX = (window.MainPicBox.Width - width) / 2;
            List<DisplayString> strs = new List<DisplayString>();
            strs.Add(disStr);
            addDisplayLine(new DisplayLine(this, strs));
            RefreshStrings(false);
            return;
        }

        private int currentStrX = 0;
        private List<DisplayString> currentStrSet = new List<DisplayString>();
        private List<string> strSet = new List<string>();
		private StringStyle style = new StringStyle(Config.Instance.ForeColor, FontStyle.Regular);
		public StringStyle StringStyle { get { return style; } }

		public void SetStringStyle(FontStyle fs)
		{
			if (style.FontStyle == fs)
				return;
			makeButtonStrings();
			style.FontStyle = fs;
		}
		public void SetStringStyle(Color color)
		{
			if (style.Color == color)
				return;
			makeButtonStrings();
			style.Color = color;
		}



        public void Print(string str)
        {
            if (string.IsNullOrEmpty(str))
                return;
            int newline = str.IndexOf('\n');
            if (newline > 0)
            {
                string upper = str.Substring(0, newline - 1);
                printBuffer.Append(upper);
                NewLine();
                if (newline < str.Length - 1)
                {
                    string lower = str.Substring(newline + 1);
                    Print(lower);
                }
                return;
            }
            printBuffer.Append(str);
            return;
        }

        public void PrintC(string str, bool alignmentRight)
        {
            if (string.IsNullOrEmpty(str))
                return;
            int length = StrlenB(str);
			int printcLength = Config.Instance.PrintCLength;

			if ((alignmentRight) && (length < printcLength))
				str = new string(' ', printcLength - length) + str;
			else if ((!alignmentRight) && (length < printcLength + 1))
				str += new string(' ', printcLength + 1 - length);
            this.Print(str);
        }

        public static int StrlenB(string str)
        {
            if (str == null)
                return 0;
            return Config.Encode.GetByteCount(str);
        }

        public void NewLine()
        {
            PrintFlash(true);
        }

        public void DrawLine()
        {
            Print(stBar);
        }

        /// <summary>
        /// BstrEBhETCYzĂ邱ƂO
        /// </summary>
        /// <param name="str"></param>
        /// <param name="g"></param>
        /// <returns></returns>
        public List<string> splitWithWindowWidth(string str, Graphics g)
        {
            List<string> ret = new List<string>();
            int point = 0;
            StringBuilder buffer = new StringBuilder();
            buffer.Append(str);
            int highLength = str.Length - 1;//EChETCY𒴂Œ̕index(-1)B
            int lowLength = 20;//Ȃő̕indexBls̍ŒᕶɂȂB
            if (lowLength >= str.Length - 1)
                lowLength = str.Length - 1;//̃TCY𒴂ȂB
            int i = printBuffer.Length * point / window.MainPicBox.Image.Width;//悻̕𐄒
            if (i > printBuffer.Length - 1)//z̊OQƂȂ悤ɁB
                i = printBuffer.Length - 1;
            if (i < lowLength)//highLength菬l𒲂ׂĂ傤ȂB
                i = lowLength;
            string test = null;
            while ((highLength - lowLength) > 1)//ꕶȉɂȂ܂ŌJԂB
            {
                test = buffer.ToString(0, i);
				point = (int)g.MeasureString(test, Config.Instance.Font).Width + currentStrX;
                if (point <= window.MainPicBox.Image.Width)//TCYȂlowLengthXVB𑝂₷B
                {
                    lowLength = i;
                    i++;
                }
                else//TCYOȂhighLengthXVB炷B
                {
                    highLength = i;
                    i--;
                }
            }
            ret.Add(buffer.ToString(0, lowLength));
            buffer.Remove(0, lowLength);
            test = buffer.ToString();
			point = (int)g.MeasureString(test, Config.Instance.Font).Width;
            if (point < window.MainPicBox.Image.Width)
            {
                ret.Add(test);
            }
            else
            {
                ret.AddRange(splitWithWindowWidth(test, g));
            }
            return ret;
        }

		readonly RectangleF layoutRect = new RectangleF(0, 0, Config.Instance.WindowX, Config.Instance.LineHeight);


		float fontDisplaySize = Config.Instance.Font.Size / 2 * 1.04f;//ۂɂ͎w肵tHg኱ƂH
        readonly StringFormat sf = new StringFormat(StringFormatFlags.MeasureTrailingSpaces);
		readonly CharacterRange[] ranges = new CharacterRange[] { new CharacterRange(0, 1) };

		readonly Size layoutSize = new Size(Config.Instance.WindowX, Config.Instance.LineHeight);
        private int getStringDisplayLength(Graphics g, string s)
        {
			if (Config.Instance.UseGDIplus)
			{
				ranges[0].Length = s.Length;
				//CharacterRange[] ranges = new CharacterRange[] { new CharacterRange(0, s.Length) };
				sf.SetMeasurableCharacterRanges(ranges);
				Region[] regions = g.MeasureCharacterRanges(s, Config.Instance.Font, layoutRect, sf);
				RectangleF rectF = regions[0].GetBounds(g);
				//return (int)rectF.Width;//v|[ViłȂĂsNZ
				return (int)((int)((rectF.Width - 1) / fontDisplaySize + 0.95f) * fontDisplaySize);
			}
			else
			{
				Size size = TextRenderer.MeasureText(g, s, Config.Instance.Font, layoutSize, TextFormatFlags.NoPadding | TextFormatFlags.NoPrefix);
				//Size size = TextRenderer.MeasureText(g, s, Config.Instance.Font);
				return size.Width;
			}
        }

        public void PrintFlash(bool force)
		{
            if (printBuffer.ToString().Length > 0)
                makeButtonStrings();
            if (currentStrSet.Count == 0)
            {
                currentStrX = 0;
                if (!force)
                    return;
				addDisplayLine(new DisplayLine(this, "", StringStyle));
                RefreshStrings(false);
                StringNo++;
                return;
            }
            addDisplayLine(new DisplayLine(this, currentStrSet));
            currentStrSet = new List<DisplayString>();
            currentStrX = 0;
            StringNo++;
            if (StringNo == int.MaxValue)
            {
                StringNo = 0;
            }
            RefreshStrings(false);
		}

        private void makeButtonStrings()
        {
            List<string> strs = ButtonStringCreator.Split(printBuffer.ToString());
			printBuffer.Remove(0, printBuffer.Length);
            List<string> buttonStrs = new List<string>(strs.Count);
            Graphics stringMeasure = Graphics.FromImage(window.MainPicBox.Image);
            for (int i = 0; i < strs.Count; i++)
            {
                if (strs[i].Length == 0)
                    continue;
                int point = (int)stringMeasure.MeasureString(strs[i], Config.Instance.Font).Width + currentStrX;
                if (point < window.MainPicBox.Image.Width)
                    buttonStrs.Add(strs[i]);
                else
                    buttonStrs.AddRange(splitWithWindowWidth(strs[i], stringMeasure));
            }

            DisplayString dispStr = null;
            for (int i = 0; i < buttonStrs.Count; i++)
            {
				dispStr = new DisplayString(this, buttonStrs[i], StringStyle);
                dispStr.PointX = currentStrX;
                dispStr.Width = getStringDisplayLength(stringMeasure, buttonStrs[i]);
                currentStrX += dispStr.Width;
                if (currentStrX > Config.Instance.WindowX)
                {
                    if (dispStr.PointX == 0)
                    {
                        currentStrSet.Add(dispStr);
                        dispStr = null;
                        currentStrX = 0;
                    }
                    addDisplayLine(new DisplayLine(this, currentStrSet));
                    currentStrSet = new List<DisplayString>();
                    if (dispStr != null)
                    {
                        dispStr.PointX = 0;
                        currentStrSet.Add(dispStr);
                        currentStrX = dispStr.Width;
                    }
                }
                else
                {
                    currentStrSet.Add(dispStr);
                }
            }
            stringMeasure.Dispose();
        }

        private void setStBar()
        {
            Graphics g = Graphics.FromImage(window.MainPicBox.Image);
            StringBuilder bar = new StringBuilder();
            bar.Append(Config.Instance.DrawLineString);
            int width = 0;
            while (width < window.MainPicBox.Width)
            {//Ez܂ňꕶ₷
                bar.Append(Config.Instance.DrawLineString);
				width = (int)g.MeasureString(bar.ToString(), Config.Instance.Font).Width;
            }
            g.Dispose();
            bar.Remove(bar.Length - 1 , 1);
            stBar = bar.ToString();
        }
        public void changeStBar()
        {
            setStBar();
        }

        private void outputEmueraLog()
        {
            StreamWriter writer = null;
            try
            {
                writer = new StreamWriter(Program.ExeDir + "emuera.log", false, Config.Encode);
                foreach (DisplayLine line in displayLineList)
                {
                    writer.WriteLine(line.ToString());
                }
            }
            catch (Exception)
            {
                MessageBox.Show("Ȍo͂Ɏs܂", "Oo͎s");
            }
            finally
            {
                if (writer != null)
                    writer.Close();
            }
        }


        public void MoveMouse(Point point)
        {
            DisplayString select = null;
            //l̓͑҂ԂłȂΖ
            if ((state != ConsoleState.WaitInteger) && (state != ConsoleState.WaitString)
            && (state != ConsoleState.WaitSystemInteger))
                goto end;
            //\͖
            if (window.ScrollBar.Value != window.ScrollBar.Maximum)
                goto end;
            int pointX = point.X;
            int pointY = point.Y;
            //\͉牽sځH
            int displayLineNo = (window.MainPicBox.Height - pointY) / lineHeight + 1;
            //ۂ͉sځH
            int lineNo = displayLineList.Count - displayLineNo;
            if ((lineNo < 0) || (lineNo >= displayLineList.Count))
                goto end;
            select = displayLineList[lineNo].getSelecting(pointX);
            if ((select == null) || (select.Generation != lastButtonGeneration))
                select = null;
            else if ((state == ConsoleState.WaitInteger) && (!select.IsInteger))
                select = null;
            else if ((state == ConsoleState.WaitSystemInteger) && (!select.IsInteger))
                select = null;
        end:
            if (select != selectingButton)
            {
                selectingButton = select;
                RefreshStrings(true);
            }
            return;
        }

        public void LeaveMouse()
        {
            selectingButton = null;
            RefreshStrings(true);
        }

        private void barUpdate()
        {
            int max = displayLineList.Count;
            int move = max - window.ScrollBar.Maximum;
            if (move == 0)
                return;
            if (move > 0)
            {
                window.ScrollBar.Maximum = max;
                window.ScrollBar.Value += move;
            }
            else
            {
                if (max > window.ScrollBar.Value)
                    window.ScrollBar.Value = max;
                window.ScrollBar.Maximum = max;
            }
            window.ScrollBar.Enabled = max > 0;
        }

        public void GotoTitle()
        {
            //if (state == ConsoleState.Error)
            //{
            //    MessageBox.Show("G[͂̋@\͎g܂");
            //}
            emuera.waitScriptEndforTitle();
        }

        public void ReloadErb()
        {
            if (state == ConsoleState.Error)
            {
                MessageBox.Show("G[͂̋@\͎g܂");
                return;
            }
            PrintLine("ERBēǂݍݒcc");
            reUse = true;
            ConsoleState current = state;
            state = ConsoleState.Initializing;
            emuera.reloadErb();
            reUse = true;
            PrintLine("ēǂݍ݊");
            reUse = true;
            ReadAnyKey();
            PrintLine("");
            state = current;
        }
    }
}

