﻿using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.GameData.Variable
{
	internal class VariableLocal<T>
	{
		public VariableLocal(int size)
		{
			this.size = size;
		}
		readonly int size;
		public int Size
		{
			get
			{
				return size;
			}
		}
		Dictionary<string, T[]> localVars = new Dictionary<string, T[]>();

		public T GetValue(string key, long index)
		{
			T[] varList = getVarList(key);
			return varList[index];
		}
		public void SetValue(string key, long index, T value)
		{
			T[] varList = getVarList(key);
			varList[index] = value;
		}

		public void Clear()
		{
			localVars.Clear();
		}

		private T[] getVarList(string key)
		{

			T[] varList = null;
			if (localVars.ContainsKey(key))
				varList = localVars[key];
			else
			{
				varList = new T[size];
				localVars.Add(key, varList);
			}
			return varList;
		}
	}
}
