using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.GameData.Function;
using MinorShift.Emuera.GameProc;

namespace MinorShift.Emuera.GameData.Expression
{
    internal static class ExpressionParser
    {
        /// <summary>
        /// ݂̎dlł͎̉Z͈ȂB
        /// </summary>
        /// <param name="st"></param>
        /// <returns></returns>
        public static double ReduceDoubleTerm(StringStream st)
        {
            TokenReader.SkipWhiteSpace(st);
            return TokenReader.ReadDouble(st);
        }

		/// <summary>
		/// J}ŋ؂ꂽꊇĎ擾Bs[)ŏIB
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static IOperandTerm[] ReduceArguments(StringStream st, bool startWithBracket)
		{
			List<IOperandTerm> terms = new List<IOperandTerm>();
			TokenReader.SkipWhiteSpace(st);
			if ((startWithBracket) && (st.Current != '('))
				throw new ExeEE("nꂽ񂪊ԈĂ");
			if (startWithBracket)
				st.ShiftNext();
			while (true)
			{
				TokenReader.SkipWhiteSpace(st);
				TokenType type = TokenReader.GetNextTokenType(st);
				if ((st.EOS) || (type == TokenType.EndOfLine))
					break;
				if (st.Current == ')')
					break;
				terms.Add(ReduceExpressionTerm(st));
				TokenReader.SkipWhiteSpace(st);
				if (st.Current != ',')
					break;
				st.ShiftNext();
			}
			if (startWithBracket)
			{
				if (st.Current == ')')
					st.ShiftNext();
				else
					throw new CodeEE("ʂĂ܂");
			}
			IOperandTerm[] ret = new IOperandTerm[terms.Count];
			terms.CopyTo(ret);
			return ret;
		}

		/// <summary>
		/// ܂͕񎮁BCALL̈ȂǂBnullԂƂB
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static IOperandTerm ReduceExpressionTerm(StringStream st)
		{
			TokenReader.SkipWhiteSpace(st);
			if ((st.EOS)||(st.Current == ','))
				return null;
			IOperandTerm term = reduceTerm(st, false);
			return term;
		}

        /// <summary>
        /// PAtA񎮂̂A񎮂舵B
        /// </summary>
        /// <param name="st"></param>
        /// <returns></returns>
        public static IOperandTerm ReduceStringTerm(StringStream st)
        {
            TokenReader.SkipWhiteSpace(st);
            if (st.EOS)
                return new SingleTerm("");
            IOperandTerm term = reduceTerm(st, true);
            if (term.GetOperandType() != typeof(string))
                throw new CodeEE("̌ʂł͂܂");
            return term;
        }

        public static IOperandTerm ReduceTernaryStringTerm(StringStream st)
        {
            TermStack stack = new TermStack();
            StringBuilder buffer = new StringBuilder();
            while (st.Current != '?')
            {
                buffer.Append(st.Current);
                st.ShiftNext();
            }
            string left = buffer.ToString().Trim();
            stack.Add(reduceTerm(new StringStream(left), false));
            buffer.Remove(0, buffer.Length);
            stack.Add(OperatorManager.ToOperatorType("?"));
            st.ShiftNext();
            TokenReader.SkipWhiteSpace(st);
            while (st.Current != '#')
            {
                buffer.Append(st.Current);
                st.ShiftNext();
            }
            string right1 = buffer.ToString().Trim();
            stack.Add(new SingleTerm(right1));
            buffer.Remove(0, buffer.Length);
            stack.Add(OperatorManager.ToOperatorType("#"));
            st.ShiftNext();
            TokenReader.SkipWhiteSpace(st);
            while (!st.EOS)
            {
                buffer.Append(st.Current);
                st.ShiftNext();
            }
            string right2 = buffer.ToString().Trim();
            stack.Add(new SingleTerm(right2));
            return stack.ReduceAll();
        }

        public static IOperandTerm ReduceVariableArgument(StringStream st)
        {
            TermStack stack = new TermStack();
            TokenReader.SkipWhiteSpace(st);
            TokenType type = TokenReader.GetNextTokenType(st);
            if ((st.EOS) || (type == TokenType.EndOfLine) || (type == TokenType.EndOfExpression))
                throw new CodeEE("ϐ:̌Ɉ܂");
            else if (type == TokenType.Numeric)
            {
                stack.Add(TokenReader.ReadInt64(st));
            }
            else if (type == TokenType.Identifer)
            {
                string idStr = TokenReader.ReadSingleIdentifer(st);
                VariableIdentifier id = VariableIdentifier.GetVariableId(idStr);
                if (id == null)
                {
                    if (ConstantData.isDefined(idStr))
                        stack.Add(idStr);
                    else
                        throw new CodeEE("\"" + idStr + "\"͉߂łȂʎqł");
                }
                else
                    stack.Add(VariableParser.ReduceVariable(id, null, null, null));
            }
            else if (type == TokenType.StringToken)
            {
                string str = TokenReader.ReadStringWithDoubleQuotation(st);
                if (!ConstantData.isDefined(str))
                    throw new CodeEE("\"" + str + "\"͒`ĂȂʎqł");
                stack.Add(str);
            }
            else if (st.Current == '(')
            {
                st.ShiftNext();
                stack.Add(reduceTerm(st, false));
                if (st.Current != ')')
                    throw new CodeEE("ʂĂ܂");
                st.ShiftNext();
            }
            else if (type == TokenType.Operator)
            {
                throw new CodeEE("ϐ̈̓ǂݎ蒆̂ɗ\ȂZq𔭌܂");
            }
            else
                throw new CodeEE("\Ȃʎq");
            return stack.ReduceAll();
        }

        public static IOperandTerm ReduceIntegerTerm(StringStream st)
        {
            IOperandTerm term = reduceTerm(st, false);
            if (term.GetOperandType() != typeof(Int64))
                throw new CodeEE("̌ʂlł͂܂");
            return term;
        }



		/// <summary>
		/// J}ŋ؂ꂽCASËꊇĎ擾Bs[ŏIB
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static CaseExpression[] ReduceCaseExpressions(StringStream st)
		{
			List<CaseExpression> terms = new List<CaseExpression>();
			TokenReader.SkipWhiteSpace(st);
			while (true)
			{
				TokenReader.SkipWhiteSpace(st);
				TokenType type = TokenReader.GetNextTokenType(st);
				if ((st.EOS) || (type == TokenType.EndOfLine))
					break;
				terms.Add(reduceCaseExpression(st));
				TokenReader.SkipWhiteSpace(st);
				if (st.Current != ',')
					break;
				st.ShiftNext();
			}
			CaseExpression[] ret = new CaseExpression[terms.Count];
			terms.CopyTo(ret);
			return ret;
		}

		private static CaseExpression reduceCaseExpression(StringStream st)
		{
			CaseExpression ret = new CaseExpression();
			TokenReader.SkipWhiteSpace(st);
			if (st.CurrentEqualTo("IS", StringComparison.OrdinalIgnoreCase))
			{
				st.Seek(2, System.IO.SeekOrigin.Current);
				TokenType type = TokenReader.GetNextTokenType(st);
				if(type == TokenType.WhiteSpace || type == TokenType.Operator)
				{
					ret.CaseType = CaseExpressionType.Is;
					TokenReader.SkipWhiteSpace(st);
					if(TokenReader.GetNextTokenType(st) != TokenType.Operator)
						throw new CodeEE("ISL[[ȟɉZq܂");
					OperatorCode op = TokenReader.ReadOperator(st);
					if (!OperatorManager.IsBinary(op))
						throw new CodeEE("ISL[[ȟ̉Zq2Zqł͂܂");
					ret.Operator = op;
					ret.LeftTerm = reduceTerm(st, false);
					return ret;
                }
				st.Seek(-2, System.IO.SeekOrigin.Current);
			}
			ret.LeftTerm = reduceTerm(st, false, true);

			if (st.CurrentEqualTo("TO", StringComparison.OrdinalIgnoreCase))
			{
				ret.CaseType = CaseExpressionType.To;
				st.Seek(2, System.IO.SeekOrigin.Current);
				ret.RightTerm = reduceTerm(st, false, true);
				if (st.CurrentEqualTo("TO", StringComparison.OrdinalIgnoreCase))
					throw new CodeEE("TOL[[h2xgĂ܂");
				if (ret.LeftTerm.GetOperandType() != ret.RightTerm.GetOperandType())
					throw new CodeEE("TOL[[h̑Ǒ^vĂ܂");
				return ret;
			}
			ret.CaseType = CaseExpressionType.Normal;
			return ret;
		}

		private static IOperandTerm reduceTerm(StringStream st, bool endWithPercent)
		{
			return reduceTerm(st, endWithPercent, false);
		}
        private static IOperandTerm reduceTerm(StringStream st, bool endWithPercent, bool allowKeywordTo)
        {
            TermStack stack = new TermStack();
            int termCount = 0;
            int ternaryCount = 0;
            while (true)
            {
                TokenReader.SkipWhiteSpace(st);
                TokenType type = TokenReader.GetNextTokenType(st);
                if ((st.EOS) || (type == TokenType.EndOfLine)
                    || (type == TokenType.EndOfExpression))
                    break;
                if ((endWithPercent) && (st.Current == '%'))
                    break;
                termCount++;
                if (type == TokenType.Numeric)
                {
                    stack.Add(TokenReader.ReadInt64(st));
                    continue;
                }
                if (type == TokenType.Identifer)
                {
					string idStr = TokenReader.ReadSingleIdentifer(st);
					int skip = TokenReader.SkipWhiteSpace(st);
					if (st.Current == '(')
					{//֐
						IOperandTerm[] args = ReduceArguments(st,true);
						IOperandTerm mToken = FunctionMethodCreator.GetFunctionMethod(Process.Instance.LabelDic, idStr, args);
                        if (mToken == null)
                        {
                            if (!Program.AnalysisMode)
                                throw new CodeEE("\"" + idStr + "\"͉߂łȂʎqł");
                            else
                            {
                                if (Process.Instance.tempDic.ContainsKey(idStr))
                                    Process.Instance.tempDic[idStr]++;
                                else
                                    Process.Instance.tempDic.Add(idStr, 1);
                                continue;
                            }
                        }
						stack.Add(mToken);
					}
					else
					{//ϐ
						if (idStr.Equals("TO", StringComparison.OrdinalIgnoreCase))
						{
							if (allowKeywordTo)
							{
								st.Seek(-(skip + 2), System.IO.SeekOrigin.Current);
								break;
							}
							else
								throw new CodeEE("TOL[[h͂ł͎gpł܂");
						}
                        else if 
						 (idStr.Equals("IS", StringComparison.OrdinalIgnoreCase))
                            throw new CodeEE("ISL[[h͂ł͎gpł܂");
                        else
                            stack.Add(VariableParser.ReduceVariable(idStr, st));
					}
                    continue;
                }
                if (type == TokenType.Operator)
                {
                    OperatorCode op = TokenReader.ReadOperator(st);
                    stack.Add(op);
                    if (OperatorManager.ToOperatorString(op) == "?")
                        ternaryCount++;
                    else if (OperatorManager.ToOperatorString(op) == "#" && ternaryCount > 0)
                        ternaryCount--;
                    else if (OperatorManager.ToOperatorString(op) == "#")
                        throw new CodeEE("Ή\'?\'܂");
                    continue;
                }
                if (type == TokenType.StringToken)
                {
                    stack.Add(TokenReader.ReadStringWithDoubleQuotation(st));
                    continue;
				}
				if (type == TokenType.StringFormToken)
				{
					if (st.Current != '@')
						throw new ExeEE("");
					st.ShiftNext();
					if (st.Current != '\"')
						throw new CodeEE("@̎gsł");
					st.ShiftNext();
					StringForm sf = new StringForm("");
					sf.Reduce(st, '\"');
					if (st.Current != '\"')
						throw new CodeEE("@\"ŕ񂪎n܂Ă܂\"ŕĂ܂");
					st.ShiftNext();
					stack.Add(new StringFormTerm(sf));
					continue;
				}

                if (type == TokenType.TernaryOperator)
                {
                    if (st.Current != '\\')
                        throw new ExeEE("");
                    st.ShiftNext();
                    if (st.Current != '@')
                        throw new ExeEE("");
                    st.ShiftNext();
                    StringBuilder tBf = new StringBuilder();
                    bool isEscape = false;
                    while (!(st.Current == '@' && isEscape) && !st.EOS && (st.Current != '\0'))
                    {
                        if (st.Current == '\\' && !isEscape)
                        {
                            isEscape = true;
                            st.ShiftNext();
                            continue;
                        }
                        if (isEscape)
                        {
                            switch (st.Current)
                            {
                                case StringStream.EndOfString:
                                    throw new CodeEE("GXP[v\\̌ɕ܂");
                                case '\n':
                                    break;
                                case 's':
                                    tBf.Append(' ');
                                    break;
                                case 'S':
                                    tBf.Append('@');
                                    break;
                                case 't':
                                    tBf.Append('\t');
                                    break;
                                case 'n':
                                    tBf.Append('\n');
                                    break;
                                case '{':
                                    tBf.Append('{');
                                    tBf.Append('{');
                                    break;
                                case '}':
                                    tBf.Append('}');
                                    tBf.Append('}');
                                    break;
                                default:
                                    tBf.Append(st.Current);
                                    break;
                            }
                            isEscape = false;
                            st.ShiftNext();
                            continue;
                        }
                        tBf.Append(st.Current);
                        st.ShiftNext();
                    }
                    if (!(isEscape && st.Current == '@'))
                        throw new CodeEE("Ή\\@܂");
                    stack.Add(ReduceTernaryStringTerm(new StringStream(tBf.ToString())));
                    st.ShiftNext();
                    continue;
                }
                if (st.Current == '(')
                {
                    st.ShiftNext();
                    stack.Add(reduceTerm(st, endWithPercent));
                    if (st.Current != ')')
                        throw new CodeEE("ʂĂ܂");
                    st.ShiftNext();
                    continue;
                }
                throw new CodeEE("\Ȃʎq");
            }
            if (ternaryCount > 0)
                throw new CodeEE("\'?\'\'#\'̐ΉĂ܂");
            return stack.ReduceAll();
        }


        public static bool checkTernary(StringStream st)
        {
            int count = 0;
            while (!st.EOS)
            {
                //OZqO%ȂŊm
                if (st.Current == '%')
                    return false;
                if (st.Current == ',')
                {
                    //w","̂ŁA̓ꏈ
                    count++;
                    st.ShiftNext();
                }
                TokenReader.SkipWhiteSpace(st);
                TokenType type = TokenReader.GetNextTokenType(st);
                if (type == TokenType.TernaryOperator)
                    return true;
                if (type == TokenType.Numeric)
                {
                    TokenReader.ReadInt64(st);
                    continue;
                }
                if (type == TokenType.Identifer)
                {
                    string idStr = TokenReader.ReadSingleIdentifer(st);
                    if (count == 2 && ((idStr.ToUpper() == "LEFT") || (idStr.ToUpper() == "RIGHT")))
                        continue;
                    int skip = TokenReader.SkipWhiteSpace(st);
                    if (st.Current == '(')
                    {//֐
                        IOperandTerm[] args = ReduceArguments(st, true);
                    }
                    else
                    {//ϐ
                        VariableParser.ReduceVariable(idStr, st);
                    }
                    continue;
                }
                if (type == TokenType.Operator)
                {
                    OperatorCode op = TokenReader.ReadOperator(st);
                    continue;
                }
                if (type == TokenType.StringToken)
                {
                    TokenReader.ReadStringWithDoubleQuotation(st);
                    continue;
                }
                if (type == TokenType.StringFormToken)
                {
                    if (st.Current != '@')
                        throw new ExeEE("");
                    st.ShiftNext();
                    if (st.Current != '\"')
                        throw new CodeEE("@̎gsł");
                    st.ShiftNext();
                    StringForm sf = new StringForm("");
                    sf.Reduce(st, '\"');
                    if (st.Current != '\"')
                        throw new CodeEE("@\"ŕ񂪎n܂Ă܂\"ŕĂ܂");
                    st.ShiftNext();
                    continue;
                }
                //ЂȂȂ玟̕
                st.ShiftNext();
            }        
            return false;
        }

        /// <summary>
        /// pNX
        /// </summary>
        private class TermStack
        {
            /// <summary>
            /// ɗׂ̂̎ށB
            /// (Ou)PZql҂Ȃ0A񍀁EOZq҂Ȃ1Al҂Ȃ2A++A--A!ɑΉl҂̏ꍇ3B
            /// </summary>
            int state = 0;
            bool hasBefore = false;
            bool hasAfter = false;
            bool waitAfter = false;
            Stack<Object> stack = new Stack<Object>();
            public void Add(OperatorCode op)
            {
                if (state == 2 || state == 3)
                    throw new CodeEE("ُł");
                if (state == 0)
                {
                    if (!OperatorManager.IsUnary(op))
                        throw new CodeEE("ُł");
                    stack.Push(op);
                    if (op == OperatorCode.Plus || op == OperatorCode.Minus || op == OperatorCode.BitNot)
                        state = 2;
                    else
                        state = 3;
                    return;
                }
                if (state == 1)
                {
                    //uPZq̏ꍇ͓ꏈ
                    if (OperatorManager.IsUnaryAfter(op))
                    {
                        if (hasAfter)
                        {
                            hasAfter = false;
                            throw new CodeEE("u̒PZq݂Ă܂");
                        }
                        if (hasBefore)
                        {
                            hasBefore = false;
                            throw new CodeEE("CNgEfNgOuEuɎgƂ͂ł܂");
                        }
                        stack.Push(op);
                        reduceUnaryAfter();
                        //OuPZq҂Ăꍇ͂ŉ
                        if (waitAfter)
                            reduceUnary();
                        hasBefore = false;
                        hasAfter = true;
                        waitAfter = false;
                        return;
                    }
                    if (!OperatorManager.IsBinary(op) && !OperatorManager.IsTernary(op))
                        throw new CodeEE("ُł");
                    //ɖ̑OuZq
                    if (waitAfter)
                        reduceUnary();
                    int priority = OperatorManager.GetPriority(op);
                    //ǑvZ̗DxȂҌB
                    while (lastPriority() >= priority)
                    {
                        this.reduceLastThree();
                    }
                    stack.Push(op);
                    state = 0;
                    waitAfter = false;
                    hasBefore = false;
                    hasAfter = false;
                    return;
                }
                throw new CodeEE("ُł");
            }
            public void Add(Int64 i) { Add(new SingleTerm(i)); }
            public void Add(string s) { Add(new SingleTerm(s)); }
            public void Add(IOperandTerm term)
            {
                stack.Push(term);
                if (state == 1)
                    throw new CodeEE("ُł");
                if (state == 2)
                    waitAfter = true;
                if (state == 3)
                {
                    reduceUnary();
                    hasBefore = true;
                }
                state = 1;
                return;
            }

            private void reduceUnary()
            {
                if (stack.Count < 2)
                    throw new ExeEE("sȎ̌Ăяo");
                IOperandTerm operand = (IOperandTerm)stack.Pop();
                OperatorCode op = (OperatorCode)stack.Pop();
                Type retType = OperatorMethod.GetReturnType(operand.GetOperandType(), op);
                UnaryMethod method = OperatorMethod.GetUnaryMethod(op);
                if ((retType == typeof(void)) || (method == null))
                {
                    string errMes = "";
                    if (operand.GetOperandType() == typeof(Int64))
                        errMes += "l^";
                    else if (operand.GetOperandType() == typeof(string))
                        errMes += "^";
                    else
                        errMes += "s^";
                    errMes += "ɒPZq\'" + OperatorManager.ToOperatorString(op) + "\'͓Kpł܂";
                    throw new CodeEE(errMes);
                }
                if (operand is SingleTerm)
                {
                    stack.Push(method(operand, GetSingle));
                }
                else
                {
                    stack.Push(new UnaryExpressionTerm(operand, op, method));
                }
            }

            private void reduceUnaryAfter()
            {
                if (stack.Count < 2)
                    throw new ExeEE("sȎ̌Ăяo");
                OperatorCode op = (OperatorCode)stack.Pop();
                IOperandTerm operand = (IOperandTerm)stack.Pop();
                Type retType = OperatorMethod.GetReturnType(operand.GetOperandType(), op);
                UnaryAfterMethod method = OperatorMethod.GetUnaryAfterMethod(op);
                if (operand is VariableToken)
                {
                    if ((retType == typeof(void)) || (method == null))
                    {
                        string errMes = "";
                        if (operand.GetOperandType() == typeof(Int64))
                            errMes += "l^";
                        else if (operand.GetOperandType() == typeof(string))
                            errMes += "^";
                        else
                            errMes += "s^";
                        errMes += "ɌuPZq\'" + OperatorManager.ToOperatorString(op) + "\'͓Kpł܂";
                        throw new CodeEE(errMes);
                    }
                    stack.Push(new UnaryAfterExpressionTerm(operand, op, method));
                }
                else
                {
                    throw new CodeEE("ϐȊOCNg邱Ƃ͂ł܂");
                }
            }

            private int lastPriority()
            {
                if (stack.Count < 3)
                    return -1;
                object temp = (object)stack.Pop();
                OperatorCode opCode = (OperatorCode)stack.Peek();
                int priority = OperatorManager.GetPriority(opCode);
                stack.Push(temp);
                return priority;
            }

            public IOperandTerm ReduceAll()
            {
                if (stack.Count == 0)
                    return new SingleTerm(0);
                if (state != 1)
                    throw new CodeEE("ُł");
                //PZq̑҂̎͂ŉ
                if (waitAfter)
                    reduceUnary();
                waitAfter = false;
                hasBefore = false;
                hasAfter = false;
                while (stack.Count > 1)
                {
                    reduceLastThree();
                }
                return (IOperandTerm)stack.Pop();
            }



            private void reduceLastThree()
            {
                if (stack.Count < 2)
                    throw new ExeEE("sȎ̌Ăяo");
                IOperandTerm right = (IOperandTerm)stack.Pop();//ォꂽقE
                OperatorCode op = (OperatorCode)stack.Pop();
                IOperandTerm left = (IOperandTerm)stack.Pop();
                if (OperatorManager.IsTernary(op))
                {
                    if (stack.Count > 1)
                    {
                        reduceTernary(left, right, op);
                        return;
                    }
                    throw new CodeEE("̐sĂ܂");
                }
                if (!OperatorManager.IsBinary(op))
                    throw new ExeEE("ُȎ󂯓Ă܂Ă");
                Type retType = OperatorMethod.GetReturnType(right.GetOperandType(), left.GetOperandType(), op);

                BinaryMethod method = OperatorMethod.GetBinaryMethod(op);
                if ((retType == typeof(void)) || (method == null))
                {
                    string errMes = "";
                    if (left.GetOperandType() == typeof(Int64))
                        errMes += "l^";
                    else if (left.GetOperandType() == typeof(string))
                        errMes += "^";
                    else
                        errMes += "s^";
                    if (right.GetOperandType() == typeof(Int64))
                        errMes += "l^";
                    else if (right.GetOperandType() == typeof(string))
                        errMes += "^";
                    else
                        errMes += "s^";
                    errMes += "Zɓ񍀉Zq\'" + OperatorManager.ToOperatorString(op) + "\'͓Kpł܂";
                    throw new CodeEE(errMes);
                }
                if ((right is SingleTerm) && (left is SingleTerm))
                {
                    stack.Push(method(left, right, GetSingle));
                }
                else
                {
                    stack.Push(new BinaryExpressionTerm(left, right, op, method));
                }
			}

            private void reduceTernary(IOperandTerm left, IOperandTerm right, OperatorCode op)
            {
                OperatorCode newOp = (OperatorCode)stack.Pop();
                IOperandTerm newLeft = (IOperandTerm)stack.Pop();
                Type retType = OperatorMethod.GetReturnType(newLeft.GetOperandType(), left.GetOperandType(), right.GetOperandType(), op);

                TernaryMethod method = OperatorMethod.GetTernaryMethod(newOp);
                if ((retType == typeof(void)) || (method == null))
                {
                    string errMes = "";
                    if (retType == typeof(void))
                        errMes += "^v܂";
                    else
                        errMes += "Zq݂܂";
                    throw new CodeEE(errMes);
                }
                if ((right is SingleTerm) && (left is SingleTerm) && (newLeft is SingleTerm))
                {
                    stack.Push(method(newLeft, left, right, GetSingle));
                }
                else
                {
                    stack.Push(new TernaryExpressionTerm(newLeft, left, right, newOp, method));
                }
            }

			SingleTerm GetSingle(IOperandTerm oprand)
			{
				return (SingleTerm)oprand;
			}
        }

    }
}