﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameProc;


namespace MinorShift.Emuera.GameData.Function
{
	internal static partial class FunctionMethodCreator
	{

		static FunctionMethodCreator()
		{
			methodList = new Dictionary<string, FunctionMethod>();
			methodList[FunctionMethodCode.GETCHARA.ToString()] = new GetcharaMethod();
			methodList[FunctionMethodCode.GETSPCHARA.ToString()] = new GetspcharaMethod();
			methodList[FunctionMethodCode.CSVNAME.ToString()] = new CsvnameMethod();
			methodList[FunctionMethodCode.CSVCALLNAME.ToString()] = new CsvcallnameMethod();
            methodList[FunctionMethodCode.CSVNICKNAME.ToString()] = new CsvnicknameMethod();
            methodList[FunctionMethodCode.CSVMASTERNAME.ToString()] = new CsvmasternameMethod();
            methodList[FunctionMethodCode.CSVCSTR.ToString()] = new CsvcstrMethod();
            methodList[FunctionMethodCode.CSVBASE.ToString()] = new CsvbaseMethod();
            methodList[FunctionMethodCode.CSVABL.ToString()] = new CsvablMethod();
            methodList[FunctionMethodCode.CSVMARK.ToString()] = new CsvmarkMethod();
            methodList[FunctionMethodCode.CSVEXP.ToString()] = new CsvexpMethod();
            methodList[FunctionMethodCode.CSVRELATION.ToString()] = new CsvrelationMethod();
            methodList[FunctionMethodCode.CSVTALENT.ToString()] = new CsvtalentMethod();
            methodList[FunctionMethodCode.CSVCFLAG.ToString()] = new CsvcflagMethod();
            methodList[FunctionMethodCode.STRLENS.ToString()] = new StrlenMethod();
            methodList[FunctionMethodCode.STRLENSU.ToString()] = new StrlenuMethod();
			methodList[FunctionMethodCode.SUBSTRING.ToString()] = new SubstringMethod();
			methodList[FunctionMethodCode.STRFIND.ToString()] = new StrfindMethod();
			methodList[FunctionMethodCode.VARSIZE.ToString()] = new VarsizeMethod();
			methodList[FunctionMethodCode.GETTIME.ToString()] = new GettimeMethod();
			methodList[FunctionMethodCode.GETTIMES.ToString()] = new GettimesMethod();
			methodList[FunctionMethodCode.GETMILLISECOND.ToString()] = new GetmsMethod();
			methodList[FunctionMethodCode.CHKFONT.ToString()] = new CheckfontMethod();
			methodList[FunctionMethodCode.CHKDATA.ToString()] = new CheckdataMethod();
			methodList[FunctionMethodCode.POWER.ToString()] = new PowerMethod();
			methodList[FunctionMethodCode.FINDCHARA.ToString()] = new FindcharaMethod();
            methodList[FunctionMethodCode.EXISTCSV.ToString()] = new ExistCsvMethod();

			methodList[FunctionMethodCode.RAND.ToString()] = new RandMethod();
			methodList[FunctionMethodCode.MIN.ToString()] = new MinMethod();
			methodList[FunctionMethodCode.MAX.ToString()] = new MaxMethod();
			methodList[FunctionMethodCode.ABS.ToString()] = new AbsMethod();
			methodList[FunctionMethodCode.SQRT.ToString()] = new SqrtMethod();
			methodList[FunctionMethodCode.SIGN.ToString()] = new SignMethod();
			methodList[FunctionMethodCode.GETBIT.ToString()] = new GetbitMethod();
			methodList[FunctionMethodCode.GETNUM.ToString()] = new GetnumMethod();
            methodList[FunctionMethodCode.LIMIT.ToString()] = new GetLimitMethod();
			methodList[FunctionMethodCode.PRINTCPERLINE.ToString()] = new GetPrintCPerLineMethod();
			methodList[FunctionMethodCode.UNICODE.ToString()] = new UnicodeMethod();

		}

		public static Dictionary<string, FunctionMethod> methodList;
		public static IOperandTerm GetFunctionMethod(LabelDictionary labelDic, string codeStr, IOperandTerm[] arguments)
		{
			if (Config.Instance.IgnoreCase)
				codeStr = codeStr.ToUpper();
			if (labelDic != null)
			{
				FunctionLabelLine func = labelDic.GetLabel(codeStr);
				if (func != null)
				{
					if(func.IsMethod)
						return new UserDefinedMethodTerm(codeStr, arguments, func.MethodType);
					//1.721 #FUNCTIONが定義されていない関数は組み込み関数を上書きしない方向に。 PANCTION.ERBのRANDとか。
					if (!methodList.ContainsKey(codeStr))
						throw new CodeEE("#FUCNTIONが定義されていない関数(" + func.Position.Filename + ":" + func.Position.LineNo + "行目)を式中で呼び出そうとしました");
				}
			}
			if (!methodList.ContainsKey(codeStr))
				return null;
			FunctionMethod method = methodList[codeStr];
			string errmes = method.CheckArgumentType(codeStr, arguments);
			if (errmes != null)
				throw new CodeEE(errmes);
			return new FunctionMethodTerm(methodList[codeStr], arguments);
		}
	}
}