using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using MinorShift._Library;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameProc;
using System.Drawing.Imaging;

namespace MinorShift.Emuera.GameView
{
	//o͑҂̏󋵁B
	internal enum ConsoleState
	{
		Initializing = 0,
		WaitKey = 1,//WAIT
		WaitSystemInteger = 2,//SystemvInput
		WaitInteger = 3,//INPUT
		WaitString = 4,//INPUTS
		Quit = 5,//QUIT
		Error = 6,//Exceptionɂ鋭I
		Running = 7,
		WaitIntegerWithTimer = 8,
		WaitStringWithTimer = 9,
		Timeout = 10,
		Timeouts = 11,
		WaitKeyWithTimer = 12,
		WaitKeyWithTimerF = 13,
	}

	internal enum ConsoleRedraw
	{
		None = 0,
		Normal = 1,
	}

	internal sealed class EmueraConsole
	{
		public EmueraConsole(MainWindow parent)
		{
			window = parent;

			lineHeight = Config.Instance.LineHeight;
			//1.713 ̒iKsetStBargpĂ͂Ȃ
			//setStBar(Config.Instance.DrawLineString);
			state = ConsoleState.Initializing;
			if (Config.Instance.FPS > 0)
				msPerFrame = 1000 / (uint)Config.Instance.FPS;
			displayLineList = new List<ConsoleDisplayLine>();
			printBuffer = new PrintStringBuffer(this);
			MainPicBoxSizeChanged();
		}

		private readonly MainWindow window;
		private readonly int lineHeight;
		PrintStringBuffer printBuffer;
		Process emuera;
		ConsoleState state = ConsoleState.Initializing;
		internal ConsoleState State { get { return state; } }

		public bool Enabled { get { return window.Created; } }
		internal bool IsRunning
		{
			get
			{
				if (state == ConsoleState.Initializing)
					return true;
				return state == ConsoleState.Running;
			}
		}
		internal bool IsError
		{
			get
			{
				return state == ConsoleState.Error;
			}
		}

		internal bool IsWaitingAnyKey
		{
			get
			{
				return ((state == ConsoleState.WaitKey) || (state == ConsoleState.Quit) || (state == ConsoleState.Error) || (state == ConsoleState.WaitKeyWithTimer));
			}
		}

		internal string SelectedString
		{
			get
			{
				if (selectingButton == null)
					return null;
				if ((state == ConsoleState.WaitInteger || state == ConsoleState.WaitIntegerWithTimer) && (selectingButton.IsInteger))
					return selectingButton.Input.ToString();
				if ((state == ConsoleState.WaitSystemInteger) && (selectingButton.IsInteger))
					return selectingButton.Input.ToString();
				if (state == ConsoleState.WaitString || state == ConsoleState.WaitStringWithTimer)
					return selectingButton.Inputs;
				return null;
			}
		}
		public void Initialize()
		{
			emuera = Process.CreateProcess(this);
			ClearDisplay();
			if (!emuera.Initialize())
			{
				state = ConsoleState.Error;
				outputErrorLog();
				PrintFlush(false);
				RefreshStrings(true);
				return;
			}
			callEmueraProgram("");
			RefreshStrings(true);
		}

		public void ClearDisplay()
		{
			Graphics graph = getGraphics();
			graph.Clear(Config.Instance.BackColor);
			graph.Dispose();
		}
		public void ReadInteger() { state = ConsoleState.WaitInteger; }
		public void ReadSystemInteger() { state = ConsoleState.WaitSystemInteger; }
		public void ReadString() { state = ConsoleState.WaitString; }
		public void ReadAnyKey()
		{
			emuera.NeedWaitToEventComEnd = false;
			state = ConsoleState.WaitKey;
		}
		public void Quit() { state = ConsoleState.Quit; }
		public void ThrowError() { state = ConsoleState.Error; }

		#region button֘A
		bool lastButoonIsInput = true;
		int lastButtonGeneration = 0;//ŌɒǉꂽI̐BƐオvȂI͑IłȂB
		int newButtonGeneration = 0;//ɒǉI̐BInputInputsƂɑ
		public int LastButtonGeneration { get { return lastButtonGeneration; } }
		public int NewButtonGeneration { get { return newButtonGeneration; } }
		public void UpdateGeneration() { lastButtonGeneration = newButtonGeneration; }


		private void newGeneration()
		{
			//ÂIIłȂ悤ɁBINPUTŎgIINPUTSɂ͗płȂ悤ɁB
			if ((state == ConsoleState.WaitInteger) || (state == ConsoleState.WaitSystemInteger) || (state == ConsoleState.WaitIntegerWithTimer))
			{
				if (lastButtonGeneration == newButtonGeneration)
					unchecked { newButtonGeneration++; }
				else if (!lastButoonIsInput)
					lastButtonGeneration = newButtonGeneration;
				lastButoonIsInput = true;
			}
			if (state == ConsoleState.WaitString || state == ConsoleState.WaitStringWithTimer)
			{
				if (lastButtonGeneration == newButtonGeneration)
					unchecked { newButtonGeneration++; }
				else if (lastButoonIsInput)
					lastButtonGeneration = newButtonGeneration;
				lastButoonIsInput = false;
			}
		}

		ConsoleButtonString selectingButton = null;
		ConsoleButtonString lastSelectingButton = null;
		public ConsoleButtonString SelectingButton { get { return selectingButton; } }
		public bool ButtonIsSelected(ConsoleButtonString button) { return selectingButton == button; }
		#endregion

		#region Timern
		private Timer timer;
		private Int64 result = 0;
		int countTime = 0;
		int timeLimit = 0;
		bool isDisp;
		private void setTimer(int time)
		{
			countTime = 0;
			timeLimit = time;
			timer = new Timer();
			timer.Tick += new EventHandler(endTimer);
			timer.Interval = 100;
			timer.Enabled = true;
			int start = timeLimit / 100;
			if (isDisp)
			{
				string timeString1 = "c ";
				string timeString2 = ((double)start / 10.0).ToString();
				PrintLine(timeString1 + timeString2);
			}
		}

		public void ReadIntegerWithTimer(Int64 time, Int64 def_result, Int64 isDisplay)
		{
			result = def_result;
			state = ConsoleState.WaitIntegerWithTimer;
			isDisp = isDisplay != 0;
			setTimer((int)time);
		}

		string results = "";
		public void ReadStringWithTimer(Int64 time, string def_result, Int64 isDisplay)
		{
			results = def_result;
			state = ConsoleState.WaitStringWithTimer;
			isDisp = isDisplay != 0;
			setTimer((int)time);
		}

		public void waitInputWithTimer(Int64 time, Int64 flag)
		{
			if (flag == 0)
				state = ConsoleState.WaitKeyWithTimer;
			else
				state = ConsoleState.WaitKeyWithTimerF;
			isDisp = false;
			setTimer((int)time);
		}

		private void stopTimer()
		{
			timer.Enabled = false;
		}

		private void endTimer(object sender, EventArgs e)
		{
			countTime += 100;
			if (countTime >= timeLimit)
			{
				stopTimer();
				if (isDisp)
					changeLastLine("Ԑ؂");
				else if (state != ConsoleState.WaitKeyWithTimer && state != ConsoleState.WaitKeyWithTimerF)
					PrintLine("Ԑ؂");
				if (state == ConsoleState.WaitIntegerWithTimer)
					state = ConsoleState.Timeout;
				else if (state == ConsoleState.WaitStringWithTimer)
					state = ConsoleState.Timeouts;
				callEmueraProgram("");
				RefreshStrings(true);
				return;
			}
			if (!isDisp)
				return;
			int time = (timeLimit - countTime) / 100;
			string timeString1 = "c ";
			string timeString2 = ((double)time / 10.0).ToString();
			changeLastLine(timeString1 + timeString2);
		}
		#endregion

		#region Calln
		private void callEmueraProgram(string str)
		{
			if (!doInputToEmueraProgram(str))
				return;
			if (state == ConsoleState.Error)
				return;
			state = ConsoleState.Running;
			emuera.DoScript();
			if (state == ConsoleState.Running)
			{//RunningȂProcess͏pׂ
				state = ConsoleState.Error;
				PrintLine("emuera.exẽG[FvȌԂł܂");
			}
			if (state == ConsoleState.Error)
				outputErrorLog();
			PrintFlush(false);
			newGeneration();
		}

		private bool doInputToEmueraProgram(string str)
		{
			Int64 input = 0;
			switch (state)
			{
				case ConsoleState.WaitInteger:
					if (!Int64.TryParse(str, out input))
						return false;
					emuera.InputInteger(input);
					break;
				case ConsoleState.WaitSystemInteger:
					if (!Int64.TryParse(str, out input))
						return false;
					emuera.InputSystemInteger(input);
					break;
				case ConsoleState.WaitString:
					emuera.InputString(str);
					break;
				case ConsoleState.WaitIntegerWithTimer:
					if (!Int64.TryParse(str, out input))
						return false;
					stopTimer();
					emuera.InputInteger(input);
					break;
				case ConsoleState.WaitStringWithTimer:
					stopTimer();
					emuera.InputString(str);
					break;
				case ConsoleState.Timeout:
					emuera.InputInteger(result);
					str = result.ToString();
					break;
				case ConsoleState.Timeouts:
					emuera.InputString(results);
					str = results;
					break;
				default:
					break;
			}
			Print(str);
			PrintFlush(false);
			RefreshStrings(false);
			return true;
		}
		#endregion

		#region ͌n
		readonly string[] spliter = new string[] { "\\n", "\r\n", "\n", "\r" };//{̉sR[h邱Ƃ͖͂ǈꉞ
		public void PressEnterKey(bool mesSkip, string str)
		{
			if ((state == ConsoleState.Running) || (state == ConsoleState.Initializing) || (state == ConsoleState.WaitKeyWithTimerF))
				return;
			if ((state == ConsoleState.Error) || (state == ConsoleState.Quit))
			{
				window.Close();
				return;
			}
			if (state == ConsoleState.WaitKeyWithTimer)
				stopTimer();
			if (str.StartsWith("@"))
			{
				doSystemCommand(str);
				return;
			}
			if ((state == ConsoleState.WaitInteger) || (state == ConsoleState.WaitIntegerWithTimer) || (state == ConsoleState.WaitSystemInteger) && str.Contains("("))
			{
				StringStream st = new StringStream(str);
				StringBuilder sb = new StringBuilder();
				StringBuilder tsb = new StringBuilder();
				StringBuilder num = new StringBuilder();
				int res;
				while (!st.EOS)
				{
					if (st.Current == '(')
					{
						tsb.Remove(0, tsb.Length);
						st.ShiftNext();
						while (st.Current != ')' && !st.EOS)
						{
							if (st.Current == '\\')
							{
								st.ShiftNext();
								switch (st.Current)
								{
									case 'n':
										tsb.Append('\n');
										break;
									case 'r':
										tsb.Append('\r');
										break;
									case 'e':
										tsb.Append("\\e");
										break;
									case '\n':
										break;
									default:
										tsb.Append(st.Current);
										break;
								}
							}
							else
							{
								tsb.Append(st.Current);
							}
							st.ShiftNext();
						}
						if (!st.EOS)
						{
							st.ShiftNext();
							if (st.Current == '*')
							{
								num.Remove(0, num.Length);
								st.ShiftNext();
								while (char.IsNumber(st.Current))
								{
									num.Append(st.Current);
									st.ShiftNext();
								}
								int.TryParse(num.ToString(), out res);
								for (int i = 0; i < res; i++)
									sb.Append(tsb.ToString());
							}
							else
								sb.Append(tsb.ToString());
						}
						else
						{
							sb.Append(tsb.ToString());
							break;
						}
					}
					else if (st.Current == '\\')
					{
						st.ShiftNext();
						switch (st.Current)
						{
							case 'n':
								sb.Append('\n');
								break;
							case 'r':
								sb.Append('\r');
								break;
							case 'e':
								sb.Append("\\e");
								break;
							case '\n':
								break;
							default:
								sb.Append(st.Current);
								break;
						}
					}
					else
					{
						sb.Append(st.Current);
					}
					st.ShiftNext();
				}
				str = sb.ToString();
			}
			string[] text = str.Split(spliter, StringSplitOptions.None);
			for (int i = 0; i < text.Length; i++)
			{
				string inputs = text[i];
				if (inputs.IndexOf("\\e") >= 0)
				{
					inputs = inputs.Replace("\\e", "");//\ȅ
					mesSkip = true;
				}
				callEmueraProgram(inputs);
				if (mesSkip)
					while (state == ConsoleState.WaitKey)
						callEmueraProgram("");
				mesSkip = false;
				if (state == ConsoleState.Error)
					break;
			}
			RefreshStrings(true);
		}

		bool isDebug = false;
		public bool IsDebug { get { return isDebug; } }
		void doSystemCommand(string command)
		{
			if (!Config.Instance.UseDebugCommand)
			{
				PrintLine("fobOR}hgpłȂݒɂȂĂ܂");
				RefreshStrings(true);
				return;
			}
			StringComparison sc = StringComparison.CurrentCultureIgnoreCase;
			if (!Config.Instance.IgnoreCase)
				sc = StringComparison.Ordinal;
			Print(command);
			PrintFlush(false);
			RefreshStrings(true);
			string com = command.Substring(1);
			if (com.Length == 0)
				return;
			if (com.Equals("REBOOT", sc))
			{
				window.Reboot();
				return;
			}
			else if (com.Equals("OUTPUT", sc))
			{
				this.outputErrorLog();
				return;
			}
			else if ((com.Equals("QUIT", sc)) || (com.Equals("EXIT", sc)))
			{
				window.Close();
				return;
			}
			else
			{
				ConsoleState temp_state = state;
				isDebug = true;
				try
				{
					LogicalLine line = LogicalLineParser.ParseLine(com, null);
					if (line is InvalidLine)
						throw new CodeEE(line.ErrMes);
					if (!(line is InstructionLine))
						throw new CodeEE("fobOR}hŎgpł̂͑ߕł");
					InstructionLine func = (InstructionLine)line;
					if (BuiltInFunctionManager.IsFlowContorol(func.Function))
						throw new CodeEE("t[䖽߂͎gpł܂");
					switch (func.Function)
					{
						case BuiltInFunctionCode.PUTFORM:
						case BuiltInFunctionCode.UPCHECK:
						case BuiltInFunctionCode.WAIT:
						case BuiltInFunctionCode.INPUT:
						case BuiltInFunctionCode.INPUTS:
						case BuiltInFunctionCode.PRINTW:
						case BuiltInFunctionCode.PRINTVW:
						case BuiltInFunctionCode.PRINTSW:
						case BuiltInFunctionCode.PRINTFORMW:
						case BuiltInFunctionCode.PRINTFORMSW:
							throw new CodeEE(func.Function.ToString() + "߂͎gpł܂");
					}
					LogicalLineParser.SetArgumentTo(func, null);
					if (func.IsError)
						throw new CodeEE(func.ErrMes);
					emuera.DoDebugNormalFunction(func);
					if ((func.Function == BuiltInFunctionCode.SET) || (func.Function == BuiltInFunctionCode.SETS))
						PrintLine(func.Position.RowLine);
					PrintFlush(false);
				}
				catch (Exception e)
				{
					PrintLine(e.Message);
				}
				state = temp_state;
			}
			RefreshStrings(true);
			isDebug = false;

		}
		#endregion

		#region `n
		uint lastUpdate = 0;
		uint msPerFrame = 1000 / 60;//60FPS
		ConsoleRedraw redraw = ConsoleRedraw.Normal;
		public void SetRedraw(Int64 i)
		{
			if ((i & 1) == 0)
				redraw = ConsoleRedraw.None;
			else
				redraw = ConsoleRedraw.Normal;
			if ((i & 2) != 0)
				RefreshStrings(true);
		}

		public void SetWindowTitle(string str)
		{
			window.Text = str;
		}

		public string GetWindowTitle()
		{
			return window.Text;
		}


		public void RefreshStrings(bool force)
		{
			RefreshStrings(force, null);
		}
		public void RefreshStrings(bool force, Graphics graph)
		{
			//`撆EmueraƔpꂽPictureBoxɃANZXĂ܂肷̂
			if (!this.Enabled)
				return;
			if ((redraw == ConsoleRedraw.None) && (!force))
				return;
			bool isBackLog = window.ScrollBar.Value != window.ScrollBar.Maximum;
			if (selectingButton != null)
			{
				//\͑I
				if (isBackLog)
					selectingButton = null;
				//l̓͑҂ԂłȂΖ
				else if ((state != ConsoleState.WaitInteger) && (state != ConsoleState.WaitString)
				&& (state != ConsoleState.WaitSystemInteger) && (state != ConsoleState.WaitIntegerWithTimer)
				&& (state != ConsoleState.WaitStringWithTimer))
					selectingButton = null;
				//IŐVłȂȂ疳
				else if (selectingButton.Generation != lastButtonGeneration)
					selectingButton = null;
			}
			if (!force)
			{//forceȂΊmɍĕ`B
				if ((!isBackLog) && (lastDrawnLineNo == lineNo) && (lastSelectingButton == selectingButton))
					return;
				//Environment.TickCount͕\̂winmm̃^C}[Ăŗ
				uint sec = WinmmTimer.TickCount - lastUpdate;
				//܂^C~OłȂȂ玟̍XV҂Ă݂
				//A͑҂ȂǁA΂炭XṼ^C~OȂꍇɂ͋IɏĂ݂
				if (sec < msPerFrame && (state == ConsoleState.Running || state == ConsoleState.Initializing))
				{
					return;
				}
			}
			lastUpdate = WinmmTimer.TickCount;
			barUpdate();
			window.SuspendLayout();
			this.m_RefreshStrings(graph);
			window.ResumeLayout();
			if (Config.Instance.UseImageBuffer)
				window.Refresh();
			if (isBackLog)
				lastDrawnLineNo = -1;
			else
				lastDrawnLineNo = lineNo;
			lastSelectingButton = selectingButton;
			/*fobOpB`悪dz
			System.Threading.Thread.Sleep(50);
			*/
			//Initializing͂ɕpxFǂݍ݂𑁂邽߁B
			if (state == ConsoleState.Initializing)
				lastUpdate = WinmmTimer.TickCount;
		}

		private void m_RefreshStrings(Graphics g)
		{
			if (!this.Enabled)
				return;
			bool isBackLog = window.ScrollBar.Value != window.ScrollBar.Maximum;
			bool areaRefresh = false;
			if (Config.Instance.UseImageBuffer)
				areaRefresh = ((!isBackLog) && (lastDrawnLineNo > 0) && ((lineNo - lastDrawnLineNo - 1) < window.MainPicBox.Height / lineHeight));
			int pointY = window.MainPicBox.Height - lineHeight;
			if (areaRefresh)
			{
				int newLineNum = lineNo - lastDrawnLineNo;
				if (newLineNum != 0)
					shiftBitmap((Bitmap)window.MainPicBox.Image, newLineNum * lineHeight);
			}
			bool onpaint = (g != null);

			Graphics graph = g;
			//if (graph == null)
			//	return;

			if (graph == null)
				graph = getGraphics();

			//graph.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SingleBitPerPixel;
			//graph.PixelOffsetMode = System.Drawing.Drawing2D.PixelOffsetMode.HighSpeed;
			if (Config.Instance.TextDrawingMode == TextDrawingMode.WINAPI)
			{
				GDI.GDIStart(graph, Config.Instance.BackColor);
			}
			if (areaRefresh)
			{//ʂɈړ
				int newLineNum = lineNo - lastDrawnLineNo;
				if (newLineNum != 0)
				{
					for (int i = window.ScrollBar.Value - 1; i >= window.ScrollBar.Value - newLineNum; i--)
					{
						drawDisplayLine(displayLineList[i], graph, pointY, isBackLog, true);
						pointY -= lineHeight;
						if (pointY < (0 - lineHeight))
							break;
					}
				}
				if (lastSelectingButton != selectingButton)
				{
					ConsoleDisplayLine target = null;
					if (lastSelectingButton != null)
					{
						target = lastSelectingButton.ParentLine;
						int pointCount = displayLineList[window.ScrollBar.Value - 1].LineNo - target.LineNo;
						pointY = window.MainPicBox.Height - lineHeight - pointCount * lineHeight;
						drawDisplayLine(target, graph, pointY, isBackLog, true);
					}
					if ((selectingButton != null) &&
					!((lastSelectingButton != null) && (lastSelectingButton.ParentLine == selectingButton.ParentLine)))
					{
						target = selectingButton.ParentLine;
						int pointCount = displayLineList[window.ScrollBar.Value - 1].LineNo - target.LineNo;
						pointY = window.MainPicBox.Height - lineHeight - pointCount * lineHeight;
						drawDisplayLine(target, graph, pointY, isBackLog, true);
					}
				}
			}
			else
			{//S`
				if ((Config.Instance.TextDrawingMode != TextDrawingMode.WINAPI) && (Config.Instance.UseImageBuffer))
					graph.Clear(Config.Instance.BackColor);
				else if ((window.ScrollBar.Value * lineHeight) < (window.MainPicBox.Height))
				{
					int rectBottom = window.MainPicBox.Height - (window.ScrollBar.Value * lineHeight);
					GDI.FillRect(new Rectangle(0, 0, window.MainPicBox.Width, rectBottom));
				}
				for (int i = window.ScrollBar.Value - 1; i >= 0; i--)
				{
					drawDisplayLine(displayLineList[i], graph, pointY, isBackLog, !Config.Instance.UseImageBuffer);
					pointY -= lineHeight;
					if (pointY < 0 - lineHeight)
						break;
				}

			}
			if (Config.Instance.TextDrawingMode == TextDrawingMode.WINAPI)
			{
				GDI.GDIEnd(graph);
			}
			if (!onpaint)
				graph.Dispose();
		}

		void drawDisplayLine(ConsoleDisplayLine line, Graphics g, int pointY, bool isBackLog, bool clear)
		{
			if (Config.Instance.TextDrawingMode == TextDrawingMode.WINAPI)
			{
				//line.GDIClear(pointY);
				line.GDIDrawTo(pointY, isBackLog);
			}
			else
			{
				if (clear)
					line.Clear(new SolidBrush(Config.Instance.BackColor), g, pointY);
				line.DrawTo(g, pointY, isBackLog, true);
			}
		}

		private Graphics getGraphics()
		{
			if (!window.Created)
				throw new ExeEE("݂ȂEBhEɃANZX");
			if (Config.Instance.UseImageBuffer)
				return Graphics.FromImage(window.MainPicBox.Image);
			else
				return window.MainPicBox.CreateGraphics();
		}

		int[] rgbValues;
		private void shiftBitmap(Bitmap bmp, int shiftY)
		{
			Rectangle rect = new Rectangle(0, 0, bmp.Width, bmp.Height);
			System.Drawing.Imaging.BitmapData bmpData =
			bmp.LockBits(rect, ImageLockMode.ReadWrite, PixelFormat.Format32bppArgb);
			IntPtr ptr = bmpData.Scan0;
			int lineBytes = bmp.Width;
			int totalBytes = lineBytes * bmp.Height;
			System.Runtime.InteropServices.Marshal.Copy(ptr, rgbValues, 0, totalBytes);
			System.Runtime.InteropServices.Marshal.Copy(rgbValues, lineBytes * shiftY, ptr, totalBytes);
			bmp.UnlockBits(bmpData);
		}
		#endregion

		#region Printn
		private readonly List<ConsoleDisplayLine> displayLineList;

		private bool useUserStyle = true;
		public bool UseUserStyle { get { return useUserStyle; } set { useUserStyle = value; } }
		private StringStyle defaultStyle = new StringStyle(Config.Instance.ForeColor, FontStyle.Regular, null);
		private StringStyle userStyle = new StringStyle(Config.Instance.ForeColor, FontStyle.Regular, null);
		private StringStyle style = new StringStyle(Config.Instance.ForeColor, FontStyle.Regular, null);
		private StringStyle Style { get { return (useUserStyle ? userStyle : defaultStyle); } }
		public StringStyle StringStyle { get { return userStyle; } }
		public void SetStringStyle(FontStyle fs) { userStyle.FontStyle = fs; }
		public void SetStringStyle(Color color) { userStyle.Color = color; }
		public void SetFont(string fontname) { userStyle.Fontname = fontname; }
		private DisplayLineAlignment alignment = DisplayLineAlignment.LEFT;
		public DisplayLineAlignment Alignment { get { return alignment; } set { alignment = value; } }
		public void ResetStyle()
		{
			style = defaultStyle;
			alignment = DisplayLineAlignment.LEFT;
		}

		string stBar = null;

		/// <summary>
		/// Ōɕ`悵lineNo̒lBɑS`KvƂꍇɂ-PB
		/// </summary>
		int lastDrawnLineNo = -1;
		int lineNo = 0;

		private void addRangeDisplayLine(ConsoleDisplayLine[] lineList)
		{
			for (int i = 0; i < lineList.Length; i++)
				addDisplayLine(lineList[i]);
		}

		private void addDisplayLine(ConsoleDisplayLine line)
		{
			if (LastLineIsTemporary)
				deleteLine(1);
			line.SetAlignment(alignment);
			line.LineNo = lineNo;
			displayLineList.Add(line);
			lineNo++;
			if (lineNo == int.MaxValue)
			{
				lastDrawnLineNo = -1;
				lineNo = 0;
			}
			if (displayLineList.Count > Config.Instance.MaxLog)
				displayLineList.RemoveAt(0);
		}


		public void deleteLine(int argNum)
		{
			int delNum = 0;
			int num = argNum;
			while (delNum < num)
			{
				if (displayLineList.Count == 0)
					break;
				ConsoleDisplayLine line = displayLineList[displayLineList.Count - 1];
				displayLineList.RemoveAt(displayLineList.Count - 1);
				lineNo--;
				if (line.IsLogicalLine)
					delNum++;
			}
			if (lineNo < 0)
				lineNo += int.MaxValue;
			lastDrawnLineNo = -1;
			//RefreshStrings(true);
		}

		public bool LastLineIsTemporary
		{
			get
			{
				if (displayLineList.Count == 0)
					return false;
				return displayLineList[displayLineList.Count - 1].IsTemporary;
			}
		}

		//ŏIs{̍sǉɂ͂̍sėp悤ɐݒ
		public void PrintTemporaryLine(string str)
		{
			PrintSingleLine(str, false, true);
		}

		//ŏIs
		private void changeLastLine(string str)
		{
			deleteLine(1);
			PrintSingleLine(str, false, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="str"></param>
		/// <param name="position"></param>
		/// <param name="level">xx.0:yȃ~X.1:łs.2:ssȂΖQ.3:vI</param>
		public void PrintWarning(string str, ScriptPosition position, int level)
		{
			if (level < Config.Instance.DisplayWarningLevel)
				return;
			//x͋\
			bool b = force_temporary;
			force_temporary = false;
			if (position != null)
			{
				PrintLine(string.Format("xLv{0}:{1}:{2}s:{3}", level, position.Filename, position.LineNo, str));
				PrintLine(position.RowLine);
			}
			else
			{
				PrintLine(string.Format("xLv{0}:{1}", level, str));
			}
			force_temporary = b;
		}

		/// <summary>
		/// EBhETCYlmɈsŏɍBVXepB
		/// </summary>
		/// <param name="str"></param>
		public void PrintLine(string str) { PrintSingleLine(str, false, false); }

		/// <summary>
		/// KsŒɕ`悷B^Cg\pB
		/// </summary>
		/// <param name="str"></param>
		public void PrintCenter(string str) { PrintSingleLine(str, true, false); }
		public void PrintSingleLine(string str, bool center, bool temporary)
		{
			if (string.IsNullOrEmpty(str))
				return;
			PrintFlush(false);
			printBuffer.Append(str, Style);
			ConsoleDisplayLine dispLine = BufferToSingleLine(true, temporary);
			if (dispLine == null)
				return;
			DisplayLineAlignment curAlignment = alignment;
			if (center)
				alignment = DisplayLineAlignment.CENTER;
			addDisplayLine(dispLine);
			alignment = curAlignment;
			RefreshStrings(false);
		}

		public void Print(string str)
		{
			if (string.IsNullOrEmpty(str))
				return;
			int newline = str.IndexOf('\n');
			if (newline > 0)
			{
				string upper = str.Substring(0, newline - 1);
				printBuffer.Append(upper, Style);
				NewLine();
				if (newline < str.Length - 1)
				{
					string lower = str.Substring(newline + 1);
					Print(lower);
				}
				return;
			}
			printBuffer.Append(str, Style);
			return;
		}

		public void PrintC(string str, bool alignmentRight)
		{
			if (string.IsNullOrEmpty(str))
				return;
			int length = 0;
			if (str != null)
				length = Config.Encode.GetByteCount(str);
			int printcLength = Config.Instance.PrintCLength;

			if ((alignmentRight) && (length < printcLength))
				str = new string(' ', printcLength - length) + str;
			else if ((!alignmentRight) && (length < printcLength + 1))
				str += new string(' ', printcLength + 1 - length);
			printBuffer.Append(str, Style, true);
		}

		internal void PrintButton(string str, string p)
		{
			if (string.IsNullOrEmpty(str))
				return;
			printBuffer.AppendButton(str, Style, p);
		}
		internal void PrintButton(string str, long p)
		{
			if (string.IsNullOrEmpty(str))
				return;
			printBuffer.AppendButton(str, Style, p);
		}

		public void NewLine() { PrintFlush(true); }

		public ConsoleDisplayLine BufferToSingleLine(bool force, bool temporary)
		{
			if (!this.Enabled)
				return null;
			if (!force && printBuffer.IsEmpty)
				return null;
			if (force && printBuffer.IsEmpty)
				printBuffer.Append(" ", Style);
			StringMeasure stringMeasure = new StringMeasure(getGraphics());
			ConsoleDisplayLine dispLine = printBuffer.FlushSingleLine(stringMeasure, temporary | force_temporary);
			stringMeasure.Dispose();
			return dispLine;
		}
		public void PrintFlush(bool force) { PrintFlush(force, false); }
		public void PrintFlush(bool force, bool temporary)
		{
			if (!this.Enabled)
				return;
			if (!force && printBuffer.IsEmpty)
				return;
			if (force && printBuffer.IsEmpty)
				printBuffer.Append(" ", Style);

			StringMeasure stringMeasure = new StringMeasure(getGraphics());
			ConsoleDisplayLine[] dispList = printBuffer.Flush(stringMeasure, temporary | force_temporary);
			stringMeasure.Dispose();
			addRangeDisplayLine(dispList);
			RefreshStrings(false);
		}

		/// <summary>
		/// DRAWLINE߂ɑΉB̃tHgύXłƖʓ|ȂƂɂȂ̂RegularɌŒ肷B
		/// </summary>
		public void PrintBar()
		{
			if (stBar == null)
				setStBar(Config.Instance.DrawLineString);
			StringStyle ss = Style;
			style.FontStyle = FontStyle.Regular;
			Print(stBar);
			style = ss;
		}

		private void setStBar(string barStr)
		{
			StringMeasure stringMeasure = new StringMeasure(getGraphics());
			StringBuilder bar = new StringBuilder();
			bar.Append(barStr);
			int width = 0;
			while (width < window.MainPicBox.Width)
			{//Ez܂ňꕶ₷
				bar.Append(barStr);
				width = stringMeasure.GetDisplayLength(bar.ToString(), Config.Instance.Font);
			}
			while (width > window.MainPicBox.Width)
			{//EzAx͒ȂȂ܂ňꕶ炷ibarStrɕ̕񂪂ꍇɑΉ邽߁j
				bar.Remove(bar.Length - 1, 1);
				width = stringMeasure.GetDisplayLength(bar.ToString(), Config.Instance.Font);
			}
			stringMeasure.Dispose();
			stBar = bar.ToString();
		}

		public void ChangeStBar(string barStr) { setStBar(barStr); }
		#endregion

		#region Window.Formn
		public void MoveMouse(Point point)
		{
			ConsoleButtonString select = null;
			//l̓͑҂ԂłȂΖ
			if ((state != ConsoleState.WaitInteger) && (state != ConsoleState.WaitString)
			&& (state != ConsoleState.WaitSystemInteger) && (state != ConsoleState.WaitIntegerWithTimer)
			&& (state != ConsoleState.WaitStringWithTimer))
				goto end;
			//\͖
			if (window.ScrollBar.Value != window.ScrollBar.Maximum)
				goto end;
			int pointX = point.X;
			int pointY = point.Y;
			//\͉牽sځH
			int displayLineNo = (window.MainPicBox.Height - pointY) / lineHeight + 1;
			//ۂ͉sځH
			int lineNo = displayLineList.Count - displayLineNo;
			if ((lineNo < 0) || (lineNo >= displayLineList.Count))
				goto end;
			select = displayLineList[lineNo].GetPointingButton(pointX);
			if ((select == null) || (select.Generation != lastButtonGeneration))
				select = null;
			else if ((state == ConsoleState.WaitInteger || state == ConsoleState.WaitIntegerWithTimer) && (!select.IsInteger))
				select = null;
			else if ((state == ConsoleState.WaitSystemInteger) && (!select.IsInteger))
				select = null;
		end:
			if (select != selectingButton)
			{
				selectingButton = select;
				RefreshStrings(true);
			}
			return;
		}

		public void LeaveMouse()
		{
			if (selectingButton != null)
			{
				selectingButton = null;
				RefreshStrings(true);
			}
		}

		public void MainPicBoxSizeChanged()
		{
			lastDrawnLineNo = -1;
			rgbValues = new int[window.MainPicBox.Width * (window.MainPicBox.Height * 2)];
		}

		private void barUpdate()
		{
			int max = displayLineList.Count;
			int move = max - window.ScrollBar.Maximum;
			if (move == 0)
				return;
			if (move > 0)
			{
				window.ScrollBar.Maximum = max;
				window.ScrollBar.Value += move;
			}
			else
			{
				if (max > window.ScrollBar.Value)
					window.ScrollBar.Value = max;
				window.ScrollBar.Maximum = max;
			}
			window.ScrollBar.Enabled = max > 0;
		}
		#endregion


		private void outputErrorLog()
		{
			if (OutputEmueraLog(Program.ExeDir + "emuera.log"))
			{
				if (window.Created)
					PrintLine("Ot@Cemuera.logɏo͂܂");
			}
		}

		public bool OutputEmueraLog(string filepath)
		{
			StreamWriter writer = null;
			try
			{
				writer = new StreamWriter(filepath, false, Config.Encode);
				foreach (ConsoleDisplayLine line in displayLineList)
				{
					writer.WriteLine(line.ToString());
				}
			}
			catch (Exception)
			{
				MessageBox.Show("Ȍo͂Ɏs܂", "Oo͎s");
				return false;
			}
			finally
			{
				if (writer != null)
					writer.Close();
			}
			return true;
		}

		public bool outputAnalysisLog()
		{
			if (OutputEmueraLog(Program.ExeDir + "Analysis.log"))
			{
				if (window.Created)
					PrintLine("Ot@CAnalysis.logɏo͂܂");
				return true;
			}
			else
				return false;
		}

		public void GetDisplayStrings(StringBuilder builder)
		{
			if (displayLineList.Count == 0)
				return;
			for (int i = 0; i < displayLineList.Count; i++)
			{
				builder.AppendLine(displayLineList[i].ToString());
			}
		}

		public void GotoTitle()
		{
			//if (state == ConsoleState.Error)
			//{
			//    MessageBox.Show("G[͂̋@\͎g܂");
			//}
			displayLineList.Clear();
			ClearDisplay();
			emuera.BeginTitle();
			state = ConsoleState.WaitKey;
			callEmueraProgram("");
			RefreshStrings(true);
		}


		bool force_temporary = false;
		ConsoleState prevState;

		public void ReloadErb()
		{
			if (state == ConsoleState.Error)
			{
				MessageBox.Show("G[͂̋@\͎g܂");
				return;
			}
			if (state == ConsoleState.Initializing)
			{
				MessageBox.Show("͂̋@\͎g܂");
				return;
			}
			prevState = state;
			state = ConsoleState.Initializing;
			PrintSingleLine("ERBēǂݍݒcc", false, true);
			force_temporary = true;
			emuera.ReloadErb();
			force_temporary = false;
			PrintSingleLine("ēǂݍ݊", false, true);
			RefreshStrings(true);
		}
		public void ReloadErbFinished()
		{
			state = prevState;
			PrintLine(" ");
		}
		public void ReloadPartialErb(List<string> path)
		{
			if (state == ConsoleState.Error)
			{
				MessageBox.Show("G[͂̋@\͎g܂");
				return;
			}
			if (state == ConsoleState.Initializing)
			{
				MessageBox.Show("͂̋@\͎g܂");
				return;
			}
			if (!emuera.checkFilePathExist(path))
			{
				MessageBox.Show("Vt@CǂݍނƂ͂ł܂B");
				return;
			}
			prevState = state;
			state = ConsoleState.Initializing;
			PrintSingleLine("ERBēǂݍݒcc", false, true);
			force_temporary = true;
			emuera.ReloadPartialErb(path);
			force_temporary = false;
			PrintSingleLine("ēǂݍ݊", false, true);
			RefreshStrings(true);
		}

		public void ReloadFolder(string erbPath)
		{
			if (state == ConsoleState.Error)
			{
				MessageBox.Show("G[͂̋@\͎g܂");
				return;
			}
			if (state == ConsoleState.Initializing)
			{
				MessageBox.Show("͂̋@\͎g܂");
				return;
			}
			List<string> paths = new List<string>();
			SearchOption op = SearchOption.AllDirectories;
			if (!Config.Instance.GetConfigValue<bool>(ConfigCode.SearchSubdirectory))
				op = SearchOption.TopDirectoryOnly;
			string[] fnames = Directory.GetFiles(erbPath, "*.ERB", op);
			for (int i = 0; i < fnames.Length; i++)
				if (Path.GetExtension(fnames[i]).ToUpper() == ".ERB")
					paths.Add(fnames[i]);
			prevState = state;
			state = ConsoleState.Initializing;
			PrintSingleLine("ERBēǂݍݒcc", false, true);
			force_temporary = true;
			emuera.ReloadPartialErb(paths);
			force_temporary = false;
			PrintSingleLine("ēǂݍ݊", false, true);
			RefreshStrings(true);
		}
	}
}