﻿
namespace MinorShift.Emuera.GameProc.Function
{
	/// <summary>
	/// 命令の引数タイプ
	/// </summary>
	//難読化用属性。enum.ToString()やenum.Parse()を行うなら(Exclude=true)にすること。
	[global::System.Reflection.Obfuscation(Exclude=false)]
	enum FunctionArgType
	{//数値不要
		__NULL__ = 0x0000,//未設定。エラー。引数がないならばVOIDを指定すること。
		METHOD,//式中関数。

		VOID,//引数なし
		INT_EXPRESSION,//数式型。省略可能
		INT_EXPRESSION_NULLABLE,//数式型
		STR_EXPRESSION,//文字列式型
        STR_EXPRESSION_NULLABLE,
		STR,//単純文字列型
		KEYWORD,//単純文字列型。特定の文字のみ有効
		STR_NULLABLE,//単純文字列型、省略可能
		FORM_STR,//書式付文字列型。
		FORM_STR_NULLABLE,//書式付文字列型。省略可能
		SP_PRINTV,//複数数式型。'～～,文字列可
		SP_TIMES,//<数値型変数>,<実数定数>
		SP_BAR,//<数値>,<数値>,<数値>
		SP_SET,//可変数値変数・数式型。
		SP_SETS,//可変文字列変数・単純又は複合文字列型。
		SP_SWAP,//<数値>,<数値>
		SP_VAR,//<変数>
		SP_SAVEDATA,//<数値>,<文字列式>
		SP_TINPUTS,//<数値>,<文字列式>,<数値>
		SP_SORTCHARA,//<キャラクタ変数>,<ソート順序>(両方省略可能)
		SP_CALL,//<文字列>,<引数>,... //引数は省略可能
		SP_CALLF,
		SP_CALLFORM,//<書式付文字列>,<引数>,... //引数は省略可能
		SP_CALLFORMF,//<書式付文字列>,<引数>,... //引数は省略可能
		SP_FOR_NEXT,//<可変数値変数>,<数値>,<数値>,<数値> //引数は省略可能
		SP_POWER,//<可変数値変数>,<数値>,<数値>
		SP_SWAPVAR,//<可変変数>,<可変変数>(同型のみ)
		EXPRESSION,//<式>、変数の型は不問
		EXPRESSION_NULLABLE,//<式>、変数の型は不問
		CASE,//<CASE条件式>(, <CASE条件式>...)
		VAR_INT,//<可変文字変数> //引数は省略可
		BIT_ARG,//<可変数値変数>,<数値>(SP_SETが使えないため新設)
		SP_VAR_SET,//<可変変数>,<数式 or 文字列式 or null>(,<範囲初値>, <範囲終値>)
		SP_BUTTON,//<文字列式>,<数式>
		SP_SET_ARRAY,//可変数値変数・<数式配列型>。未使用
		SP_SETS_ARRAY,//可変文字列変数・<文字列配列型>。未使用
		SP_COLOR,
		SP_SPLIT,//<文字列式>, <文字列式>, <可変文字変数>
		SP_GETINT,//<可変数値変数>(今までこれがないことに驚いた)
		SP_CVAR_SET,//<可変変数>,<式>,<数式 or 文字列式 or null>(,<範囲初値>, <範囲終値>)
		SP_CONTROL_ARRAY,//<可変変数>,<数値>,<数値>
		SP_SHIFT_ARRAY,//<可変変数>,<数値>,<数値or文字列>(,<数値>,<数値>>)
		INT_ANY,//1つ以上の数値を任意数
		FORM_STR_ANY,//1つ以上のFORM文字列を任意数  
        SP_COPYCHARA,//<数値>(, <数値)第二引数省略可
	}
}
