#ifndef _BTRON_H
#define _BTRON_H 1

#include <typedef.h>
#include "sbl.h"

/* 1.1.8 ץ / Υǡ /  */

typedef struct {
  UW state;
  W priority;
  W parpid;
} P_STATE;

typedef struct {
  TC usr_name[14];
  TC grp_name1[14];
  TC grp_name2[14];
  TC grp_name3[14];
  TC grp_name4[14];  
  W level;
  W net_level;
} P_USER;

typedef struct {
  UW etime;
  UW utime;
  UW stime;
  W tmem;
  W wmem;
  W resv[11];
} P_INFO;

#define TERM_NRM 0x0000
#define TERM_ALL 0x0001

#define P_ABS 0x0000
#define P_REL 0x0001
#define P_TASK 0x0002

#define P_WAIT 0x2000
#define P_READY 0x4000
#define P_RUN 0x8000

/* ޤ 1.1.8 ץ / Υǡ /  */

/* 1.2.4 åΥǡ /  */

typedef union {
  struct {
    W pid;
    W code;
  } ABORT;
  struct {
    W pid;
    W code;
  } EXIT;
  struct {
    W pid;
    W code;
  } TERM;
  struct {
    W code;
  } TMOUT;
  struct {
    W code;
  } SYSEVT;
  struct {
    UB msg_str[32];
  } ANYMSG;
} MSGBODY;

typedef struct message {
  W msg_type;
  W msg_size;
  MSGBODY msg_body;
} MESSAGE;

#define MSGSIZE(msgsz) (offsetof(MESSAGE, msg_body) + msgsz)

#define MS_ABORT (1)
#define MS_EXIT (2)
#define MS_TERM (3)
#define MS_TMOUT (4)
#define MS_SYSEVT (5)
#define MS_SYS1 (6)
#define MS_SYS2 (7)
#define MS_SYS3 (8)
#define MS_SYS4 (9)
#define MS_SYS5 (10)
#define MS_MNG0 (11)
#define MS_MNG1 (12)
#define MS_MNG2 (13)
#define MS_MNG3 (14)
#define MS_MNG4 (15)
#define MS_MNG5 (16)
#define MS_MNG6 (17)
#define MS_MNG7 (18)
#define MS_MNG8 (19)
#define MS_MNG9 (20)
#define MS_MNG10 (21)
#define MS_MNG11 (22)
#define MS_MNG12 (23)

#define MS_TYPE0 (24)
#define MS_TYPE1 (25)
#define MS_TYPE2 (26)
#define MS_TYPE3 (27)
#define MS_TYPE4 (28)
#define MS_TYPE5 (29)
#define MS_TYPE6 (30)
#define MS_TYPE7 (31)

#define MS_MIN (1)
#define MS_MAX (31)

#define MSGMASK(msgtype) (1 << ((msgtype) - 1))

#define MM_ABORT MSGMASK(MS_ABORT)
#define MM_EXIT MSGMASK(MS_EXIT)
#define MM_TERM MSGMASK(MS_TERM)
#define MM_TMOUT MSGMASK(MS_TMOUT)
#define MM_SYSEVT MSGMASK(MS_SYSEVT)
#define MM_SYS1 MSGMASK(MS_SYS1)
#define MM_SYS2 MSGMASK(MS_SYS2)
#define MM_SYS3 MSGMASK(MS_SYS3)
#define MM_SYS4 MSGMASK(MS_SYS4)
#define MM_SYS5 MSGMASK(MS_SYS5)
#define MM_MNG0 MSGMASK(MS_MNG0)
#define MM_MNG1 MSGMASK(MS_MNG1)
#define MM_MNG2 MSGMASK(MS_MNG2)
#define MM_MNG3 MSGMASK(MS_MNG3)
#define MM_MNG4 MSGMASK(MS_MNG4)
#define MM_MNG5 MSGMASK(MS_MNG5)
#define MM_MNG6 MSGMASK(MS_MNG6)
#define MM_MNG7 MSGMASK(MS_MNG7)
#define MM_MNG8 MSGMASK(MS_MNG8)
#define MM_MNG9 MSGMASK(MS_MNG9)
#define MM_MNG10 MSGMASK(MS_MNG10)
#define MM_MNG11 MSGMASK(MS_MNG11)
#define MM_MNG12 MSGMASK(MS_MNG12)

#define MM_TYPE0 MSGMASK(MS_TYPE0)
#define MM_TYPE1 MSGMASK(MS_TYPE1)
#define MM_TYPE2 MSGMASK(MS_TYPE2)
#define MM_TYPE3 MSGMASK(MS_TYPE3)
#define MM_TYPE4 MSGMASK(MS_TYPE4)
#define MM_TYPE5 MSGMASK(MS_TYPE5)
#define MM_TYPE6 MSGMASK(MS_TYPE6)
#define MM_TYPE7 MSGMASK(MS_TYPE7)

#define MM_ALL (0x7fffffff)
#define MM_NULL (0)

#define WAIT 0x0000
#define NOWAIT 0x0001
#define CONFM 0x0002
#define CHECK 0x0002     /* 0x0003 δְ㤤 */
#define WAIEVT 0x0004

#define MH_NONE ((FUNCP)1)
#define MH_BREAK ((FUNCP)2)
#define MH_TERM ((FUNCP)3)

/* ޤ 1.2.4 åΥǡ /  */

/* 1.6 ե */

#define L_FSNM 20
#define L_DLNM 20
#define L_DEVNM 8
#define L_CONNM 8
#define L_USRNM (12+2)
#ifndef EOTA
#define L_FNM 20
#else
#define L_FNM 14 /* EOTA SFS ¤ 20 ѹ */
#endif /* !EOTA */
#define L_PATHNM 256 /* Ǥ褤Τ <- ʤפäΤ */

#define N_GRP 4

#ifdef notdef
/* 졩 */
#define TC_FDLM 0xff21
#define TC_FSEP 0xff22
#define TC_FOWN 0xff23
#endif /* notdef */

#define F_NORM 0x0000
#define F_BASED 0x0001
#define F_DIRECT 0x0002

#define F_READ 0x0004
#define F_WRITE 0x0002
#define F_UPDATE 0x0006

#define F_EXCL 0x0100
#define F_WEXCL 0x0200

#define F_FLOAT 0x0000
#define F_FIX 0x0001
#define F_FILEID 0x0002

#define F_FWD 0x0000
#define F_NFWD 0x0001
#define F_BWD 0x0002
#define F_NBWD 0x0003
#define F_TOPEND 0x0004
#define F_ENDTOP 0x0005

#define F_SFILE 0x4000
#define F_SNAME 0x2000
#define F_SATR1 0x1000
#define F_SATR2 0x0800
#define F_SATR3 0x0400
#define F_SATR4 0x0200
#define F_SATR5 0x0100

#define F_UNLOCK 0x0000
#define F_LOCK 0x0001
#define F_TSLOCK 0x0002
#define F_CKLOCK 0x0003

#define F_READ 0x0004
#define F_WRITE 0x0002
#define F_EXCUTE 0x0001
#define F_COMMON 0x0100
#define F_SYSTEM 0x0300

#define F_READ 0x0004
#define F_WRITE 0x0002
#define F_EXCUTE 0x0001
#define F_EXIST 0x0000

#define F_PASWD 0x0008

#define F_SETRONLY 0x0001
#define F_RSTRONLY 0x0002
#define F_SETPERM 0x0003
#define F_RSTPERM 0x0004
#define F_SETA1 0x0005
#define F_RSTA1 0x0006
#define F_SETA2 0x0007
#define F_RSTA2 0x0008

#define FS_SYNC 0x0000
#define FS_ASYN 0x0002
#define FS_RONLY 0x0001

#define F_GETDEV (-1)
#define F_GETNAM (-2)

#define F_SYNC 0
#define F_DNAME 1
#define F_DDATE 2
#define F_DBOTH 3

typedef struct {
  UH f_ownacc;
  UH f_grpacc;
  UH f_pubacc;
  H f_grpno;
} A_MODE;

typedef struct {
  UH f_ownacc;
  UH f_grpacc;
  UH f_pubacc;
  H f_grpno;
  UH f_gacc[N_GRP];
} DA_MODE;

typedef struct {
  STIME f_ltime;
  STIME f_atime;
  STIME f_mtime;
} F_TIME;

typedef struct {
  UH f_type;
  UH f_atype;
  TC f_owner[L_USRNM];
  TC f_group[L_USRNM];
  UH fgrpacc;
  UH f_pubacc;
  H f_nlink;
  H f_index;
  W f_size;
  W f_nblk;
  W f_nrec;
  STIME f_ltime;
  STIME f_atime;
  STIME f_mtime;
  STIME f_ctime;
} F_STATE;

#define F_FILE 0x1000

#define F_APLATR1 0x0040
#define F_APLATR2 0x0080
#define F_RONLY 0x0010
#define F_PERM 0x0020

#define F_OWNACC 0x0007
#define F_OWNACR 0x0004
#define F_OWNACW 0x0002
#define F_OWNACE 0x0001

#define F_NOCHG 0x8000

typedef struct {
  STIME fs_ctime;
  TC fs_name[L_FSNM];
  TC fs_locat[L_DLNM];
  TC fs_dev[L_DEVNM];
} F_LOCATE;

typedef struct {
  STIME f_ctime;
  UH f_atype;
  TC f_name[L_FNM];
  UH f_id;
  STIME rf_ctime;
  TC fs_name[L_FSNM];
  TC fs_locat[L_DLNM];
} F_LINK;

typedef struct {
  H fs_bsize;
  UH fs_nfile;
  H fs_lang;
  H fs_level;
  W fs_nblk;
  W fs_nfree;
  STIME fs_mtime;
  STIME fs_ctime;
  TC fs_name[L_FSNM];
  TC fs_locat[L_DLNM];
} FS_STATE;

#define F_JPN 0x0021
#define F_ENG 0x0080

typedef struct {
  TC a_name[L_CONNM];
  TC dev_[L_DEVNM];
} F_ATTACH;

/* LINK ¤Τ typedef.h ˤ */

/* ޤ 1.6 ե */

/* 1.7.5 ٥ȴΥǡ/ */

typedef union {
  struct {
    UH keytop;
    TC code;
  } key;
  struct {
    H kind;
    H devno;
  } dev;
  W info;
} EVDATA;

typedef struct {
  W type;
  UW time;
  PNT pos;
  EVDATA data;
  UW stat;
} EVENT;

#define EV_NULL 0
#define EV_BUTDWN 1
#define EV_BUTUP 2
#define EV_KEYDWN 3
#define EV_KEYUP 4
#define EV_AUTKEY 5
#define EV_DEVICE 6
#define EV_RSV 7
#define EV_APPL1 8
#define EV_APPL2 9
#define EV_APPL3 10
#define EV_APPL4 11
#define EV_APPL5 12
#define EV_APPL6 13
#define EV_APPL7 14
#define EV_APPL8 15

#define EM_NULL 0x0000
#define EM_ALL 0x7fff
#define EM_BUTDWN 0x0001
#define EM_BUTUP 0x0002
#define EM_KEYDWN 0x0004
#define EM_KEYUP 0x0008
#define EM_AUTKEY 0x0010
#define EM_DEVICE 0x0020
#define EM_RSV 0x0040
#define EM_APPL1 0x0080
#define EM_APPL2 0x0100
#define EM_APPL3 0x0200
#define EM_APPL4 0x0400
#define EM_APPL5 0x0800
#define EM_APPL6 0x1000
#define EM_APPL7 0x2000
#define EM_APPL8 0x4000

#define ES_BUT 0x00000001
#define ES_BUT2 0x00000002
#define ES_ALPH 0x00000004
#define ES_KANA 0x00000008
#define ES_LSHFT 0x00000010
#define ES_RSHFT 0x00000020
#define ES_EXT 0x00000040
#define ES_CMD 0x00000080
#define ES_LLSHFT 0x00000100
#define ES_LRSHFT 0x00000200
#define ES_LEXT 0x00000400
#define ES_LCMD 0x00000800
#define ES_TLSHFT 0x00001000
#define ES_TRSHRT 0x00002000
#define ES_TEXT 0x00004000
#define ES_TCMD 0x00008000
#define ES_HAN 0x00010000
#define ES_NODSP 0x00400000
#define ES_PDSIM 0x00800000

#define IM_HIRA 0x0000
#define IM_ALPH (ES_ALPH)
#define IM_KATA (ES_KANA)
#define IM_CAPS (ES_ALPH | ES_KANA)
#define IM_MASK (ES_ALPH | ES_KANA)

#define KIN_KANA 0x0000
#define KIN_ROMAN 0x0001

/* ǥХ٥Ȥμ (DevEvtKind) Ѱդʤ */

#define EP_NONE 0x0000
#define EP_POS 0x0001
#define EP_STAT 0x0002
#define EP_TIME 0x0004
#define EP_ALL 0x0007

#define PD_REV 0x1000
#define PD_ABS 0x0100
#define PD_REL 0x0000
#define PD_SCMSK 0x00f0
#define PD_SNMSK 0x000f

typedef struct {
  UH kind;
  UH maker;
  UB id[4];
} KBD_ID;

#define KEYMAX 256

typedef UB KeyMap[KEYMAX/8];

#define KCTSEL 64
#define KCTMAX 4000

typedef struct {
  W keymax;
  W kctmax;
  UH kctsel[KCTSEL];
  UH kct[KCTMAX];
} KeyTab;

/* GET_BUZ_*, SET_BUZ_* Ͼά */

/* ޤ 1.7.5 ٥ȴΥǡ/ */

/* 2.2 ܳǰ */

#ifdef notdef
/* typedef.h ƤΤǥȥ */
typedef struct Point {
  H x;
  H y;
} PNT;

typedef union Rectangle {
  struct {
    H left;
    H top;
    H right;
    H bottom;
  } c;
  struct {
    PNT lefttop;
    PNT rightbot;
  } p;
} RECT;
#endif /* notdef */

/* 2.2.1 ɸʿ//Ĺ */

/* ʤǰäΤǥȥ */
#ifdef notdef
typedef struct RectangleList {
  RectangleList *next;
  RECT comp;
} RLIST;
#endif

/* ޤ 2.2.1 */

#define PLANES (1)
typedef struct Bitmap {
  UW planes;
  UH pixbits;
  UH rowbytes;
  RECT bounds;
  UB *baseaddr[PLANES];
} BMP;

typedef W PIXVAL;

typedef struct CompactedBitmap {
  W compac;
  BMP bmp;
} CBMP;

enum ImageCompactionMethod {
  NOCOMPAC = 0,
  MHCOMPAC = 1,
  MR2COMPAC = 2,
  MR4COMPAC = 3
};

struct ColorDescription {
  UW trans:1;
  UW crep:3;
  UW cval:28;
};

typedef UW COLOR;

typedef W GID;

typedef struct {
  H attr;
  H planes;
  H pixbits;
  H hpixels;
  H vpixels;
  H hres;
  H vres;
  H color[4];
  H resv[6];
} DEV_SPEC;

typedef struct ColorSpec {
  W attr;
  H info[4];
  COLOR *colmap;
} CSPEC;

#define NX 1
#define NS 1

typedef struct HorizontalRegion {
  UH nx;
  UH x[NX];
} HRGN;

typedef struct GenericRegion {
  RECT r;
  UW ns;
  struct {
    UH y;
    HRGN *hp;
  } s[NS];
} GRGN;

enum DrawingCopyMode {
  G_STORE = 0,
  G_XOR = 1,
  G_OR = 2,
  G_AND = 3,
  G_CPYN = 4,
  G_XORN = 5,
  G_ORN = 6,
  G_ANDN = 7,
  G_NOP = 8
};

enum MackPixelMode {
  G_MASK = 0x0400,  /* ,̵ǤΤ */ /* Ϥܤä */
  G_MASKN = 0x0800
};

typedef W DCM;

typedef W PatKind;

typedef union Pattern {
  struct {
    PatKind kind;
    UH hsize;
    UH vsize;
    COLOR fgcol;
    COLOR bgcol;
    UB *mask;
  } spat;
  struct {
    PatKind kind;
    UH hsize;
    UH vsize;
    UB *mask;
    BMP *bmap;
  } mpat;
  struct {
    PatKind kind;
    UH hsize;
    UH vsize;
    UB *pat;
  } ipat;
} PAT;
/* `;' ȴƤΤȡpattern  Pattern äƤΤǽ */

enum StdPatternMask {
  _FILL0 = (1),
  _FILL12 = (2),
  _FILL25 = (3),
  _FILL50 = (4),
  _FILL75 = (5),
  _FILL87 = (6),
  _FILL100 = (7)
};

#define FILL0 ((B*)_FILL0)
#define FILL12 ((B*)_FILL12)
#define FILL25 ((B*)_FILL25)
#define FILL50 ((B*)_FILL50)
#define FILL75 ((B*)_FILL75)
#define FILL87 ((B*)_FILL87)
#define FILL100 ((B*)_FILL100)

enum StdPattern {
  _WHITE0 = (1),
  _BLACK12 = (2),
  _BLACK25 = (3),
  _BLACK50 = (4),
  _BLACK75 = (5),
  _BLACK87 = (6),
  _BLACK100 = (7)
};

#define WHITE0 ((PAT*)_WHITE0)
#define BLACK12 ((PAT*)_BLACK12)
#define BLACK25 ((PAT*)_BLACK25)
#define BLACK50 ((PAT*)_BLACK50)
#define BLACK75 ((PAT*)_BLACK75)
#define BLACK87 ((PAT*)_BLACK87)
#define BLACK100 ((PAT*)_BLACK100)

enum LineKind {
  LN_SOLID = 0,
  LN_DASH = 1,
  LN_DOT = 2,
  LN_DDASH = 3,
  LN_DDDASH = 4,
  LN_LDASH = 5,
  /* ͽ */
  LN_MASK = 255
};

typedef W LATTR;

enum CharacterDirection {
  TORIGHT = 0,
  TOLEFT = 1,
  TOUP = 2,
  TODOWN = 3,
  TOARB = 4
};
/* ͽǤϹ `;' ˤʤäƤ */

typedef struct SignedGap {
  H dir;
  UH gap;
} SGAP;

typedef struct CharacterGap {
  SGAP hgap;
  SGAP vgap;
  SGAP hspgap;
  SGAP vspgap;
} CGAP;

/* L_FONTFAMNM ʤΤɲ */
#define L_FONTFAMNM 10    /* Ŭʿ */

typedef struct ExtendFontSpecifier {
  TC name[L_FONTFAMNM];
  UW fclass;
  UW attr;
  SIZE size;
} FSSPEC;

typedef struct FontInfo {
  UH height;
  UH width;
  UH base;
  UH leading;
} FNTINFO;

/* ʾ塢2.2 ܳǰ */

/* 2.3 ܴؿΥ顼 */

#define EG_ADR ((-64) << 16)
#define EG_PAR ((-65) << 16)
#define EG_NOSPT ((-66) <<16)
#define EG_NOSPC ((-67) << 16)
#define EG_GID ((-68) << 16)
#define EG_LOCK ((-69) << 16)
#define EG_LIMIT ((-70) << 16)
#define EG_NOEXS ((-71) << 16)
#define EG_DEV ((-72) << 16)
#define EG_ERDEV ((-73) << 16)
#define EG_FORM ((-80) << 16)
#define EG_ENV ((-81) << 16)

/* 2.4.2 ޷ؿĹ */

typedef UW DEG;

/* 2.4.2 ޷ؿĹ */

/* 2.6 ݥؿ */

typedef W PTRSTL;

typedef struct PointerStatus {
  PNT pos;
  PTRSTL style;
  COLOR fgcol;
  COLOR bgcol;
  W motion;
  W hidden;
  W size;
} PTRSTS;

enum StdPointerShape {
  PS_SELECT,
  PS_MODIFY,
  PS_MOVE,
  PS_VMOVE,
  PS_HMOVE,
  PS_GRIP,
  PS_VGRIP,
  PS_HGRIP,
  PS_RSIZ,
  PS_VRSIZ,
  PS_HRSIZ,
  PS_PICK,
  PS_VPICK,
  PS_HPICK,
  PS_BUSY,
  PS_MENU
};

#define MAX_PTR_SIZE 64
#define P_SIZE (MAX_PTR_SIZE * MAX_PTR_SIZE) / 8

typedef struct PointerImage {
  PNT hotpt;
  SIZE size;
  UB data[P_SIZE];
  UB mask[P_SIZE];
} PTRIMG;

/* NULL ʤäΤɲ */
#define NULL 0L

/* 3.1 ɥޥ͡ */

#define WA_FRONT 0x0001
#define WA_SUBW 0x0002
#define WA_SIZE 0x0004
#define WA_HHDL 0x0008
#define WA_VHDL 0x0010
#define WA_RBAR 0x0020
#define WA_BBAR 0x0040
#define WA_LBAR 0x0080
#define WA_TITL 0x0100
#define WA_BGDSP 0x0200
#define WA_FULL 0x0400
#define WA_SFULL 0800
#define WA_STD 0
#define WA_WORK 0x1000
#define WA_FRAME 0x2000
#define WA_FMOVE 0x4000
#define WA_NORMAL 0x007c

typedef struct {
  UW frame;
  UW tlbg;
  UW barpat;
  UW barbg;
  COLOR tlcol;
} WDDISP;

/*  3.1.3 ɥޥ͡Υǡ/ */
typedef struct SEVENT {
  W type;
  UW time;
  PNT pos;
  H cmd;
  H wid;
  UW stat;
} SEVENT;

typedef struct REVENT {
  W type;
  RECT r;
  H cmd;
  H wid;
  W src;
} REVENT;

typedef struct GEVENT {
  W type;
  H data[4];
  H cmd;
  H wid;
  W src;
} GEVENT;

typedef union _WEVENT {
  EVENT e;
  SEVENT s;
  REVENT r;
  GEVENT g;
} WEVENT;

#define EV_SWITCH 8
#define EV_REQUEST 9
#define EV_MENU 10
#define EV_RSWITCH 16
#define EV_INACT 17
#define EV_MSG 18
#define EV_NOMSG 19

#define W_WORK 0
#define W_FRAM 1
#define W_PICT 2
#define W_TITL 3
#define W_LTHD 4
#define W_RTHD 5
#define W_LBHD 6
#define W_RBHD 7
#define W_RBAR 8
#define W_BBAR 9
#define W_LBAR 10

#define W_SWITCH 128
#define W_CLOSED 129

#define W_REDISP 0
#define W_PASTE 1
#define W_DELETE 2
#define W_FINISH 3
#define W_OPEND 5

#define W_ACK 0x40
#define W_NAK 0x80

#ifdef notdef
#define CLR 0       /* typedef.h  #define CLR 0x0000  */
#define NOCLR 8     /* typedef.h  #define NOCLR 0x0008  */
#endif /* notdef */
#ifdef notdef
#define WAIT 0      /* 1.2.4 åǴƤ */
#define NOWAIT 1    /* Ʊ */
#endif /* notdef */
#define NOMSG 0x0010
#define RAWEVT 0x0020
#define DRGEVT 0x0030

#define W_NORM 0
#define W_FULL 1

#define W_MOVE 0
#define W_MOVEC 1
#define W_HOLD 2

#define W_SCRL 1

#define W_VALID 1
#define W_NOOVL 2
#define W_RDSET 4

typedef struct wdstat {
  UW attr;
  W parent;
  W pid;
  RECT r;
  RECT wr;
  RECT org;
} WDSTAT;

#define W_PRESS 0
#define W_QPRESS 1
#define W_CLICK 2
#define W_DCLICK 3

/* ޤ 3.1.3 ɥޥ͡㡼 */

/* 3.2.2 ǡ / */
typedef W MNID;

#define MC_LINE 0x1004
#define MC_KEY 0x10f0
#define MC_IND 0x1100
#define MC_SEL 0x1200

#define MC_KEY1 0x1010
#define MC_KEY2 0x1020
#define MC_KEY3 0x1030
#define MC_KEY4 0x1040
#define MC_KEY5 0x1050
#define MC_KEY6 0x1060
#define MC_KEY7 0x1070
#define MC_KEY8 0x1080
#define MC_KEY9 0x1090
#define MC_KEY10 0x10a0
#define MC_KEY11 0x10b0
#define MC_KEY12 0x10c0
#define MC_KEY13 0x10d0
#define MC_KEY14 0x10e0
#define MC_KEY15 0x10f0

typedef struct menuitem {
  UW inact;
  UW select;
  W desc;
  W dnum;
  TC *ptr;
} MENUITEM;

typedef struct menudisp {
  UW m_frame;
  UW s_frame;
  UW m_bgpat;
  UW s_bgpat;
  UW s_indpat;
  COLOR m_chcol;
  COLOR s_chcol;
  COLOR s_keycol;
} MENUDISP;

typedef struct gmenu {
  UW frame;
  UW bgpat;
  UW indpat;
  COLOR chcol;
  RECT area;
  UW inact;
  UW select;
  W desc;
  W dnum;
  TC *ptr;
  W nitem;
  RECT r[32];
} GMENU;

#define M_STAT 0
#define M_SEL 1
#define M_NOSEL 4
#define M_ACT 8
#define M_INACT 2

#define M_LASTPOS 0x000
#define M_FIXPOS 0x0002

/* ޤ 3.2.2 ǡ /  */

/*  3.3.3 ѡĥޥ͡Υǡ /  */

typedef W PAID;

typedef struct {
  W frpat;
  W bgpat;
  COLOR chcol;
  W misc;
} PARTDISP;

typedef struct textbox {
  UW type;
  RECT r;
  W txsize;
  TC *text;
  PARTDISP atr;
} TEXTBOX;

typedef struct numbox {
  UW type;
  RECT r;
  UW fmt;
  union {
    W l;
    double d;
  } cv;
  PARTDISP atr;
} NUMBOX;

typedef struct serbox {
  UW type;
  RECT r;
  TC *fmt;
  W nfls;
  W *cv;
  PARTDISP atr;
} SERBOX;

typedef struct swsel {
  UW type;
  RECT r;
  W cv;
  TC *name;
  PARTDISP atr;
} SWSEL;

typedef struct pictsw {
  UW type;
  RECT r;
  W cv;
  W onpat;
  W offpat;
  PARTDISP atr;
} PICTSW;

typedef struct volume {
  UW type;
  RECT r;
  W clo, chi;
  W lo, hi;
  W patnum;
  PARTDISP atr;
} VOLUME;

typedef union parts {
  TEXTBOX tb;
  NUMBOX nb;
  SERBOX sb;
  SWSEL ss;
  PICTSW pw;
  VOLUME vl;
} PARTS;

#define TB_PARTS 1
#define XB_PARTS 2
#define NB_PARTS 3
#define SB_PARTS 4
#define AS_PARTS 5
#define MS_PARTS 6
#define PA_PARTS 7
#define PM_PARTS 8
#define WS_PARTS 9
#define SS_PARTS 10
#define VL_PARTS 11

#define P_TYPE 0x001f

#define P_HALIGN 0x0020
#define P_PRESS 0x0040
#define P_NUMBER 0x0040
#define P_DOUBLE 0x0040

#define P_SBAR 0x0040
#define P_DCLOCK 0x0080
#define P_NOSEL 0x0080
#define P_APPEND 0x0080
#define P_NONOB 0x0080

#define P_EMPHAS 0x0200
#define P_NOFRAME 0x0400
#define P_DISABLE 0x0800
#define P_INACT 0x1000
#define P_BLINK 0x2000
#define P_DISP 0x4000

#define P_PARTDISP 0x8000

#define MC_STR 0x1000
#define MC_FIG 0x1001
#define MC_ATTR 0x1002
#define MC_EMPHAS 0x1400
#define MC_INACT 0x1800

#define MC_SFLD 0x0800
#define MC_NFLD 0x0c00
#define MC_NZERO 0x0200
#define MC_NLEFT 0x0100

#define P_LNUM 0x0000
#define P_DNUM 0x0080
#define P_FIX0 0x0000
#define P_FIX1 0x0010
#define S_UNDEF 0x8000
#define L_UNDEF 0x80000000
#define D_UNDEF 1.797693e308

#define P_CHANGE 0x1000
#define P_BREAK 0x2000
#define P_SMASK 0x0fff
#define P_MENU 0x6010
#define P_EVENT 0x6020

#define P_SGL 1
#define P_DBL 2

#define P_TAB 0
#define P_NL 1
#define P_END 2
#define P_BUT 3
#define P_MOVE 4
#define P_COPY 5

#define P_UP 0
#define P_DOWN 1
#define P_LEFT 2
#define P_RIGHT 3

#define P_SMOOTH 0
#define P_AREA 4
#define P_JUMP 8

#define P_ERASE 0x0000
#define P_NODISP 0x1000
#define P_RDISP 0x8000

#define P_NORMAL 0x0002
#define P_FRAME 0x0004
#define P_ENAME 0x0008
#define P_ACT 0x0010

/* ޤ 3.3.3 ѡĥޥ͡Υǡ /  */

/* 3.4.2 ѥͥޥ͡Υǡ */

typedef W PNID;

#define NULL_ITEM 0
#define PTR_ITEM 1
#define PICT_ITEM 2
#define PAT_ITEM 3
#define BMAP_ITEM 4
#define FIG_ITEM 5
#define TEXT_ITEM 6
#define PARTS_ITEM 7

#define ACT_ITEM 0x80
#define BLT_TEXT 0x40
#define ATR_TEXT 0x20

typedef struct pnl_item {
  UW itype;
  UW info;
  RECT ir;
  W desc;
  W dnum;
  H *ptr;
} PNL_ITEM;

typedef struct panel {
  UW oframe;
  UW iframe;
  W bgpat;
  RECT r;
  W defsw;
  W nitem;
  PNL_ITEM *item;
} PANEL;

/* ޤ 3.4.2 ѥͥޥ͡ */

/*  3.8.4 ¿/ȥޥ͡Υǡ /  */
/* ޤ */

typedef struct {
  W type;
  W size;
  LINK self;
  LINK lnk;
  W vid;
  W pwid;
  W info;
  RECT r;
  COLOR bgcol;
  W mode;
} M_EXECREQ;

/* ޤ 3.8.4 ¿/ȥޥ͡Υǡ /  */

/*  3.9.2 եȥޥ͡Υǡ /  */
/* prac03ck.c Ѥ */

#define FTC_DEFAULT 0x80000000

/* ޤ 3.9.2 եȥޥ͡ */


/*  1.1.9 ץ / Υץȥ */

WERR cre_prc(LINK* lnk, W pri, MESSAGE* msg);

VOID ext_prc(W code);

ERR ter_prc(W pid, W code, W opt);

WERR prc_sts(W pid, P_STATE* buff, TC* name);

/* ޤ 1.1.9 ץ / Υץȥ */

/*  1.2.5 åΥץȥ */

ERR snd_msg(W pid, MESSAGE* msg, W opt);

WERR rcv_msg(W t_mask, MESSAGE* msg, W msgsz, W opt);

ERR clr_msg(W t_mask, W last_mask);

/* ޤ 1.2.5 åΥץȥ */

/*  1.6.8 եΥץȥ */

WERR get_lnk(TC *path, LINK *lnk, W mode);

ERR chg_wrk(LINK *lnk);

WERR opn_fil(LINK *lnk, W o_mode, TC *pwd);

ERR cls_fil(W fd);

/* ޤ 1.6.8 եΥץȥ */

/*  1.7.6 ٥ȴΥץȥ */

ERR get_etm(UW* time);

ERR sig_buz(W type);

/* ޤ 1.7.6 ٥ȴΥץȥ */

/*  2.3.1 Υץȥ */

ERR gcls_env(GID gid);

ERR gset_vis(GID gid, RECT r);

ERR gget_spc(TC *dev, DEV_SPEC *buf);

ERR gcnv_abs(GID gid, PNT *pp);

/* ޤ 2.3.1 Υץȥ */

/*  2.4.1 ޷ؿΥץȥ */

ERR gdra_lin(GID gid, PNT p1, PNT p2, LATTR attr, PAT *pat, DCM mode);

ERR gdra_pnt(GID gid, PNT p, PIXVAL val, DCM mode);

ERR gfra_rec(GID gid, RECT r, LATTR attr, PAT *pat, DEG angle, DCM mode);

ERR gfil_rec(GID gid, RECT r, PAT *pat, DEG angle, DCM mode);

ERR gfra_ovl(GID gid, RECT r, LATTR attr, PAT *pat, DEG angle, DCM mode);

ERR gfil_ovl(GID gid, RECT r, PAT *pat, DEG angle, DCM mode);

/* ޤ 2.4.1 ޷ؿΥץȥ */

/*  2.5.1 ʸ()ؿΥץȥ */

ERR gset_chp(GID gid, W x, W y, Bool abs);

ERR gset_chc(GID gid, COLOR fgc, COLOR bgc);

ERR gset_fon(GID gid, FSSPEC *fnt);

WERR gdra_str(GID gid, TC *str, W len, DCM mode);

WERR gdra_stp(GID gid, W x, W y, TC *str, W len, DCM mode);

/* ޤ 2.5.1 ʸ()ؿΥץȥ */

/* ݥؿΥץȥ */

ERR gset_ptr(PTRSTL style, PTRIMG *img, COLOR fgcol, COLOR bgcol);

W gget_ptr(PTRSTS *sts, PTRIMG *img);

ERR gdsp_ptr(W req);

/* ޤǥݥؿΥץȥ */

/*  3.1.4 ɥޥ͡Υץȥ */

WID wopn_wnd(UW attr, UW par, RECT *r, RECT *org, W pict, TC *tit, 
             PAT *bgpat, WDDISP *atr);

ERR wcls_wnd(W wid, W opt);

W wmov_drg(WEVENT *evt, RECT *newr);

W wrsz_drg(WEVENT *evt, RECT *limit, RECT *newr);

W wsta_dsp(W wid, RECT *r, ...);    /* ѥ̤ѹ */

W wend_dsp(W wid);

GID wsta_drg(W wid, W lock);

ERR wend_drg(void);

W wget_drg(PNT *pos, WEVENT *evt);

W wget_evt(WEVENT *evt, W mode);

ERR wugt_evt(WEVENT *evt);

ERR wpas_evt(WEVENT *evt);

ERR wswi_wnd(W wid, WEVENT *evt);

W wsnd_evt(WEVENT *evt);

ERR wrsp_evt(WEVENT *evt, W nak);

W wwai_rsp(WEVENT *evt, W cmd, UW tmout);

ERR wreq_dsp(W wid);

W wfnd_wnd(PNT *gpos, PNT *lpos, W *wid);

WID wget_act(W *pid);

W wget_sts(W wid, WDSTAT *stat, WDDISP *art);

GID wget_gid(W wid);

ERR wera_wnd(W wid, RECT *r);

ERR wget_wrk(W wid, RECT *r);

ERR wset_wrk(W wid, RECT *r);

ERR wget_dmn(TC **dmenu);

W wexe_dmn(W item);

ERR wdef_fep(W onoff);

W wchk_dck(UW first);

ERR wget_inf(W item, VP buf, W size);

/* ޤ 3.1.4 ɥޥ͡Υץȥ */

/*  3.2.3 ˥塼ޥ͡Υץȥ */

MNID mcre_men(W nitem, MENUITEM *item, MENUDISP *attr);

ERR mdel_men(W mid);

W msel_men(W mid, PNT pos);

W mfnd_key(W mid, TC ch);

ERR mset_itm(W mid, W pnum, MENUITEM *item);

W mchg_atr(W mid, W selnum, UW mode);

/* ޤ 3.2.3 ˥塼ޥ͡Υץȥ */

/*  3.3.4 ѡĥޥ͡Υץȥ */

PAID ccre_par(W wid, PARTS *parts);

ERR cdsp_par(W pid, UW vis);

ERR cdsp_pwd(W wid, RECT *r, UW vis);

W cchk_par(W pid, PNT pos);

W cfnd_par(W wid, PNT pos, W *pid);

W cact_par(W pid, WEVENT *ev);

W cget_val(W pid, W size, W *value);

W cset_val(W pid, W size, W *value);

ERR cset_dat(W pid, W par);

W ccut_txt(W pid, W size, TC *buff, W cut);

W cins_txt(W pid, PNT pos, TC *buff);

ERR cchg_pwd(W wid, UW cmd);

ERR cidl_par(W wid, PNT *pos);

W cexe_par(W pid, WEVENT *ev);

/* ޤ 3.3.4 ѡĥޥ͡Υץȥ */

/*  3.4.3 ѥͥޥ͡Υץȥ */

PNID pcre_pnl(PANEL *pnl, PNT *p);

ERR pdel_pnl(W pnid);

W pact_pnl(W pnid, EVENT *ev, W *itemno);

ERR oprc_dev(EVENT *evt, TC *dev, W ronly);

W pdsp_msg(TC *msg);

/* ޤ 3.4.3 ѥͥޥ͡Υץȥ */

/*  3.6.3 ǡޥ͡Υץȥ */

W dopen_dat(LINK *lnk);

/* ޤ 3.6.3 ǡޥ͡Υץȥ */

#endif /* !_BTRON_H */
