/* pointer.c
   Copyright (C) 2007
   NAKANISHI Shin

   This file is part of SBL.

   SBL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   SBL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with SBL; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#include <btron.h>
#include "PS_BUSY.xbm"
#include "PS_SELECT.xbm"
#include "PS_GRIP.xbm"
#include "PS_HGRIP.xbm"
#include "PS_HMOVE.xbm"
#include "PS_HPICK.xbm"
#include "PS_HRSIZ.xbm"
#include "PS_MENU.xbm"
#include "PS_MODIFY.xbm"
#include "PS_MOVE.xbm"
#include "PS_PICK.xbm"
#include "PS_RSIZ.xbm"
#include "PS_VGRIP.xbm"
#include "PS_VMOVE.xbm"
#include "PS_VPICK.xbm"
#include "PS_VRSIZ.xbm"

/* ѿ */
int ptr_style = 0;

ERR gset_ptr(PTRSTL style, PTRIMG *img, COLOR fgcol, COLOR bgcol)
{
  if (style == PS_BUSY) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_BUSY_bits, BLACK, WHITE);
    ptr_style = PS_BUSY;
  } else if (style == PS_SELECT) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_SELECT_bits, BLACK, WHITE);
    ptr_style = PS_SELECT;
  } else if (style == PS_MODIFY) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_MODIFY_bits, BLACK, WHITE);
    ptr_style = PS_MODIFY;
  } else if (style == PS_MOVE) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_MOVE_bits, BLACK, WHITE);
    ptr_style = PS_MOVE;
  } else if (style == PS_VMOVE) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_VMOVE_bits, BLACK, WHITE);
    ptr_style = PS_VMOVE;
  } else if (style == PS_HMOVE) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_HMOVE_bits, BLACK, WHITE);
    ptr_style = PS_HMOVE;
  } else if (style == PS_GRIP) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_GRIP_bits, BLACK, WHITE);
    ptr_style = PS_GRIP;
  } else if (style == PS_VGRIP) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_VGRIP_bits, BLACK, WHITE);
    ptr_style = PS_VGRIP;
  } else if (style == PS_HGRIP) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_HGRIP_bits, BLACK, WHITE);
    ptr_style = PS_HGRIP;
  } else if (style == PS_RSIZ) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_RSIZ_bits, BLACK, WHITE);
    ptr_style = PS_RSIZ;
  } else if (style == PS_VRSIZ) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_VRSIZ_bits, BLACK, WHITE);
    ptr_style = PS_VRSIZ;
  } else if (style == PS_HRSIZ) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_HRSIZ_bits, BLACK, WHITE);
    ptr_style = PS_HRSIZ;
  } else if (style == PS_PICK) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_PICK_bits, BLACK, WHITE);
    ptr_style = PS_PICK;
  } else if (style == PS_VPICK) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_VPICK_bits, BLACK, WHITE);
    ptr_style = PS_VPICK;
  } else if (style == PS_HPICK) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_HPICK_bits, BLACK, WHITE);
    ptr_style = PS_HPICK;
  } else if (style == PS_MENU) {
    set_bitmap(1, 0, 456, 24, 24, (24 *24) /8, PS_MENU_bits, BLACK, WHITE);
    ptr_style = PS_MENU;
  }
  return 0;
}

W gget_ptr(PTRSTS *sts, PTRIMG *img)
{
  sts->pos.x = 0;
  sts->pos.y = 0;
  sts->style = ptr_style;
  sts->fgcol = WHITE;
  sts->bgcol = BLACK;
  sts->motion = 0;
  sts->hidden = 0;
  sts->size = 24;
  return 0;
}

ERR gdsp_ptr(W req)
{
  if (req == 0) {
    fillbox_vga(1, 0, 456, 24, 24, GRAY, 0);
    ptr_style = 0;
    return 0;
  } else if (req > 0) {
    set_bitmap(1, 0, 456, 24, 24, (24 * 24) / 8, PS_MODIFY_bits, BLACK, WHITE);
    ptr_style = PS_MODIFY;
    return req;
  } else if (req < 0) {
    return 0; /* ˤϤʤϤ */
  }
}
