;;; epocc.el -- The Editing Process Organizer / CC-mode for emacs.
;;<plaintext>

;; Author: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Maintainer: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Version: $Lastupdate: Sat Oct 05 11:11:49 2002 $ on inspire.
;; Created: 2001 Feb 10.
;; URL : http://park.ruru.ne.jp/ando/work/who/epojava/
;; Keywords: epo , c , c++ , Java

;;; Code:

;; Abstract.
;;   This program support functions.
;;     * epo support.
;;     * foo.c<-->foo.h same name file jump.
;;     * #include file search and jump.
;;     * method view.
;;     * word jump
;;     * replace indent all lines.
;;     * replace KandR style format.
;;
;; Setting epocc.
;;   In your ~/.emacs there could be:
;; 1. looking for the epoan.el.
;;     (require 'epoan)
;;
;; 2.  Add include search path (This is option / CC only).
;;
;;     (show) M-x describe-variable
;;                        epocc-include
;------------------------------------------------------------------------
(defvar epocc-include '("../include" "../inc" "../head" "../src" ".")
  "* Add include search path in your .emacs (This is option).

1.For UNIX example.
 (setq epocc-include
   \'(\"../include\" \"../src\" \"/usr/ucbinclude\" \"/usr/include\"))

2.For Windows (Meadow / mule for win32 / etc...) example.
 (setq epocc-include
   \'(\"../include\" \"../src\" \"c:/borland/bcc55/Include\"))

3.For network host example(use ange-ftp).
 (setq epocc-include
   \'(\"/account@your.host.name:/home/account/foo/bar/include\"))")
(defvar epocc-include-extension '(".h" ".H" ".ih" ".hh")
  "* search extension (include)")
(defvar epocc-src-extension '(".c" ".C" ".cc" ".ic" ".CC" ".cpp" ".cxx")
  "* search extension (source)")
;;
;; .... Okey ??
(setq epo-c-file-alist
  (list
   (list 'extension (append epocc-include-extension epocc-src-extension))
   (list 'search epocc-include)))
;(setq epo-c-file-alist
;  '((extension . ("\\.c" "\\.C" "\\.h"))
;    (search . ("../include" "../inc" "../head" "../src"))))
;;

(defvar epocc-table-cc-regexp
  "^\\([a-zA-Z#].+\\)$" "*epocc-table cc hit list")
(defvar epocc-table-idl-regexp
  "^\\s *\\(\\(#[a-zA-Z]+\\|typedef\\|module\\|interface\\|struct\\|exception\\)\\s +.+\\)$"
  "*epocc-table idl hit list")
(defvar epocc-makefile-value "Makefile" "*jakarta-ant default xml filename")
(defvar epocc-process-alist
  '((?j (type . compile)
	(command "Make" epo-make-command-line
		 "-C" epocc-make-cd
		 "-f" epocc-makefile-value epocc-make-target)))
  "* java/ant process-alist")
(defvar epocc-append-process-alist nil "* appended process alist")
;---------------------------------------------------------------
(defvar   epocc-mode-map nil "epocc keymap")
(defconst epoc-mode-name     "epoc"    "Epo C-mode mode name")
(defconst epocc-mode-name    "epocc"   "Epo CC-mode mode name")
(defconst epoidl-mode-name   "epoidl"  "Epo IDL-mode mode name")

;---------------------------------------------------------------------
;;;
;; Define key.
;;;
(require 'epocclib)
(require 'cc-mode)
(require 'epo-make)

(if epocc-mode-map
    nil
  (setq epocc-mode-map (copy-keymap c++-mode-map))
  (substitute-key-definition
   'epo-version 'epocclib-version epo-mode-map)
  (substitute-key-definition
   'epop-start-menu 'epocclib-start-menu epo-mode-map)
  (define-key epocc-mode-map "\M-q"  'epocclib-indent-all)
  (define-key epocc-mode-map "\M-Q"  'epocclib-kandr-style)
  (define-key epocc-mode-map "\M-\r" 'epoi-intelligent-newline)
  (epo-define-key epocc-mode-map "u" 'epocclib-update-file)
  (epo-define-key epocc-mode-map "t" 'epocclib-start-menu)
  (epo-define-key epocc-mode-map "b" 'epocclib-structure-b-input)
  (epo-define-key epocc-mode-map "f" 'epocclib-structure-f-input)
  (epo-define-key epocc-mode-map "h" 'describe-mode)
  (epo-define-key epocc-mode-map "g" 'epocc-corresponding-include)
  (epo-define-key epocc-mode-map "G" 'epocclib-table-mode-in)
  (epo-define-key epocc-mode-map "d" 'epocc-wordjump)
  (epo-define-key epocc-mode-map "a" 'epocc-project)
  (epo-define-key epocc-mode-map ";" 'epocclib-untranslate-region)
  (epo-define-key epocc-mode-map ":" 'epocclib-translate-region)
  (epo-define-key epocc-mode-map "<" 'epocclib-uncomment-region)
  (epo-define-key epocc-mode-map ">" 'comment-region)

  (defvar epocc-mode-menu-comp-map (make-sparse-keymap "Completion"))
  (epocclib-define-menu
   'epocc-mode-menu-comp-map
   (nreverse
    (list
     (cons (list 'block "Block")
	   (cons "Block" 'epocclib-structure-b-input))
     (cons (list 'func "Function")
	   (cons "Function" 'epocclib-structure-f-input)))))
  (defvar epocc-mode-menu-project-map (make-sparse-keymap "Project"))
  (epocclib-define-menu
   'epocc-mode-menu-project-map
   (nreverse
    (list
     (cons (list 'load "Load")
	   (cons "Load" 'epocclib-project-load))
     (cons (list 'save "Save")
	   (cons "Save" 'epocclib-project-save))
     (cons (list 'disp "Display")
	   (cons "Display"
		 '(lambda () (interactive)
		    (describe-variable 'epocc-include))))
     (cons (list 'add "Add")
	   (cons "Add" 'epocc-project-add))
     (cons (list 'set "Modify")
	   (cons "Modify" 'epocc-project-set))
     (cons (list 'rel "Release")
	   (cons "Release" 'epocc-project-release)))))
  (defvar epocc-mode-menu-goto-map (make-sparse-keymap "Goto"))
  (epocclib-define-menu
   'epocc-mode-menu-goto-map
   (nreverse
    (list
     (cons (list 'make "Makefile")
	   (cons "Makefile" 'epocc-make-find))
     (cons (list 'jump "File")
	   (cons "File" 'epocc-corresponding-include))
     (cons (list 'method "Method")
	   (cons "Method" 'epocclib-table-mode-in))
     (cons (list 'word "Word")
	   (cons "Word" 'epocc-wordjump)))))
  (defvar epocc-mode-menu-map (make-sparse-keymap epocc-mode-name))
  (epocclib-define-menu
   'epocc-mode-menu-map
   (nreverse
    (list
     (cons (list 'comp "Completion")
	   (cons "Completion" epocc-mode-menu-comp-map))
     (cons (list 'typeset "Invoke Process (Typeset)")
	   (cons "Invoke Process (Typeset)" 'epocclib-start-menu))
     (cons (list 'disp "Project display")
	   (cons "Project" epocc-mode-menu-project-map))
     (cons (list 'goto "Goto jump")
	   (cons "Goto jump" epocc-mode-menu-goto-map))
     (cons (list 'rep "Replace source")
	   (cons "Replace source" 'epocclib-kandr-style))
     (cons (list 'indent "Indent all(file)")
	   (cons "Indent all(file)" 'epocclib-indent-all))
     (cons (list 'infile "Indent all(folder)")
	   (cons "Indent all(folder)" 'epocc-per-folder-indent))
     (cons (list 'update "Update all file")
	   (cons "Update all file" 'epocclib-update-file))
     (cons (list 'ver "Version")
	   (cons "Version" 'epocclib-version))
     (cons (list 'help "For help")
	   (cons "For help" 'describe-mode)) )))
  (define-key epocc-mode-map [menu-bar epocc]
    (cons epocc-mode-name epocc-mode-menu-map))
  (if (featurep 'xemacs)
      (add-hook
       'epocc-mode-hook
       '(lambda ()
	  (or (assoc epocc-mode-name current-menubar)
	      (progn
		(set-buffer-menubar (copy-sequence current-menubar))
		(add-submenu nil epocc-mode-menu-map)))))))

;---------------------------------------------------------------------

(defun epoidl-mode ()
  "The Editing Process Organizer / CORBA/IDL mode for GNU emacs.

Key bindings:
 \\[epocc-corresponding-include] :
 C-u \\[epocc-corresponding-include] : for same window
 \\[epocclib-table-mode-in] : display my class detail
 C-u \\[epocclib-table-mode-in] : display my class detail (same window)
 \\[epocc-make-find] : display my Makefile
 C-u \\[epocc-make-find] : display my Makefile (same window)
 \\[epocc-wordjump] : display woad jump alist
 C-u \\[epocc-wordjump] : display woad jump alist
 \\[epocclib-indent-all] : indent-command all lines
 \\[epocclib-kandr-style] : replace K&R style format
 \\[epocclib-version] : display virsion number
 \\[describe-mode] : for help"
  (interactive)
  (cond
   ((fboundp 'idl-mode) (idl-mode))
   (t (c++-mode)))
  (setq mode-name epoidl-mode-name)
  (setq major-mode 'epoidl-mode)
  (epocclib-enable "idl") ;; invoke epo-mode
  (make-local-variable 'epocclib-table-regexp)
  (setq epocclib-table-regexp epocc-table-idl-regexp)
  (if (featurep 'xemacs)
      (if (not window-system) nil
	(font-lock-mode nil) ; font lock
	(make-local-variable 'font-lock-defaults)
	(setq
	 font-lock-defaults
	 (list 
	  (cond ((boundp 'idl-font-lock-keywords-3) 'idl-font-lock-keywords-3)
		((boundp 'idl-font-lock-keywords-2) 'idl-font-lock-keywords-2)
		((boundp 'c++-font-lock-keywords-3) 'c++-font-lock-keywords-3)
		((boundp 'c++-font-lock-keywords-2) 'c++-font-lock-keywords-2)
		((boundp 'c-font-lock-keywords-3) 'c-font-lock-keywords-3)
		(t c-font-lock-keywords-2))
	  nil t))))
  (if window-system (font-lock-mode 1))
  (use-local-map epocc-mode-map)
  (setq indent-tabs-mode nil)
  (setq epo-c-process-alist
	(append epocc-process-alist epocc-append-process-alist))
  (run-hooks 'epoidl-mode-hook))

(defun epoc-mode ()
  "The Editing Process Organizer / epocc mode for GNU emacs.

Key bindings:
 \\[epocc-corresponding-include] :
 C-u \\[epocc-corresponding-include] : for same window
 \\[epocclib-table-mode-in] : display my class detail
 C-u \\[epocclib-table-mode-in] : display my class detail (same window)
 \\[epocc-make-find] : display my Makefile
 C-u \\[epocc-make-find] : display my Makefile (same window)
 \\[epocc-wordjump] : display woad jump alist
 C-u \\[epocc-wordjump] : display woad jump alist (same window)
 \\[epocclib-indent-all] : indent-command all lines
 \\[epocclib-kandr-style] : replace K&R style format
 \\[epocclib-version] : display virsion number
 \\[describe-mode] : for help"
  (interactive)
  (c-mode)
  (setq mode-name epoc-mode-name)  
  (setq major-mode 'epoc-mode)
  (epocclib-enable "c") ;; invoke epo-mode
  (make-local-variable 'epocclib-table-regexp)
  (setq epocclib-table-regexp epocc-table-cc-regexp)
  (if (featurep 'xemacs)
      (if (not window-system) nil
	(font-lock-mode nil) ; font lock
	(make-local-variable 'font-lock-defaults)
	(setq
	 font-lock-defaults
	 (list 
	  (cond ((boundp 'c-font-lock-keywords-3) 'c-font-lock-keywords-3)
		(t c-font-lock-keywords-2))
	  nil t))))
  (if window-system (font-lock-mode 1))
  (use-local-map epocc-mode-map)
  (setq indent-tabs-mode nil)
  (setq epo-c-process-alist
	(append epocc-process-alist epocc-append-process-alist))
  (run-hooks 'epoc-mode-hook))

(defun epocc-mode ()
  "The Editing Process Organizer / epocc mode for GNU emacs.

Key bindings:
 \\[epocc-corresponding-include] :
 C-u \\[epocc-corresponding-include] : for same window
 \\[epocclib-table-mode-in] : display my class detail
 C-u \\[epocclib-table-mode-in] : display my class detail (same window)
 \\[epocc-make-find] : display my Makefile
 C-u \\[epocc-make-find] : display my Makefile (same window)
 \\[epocc-wordjump] : display woad jump alist
 C-u \\[epocc-wordjump] : display woad jump alist (same window)
 \\[epocclib-indent-all] : indent-command all lines
 \\[epocclib-kandr-style] : replace K&R style format
 \\[epocclib-version] : display virsion number
 \\[describe-mode] : for help"
  (interactive)
  (c++-mode)
  (setq mode-name epocc-mode-name)
  (setq major-mode 'epocc-mode)
  (epocclib-enable "c") ;; invoke epo-mode
  (make-local-variable 'epocclib-table-regexp)
  (setq epocclib-table-regexp epocc-table-cc-regexp)
  (if (featurep 'xemacs)
      (if (not window-system) nil
	(font-lock-mode nil) ; font lock
	(make-local-variable 'font-lock-defaults)
	(setq
	 font-lock-defaults
	 (list 
	  (cond ((boundp 'c++-font-lock-keywords-4) 'c++-font-lock-keywords-4)
		((boundp 'c++-font-lock-keywords-3) 'c++-font-lock-keywords-3)
		((boundp 'c++-font-lock-keywords-2) 'c++-font-lock-keywords-2)
		((boundp 'c-font-lock-keywords-3) 'c-font-lock-keywords-3)
		(t c-font-lock-keywords-2))
	  nil t))))
  (if window-system (font-lock-mode 1))
  (use-local-map epocc-mode-map)
  (setq indent-tabs-mode nil)
  (setq epo-c-process-alist
	(append epocc-process-alist epocc-append-process-alist))
  (run-hooks 'epocc-mode-hook))

;---------------------------------------------------------------------

(defun epocc-corresponding-include (&optional other)
  "c-c g transaction (include)"
  (interactive "P")
  (let* ((name nil) (peol nil) )
    (save-excursion
      (end-of-line)
      (setq peol (point))
      (beginning-of-line)
      (if (re-search-forward "#include[ \t]+[\"<]\\([^\">]*\\)[\">]" peol t)
	  (progn
	    (setq name
		  (buffer-substring (match-beginning 1) (match-end 1)))
	    (setq name (epocc-find-name	name nil))
	    (epocc-switch-to-buffer name other))
	(epocc-corresponding-parent other)))))

(defun epocc-corresponding-parent (&optional other)
  "//#! existes jump"
  (save-excursion
    (goto-char (point-min))
    (if (re-search-forward "//#! *\\(\\(\\w\\|_\\|\\.\\)*\\)" nil t)
	(epocc-switch-to-buffer
	 (epocc-find-name
	  (buffer-substring  (match-beginning 1) (match-end 1))
	  nil)
	 other)
    (epocc-corresponding-filename other))))

(defun epocc-corresponding-filename (&optional other)
  "file name to jump"
  (let*
      ((file
	(file-name-nondirectory
	 (file-name-sans-extension (buffer-file-name))))
       (extension
	(concat "." (file-name-extension (buffer-file-name)))))
    (epocc-switch-to-buffer 
       (if (member extension epocc-include-extension)
	   (epocc-find-name file epocc-src-extension)
	 (if (member extension epocc-src-extension)
	     (epocc-find-name file epocc-include-extension)))
     other)))

(defun epocc-find-name (fname extension)
  (let ((reg) (buf extension)
	(top epocc-include) (ans))
    (if (or (not extension) (not buf))
	(setq reg (concat "^" (file-name-nondirectory
			       (file-name-sans-extension fname)) "\\."
			       (file-name-extension fname) "$"))
      (setq reg (concat fname "\\(" (car buf)))
      (setq buf (cdr buf))
      (while buf
	(if (string-equal "" (car buf))
	    nil
	  (setq reg (concat reg "\\|\\" (car buf))))
	(setq buf (cdr buf)))
      (setq reg (concat reg "\\)$")))
    (catch 'epocc-find-name-tag
      (while top
	(setq ans (epocc-find-name2 (car top) reg))
	(if ans (throw 'epocc-find-name-tag ans))
	(setq top (cdr top))))))

(defun epocc-find-name2 (filename extension)
  "repaint project"
  (message (concat "find file= " filename))
  (catch 'epocc-find-name2-tag
    (let ((expfile (expand-file-name filename))
	  (list nil) (now nil) (ans))
      (setq list (directory-files expfile t extension))
      (if list (throw 'epocc-find-name2-tag (car list)))
      (setq list (directory-files expfile t))
      (while list
	(setq now (file-name-nondirectory  (car list)))
	(if (and (file-directory-p (car list))
		 (not (or (equal "" now)
			  (equal "." now)
			  (equal ".." now)
			  (equal "CVS" now))))
	    (progn
	      (setq ans (epocc-find-name2 (car list) extension))
	      (if ans (throw 'epocc-find-name2-tag ans))))
	(setq list (cdr list)))
      (setq let nil))))

(defun epocc-switch-to-buffer (file &optional other)
  "epocc buffer open session"
  (interactive "Fswitch to file: ")
  (if (null file) (error "no not yet"))
  (if (null (file-exists-p file)) (error "can not open file %s" file))
  (if (get-file-buffer file)
      (if other
	  (switch-to-buffer-other-window (get-file-buffer file))
	(switch-to-buffer (get-file-buffer file)))
    (if other
	(find-file-other-window file)
      (find-file file))))

;;;---------------------------------------------------------------------

(defun epocc-project ()
  "pakage editor"
  (interactive)
  (describe-variable 'epocc-include)
  (message "a)add m)modify r)release l)load s)save")
  (let ((c (read-char)))
    (cond 
     ((= ?a c) (epocc-project-add))
     ((= ?m c) (epocc-project-set))
     ((= ?s c) (epocclib-project-save))
     ((= ?l c) (epocclib-project-load))
     ((= ?r c) (epocc-project-release))
     (nil)))
  (describe-variable 'epocc-include))

(defun epocc-project-add ()
  "add epocc-include"
  (interactive)
  (let ((dir (file-name-directory (buffer-file-name)))
	(name))
    (setq name (read-file-name "project path : " dir dir))
    (setq name (if (file-directory-p name) name (file-name-directory name)))
    (if (member name epocc-include)
	nil
      (setq epocc-include (cons name epocc-include)))))

(defun epocc-project-set ()
  "add/modify epocc-include"
  (interactive)
  (let ((alist nil) (buf epocc-include))
    (while buf
      (setq alist
	    (cons (list (concat "arg[" (car buf) "]") (car buf)) alist))
      (setq buf (cdr buf)))
    (setq buf (epocclib-project-set alist))
    (setq epocc-include nil)
    (while buf
      (setq epocc-include (append (cdr (car buf)) epocc-include))
      (setq buf (cdr buf)))))

(defun epocc-project-release ()
  "delete epocc-include"
  (interactive)
  (let ((alist nil) (buf epocc-include) (pos 0))
    (while buf
      (setq alist
	    (cons (list (car buf) (car buf)) alist))
      (setq pos (+ pos 1))
      (setq buf (cdr buf)))
    (setq buf (epocclib-project-release alist))
    (setq epocc-include nil)
    (while buf
      (setq epocc-include (append (cdr (car buf)) epocc-include))
      (setq buf (cdr buf)))))

;;;---------------------------------------------------------------------
(defun epocc-wordjump (&optional other)
    "epocc wordjump display

Key bindings:
 g : open.
 C-u g : open same window.
 \\[epocclib-view-file] : view mode.
 \\[epocclib-table-quit] : quit."
  (interactive "P")
  (epocclib-wordjump
   (list (completing-read
	  "Project : "
	  (epocc-make-alist
	   (append epocc-include '("./" "../" "../../" "../../../")))
	  nil t))
   (if (string-equal
	"include"
	(completing-read "include/src : " '(("include") ("src")) nil t))
       epocc-include-extension epocc-src-extension)
   other))

(defun epocc-make-alist (other)
  "from array to alist"
  (let ((alist nil) (buf other))
    (while buf
      (setq alist
	    (cons (list (car buf)) alist))
      (setq buf (cdr buf)))
    alist))

;;;
;;; makefile -----------------------------------------------------------
;;;
(defun epocc-make-cd ()
  "make folder change"
  (interactive)
  (file-name-directory (epocc-makefile)))

(defun epocc-make-target ()
  "ant target project complet"
  (save-excursion
    (set-buffer (find-file-noselect epocc-makefile-value))
    (epo-make-target)))

(defun epocc-makefile ()
  "find file for make file"
  (let ((pos 0) (file (file-name-nondirectory epocc-makefile-value))
	(dir (file-name-directory epocc-makefile-value)) (name))
    (catch 'epocc-make-file-tag
      (while (< pos 20) ;; 20 is ok??
	(setq name (expand-file-name (concat dir file)))
	(if (file-exists-p name)
	    (progn
	      (setq epocc-makefile-value name)
	      (throw 'epocc-make-file-tag t)))
	(setq dir (concat dir "../"))
	(setq pos (+ 1 pos)))))
  (setq
   epocc-makefile-value
   (expand-file-name
    (read-file-name
     (concat "file(" (file-name-nondirectory epocc-makefile-value) "): ")
     (file-name-directory epocc-makefile-value)
     epocc-makefile-value t
     (file-name-nondirectory epocc-makefile-value)))))

(defun epocc-make-find (&optional other)
  "jump to Makefile"
  (interactive)
  (epocc-makefile)
  (epocclib-switch-to-buffer epocc-makefile-value other))

(defun epocc-per-folder-indent (filename)
  "Per folder indent / All C or header files are indented in folder.
And all lines are indented in files."
  (interactive "DTarget Firectory: ")
  (let ((list (append epocc-include-extension epocc-src-extension))
	(now "\\("))
    (setq now (concat now "\\" (car list)))
    (setq list (cdr list))
    (while list
      (setq now (concat now "\\|\\" (car list)))
      (setq list (cdr list)))
    (setq now (concat now "\\)$"))
    (epocclib-per-folder-indent filename now)))

;  end.
(provide 'epocc)
;;; epocc.el ends here
