;;; -*- Emacs-Lisp -*-
;;; EPO jsp dependent settings
;;; (c) 2002 by Toshikazu Ando <ando@park.ruru.ne.jp>
;;; Created: 2002 Mar 24
;;; $Lastupdate: Fri Apr 05 23:49:14 2002 $ on inspire.

(require 'epo-xhtml)
(require 'epo-scof)
(if (getenv "ANT_HOME") (require 'epo-ant))
;;[Commentary]
;;	
;;	EPO -- jsp for Sturts.
;;	http://jakarta.apache.org/struts/

;;;
;; Variables for Input Aider(EPOI)
;;;
(defvar epo-jsp-structure-alist
  '((?b (type . block)
	(structure "<" keyword argument ">\n" indent cursor "\n"
		   "</" keyword ">" indent)
	(table . epo-jsp-block-table)
	(argsep . sgml)	(mustmatch . t))
    (?l (type . typeface)
	(structure indent "<" keyword argument ">" cursor "</" keyword ">")
	(table . epo-html-typeface-table)
	(argsep . sgml)	(mustmatch . t))
    (?s (type . inline)
	(structure indent "<" keyword argument " />" cursor)
	(table . epo-jsp-inline-table)
	(argsep . sgml) (arg-reader . nil))
    (?@ (type . %)
	(structure indent "<%" keyword cursor argument " %>\n")
	(table . epo-jsp-taglib-table)
	(argsep . sgml) (arg-reader . nil))
    (?n (type . ret)
	(structure "<br />" indent cursor)
	(mustmatch . t))))

(defun epo-jsp-same-alist (arg1 arg2 arg3)
  "ant target file complet"
  (let ((file (concat (file-name-directory (buffer-file-name))
		      "WEB-INF/struts-config.xml")))
    (if (file-exists-p file)
	(save-excursion
	  (set-buffer (find-file-noselect file))
	  (epo-xml-same-alist arg1 arg2 arg3))
      (read-string (concat arg3 " : ")) )))

(defun epo-jsp-action-alist (arg1 arg2 arg3)
  "ant target file complet"
  (let ((file (concat (file-name-directory (buffer-file-name))
		      "WEB-INF/struts-config.xml")))
    (if (file-exists-p file)
	(save-excursion
	  (set-buffer (find-file-noselect file))
	  (epo-xml-same-alist arg1 arg2 "action\\|path"))
      (read-string (concat arg3 " : ")) )))

(defvar epo-jsp-common-table
  '(("jsp:include" ("page" . epo-xml-file-name)
     ("flush" . epo-xml-boolean))
    ("jsp:useBean" ("id" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist) ("type") ("class"))
    ("jsp:getProperty" ("name" . epo-jsp-same-alist)
     ("property" . epo-xml-same-alist))
    ("jsp:setProperty" ("name" . epo-jsp-same-alist)
     ("property" . epo-xml-same-alist) ("param"))
    ("jsp:plugin" ("type") ("code") ("codebase") ("jreversion")
     ("width") ("width"))
    ("jsp:params" . 0)
    ("jsp:param" ("name" . epo-jsp-same-alist) ("value"))
    ("jsp:fallback" . 0)
    ("jsp:forward" ("page" . epo-xml-file-name))
    ;;
    ("bean:cookie" ("id" . epo-xml-same-alist)
     ("name" . epo-jsp-same-alist) ("value") ("multiple"))
    ("bean:define" ("id" . epo-xml-same-alist)
     ("name" . epo-jsp-same-alist) ("value")
     ("property" . epo-xml-same-alist) ("scope" . epo-scof-scope-alist)
     ("toScope") ("type"))
    ("bean:header" ("id" . epo-xml-same-alist)
     ("name" . epo-jsp-same-alist) ("value") ("multiple"))
    ("bean:include" ("id" . epo-xml-same-alist) ("name" . epo-jsp-same-alist)
     ("anchor") ("forward" . epo-xml-file-name) ("href" . epo-xml-file-name)
     ("page") ("transaction"))
    ("bean:message" ("key")
     ("arg0") ("arg1") ("arg2") ("arg3") ("arg4")
     ("bundle") ("locale" . epo-xml-boolean))
    ("bean:page" ("id" . epo-xml-same-alist) ("property" . epo-xml-same-alist))
    ("bean:parameter" ("id" . epo-xml-same-alist)
     ("name" . epo-jsp-same-alist) ("value") ("multiple"))
    ("bean:resource" ("id" . epo-xml-same-alist)
     ("name" . epo-jsp-same-alist) ("input"))
    ("bean:size" ("id" . epo-xml-same-alist)
     ("name" . epo-jsp-same-alist) ("collection")
     ("property" . epo-xml-same-alist) ("scope" . epo-scof-scope-alist))
    ("bean:struts" ("id" . epo-xml-same-alist) ("formBean")
     ("forward" . epo-xml-file-name) ("mapping"))
    ("bean:write" ("name" . epo-jsp-same-alist) ("filter") ("ignore")
     ("property" . epo-xml-same-alist) ("scope" . epo-scof-scope-alist))
    ("html:base" ("target"))
    ("html:button" ("accesskey") ("value") ("disabled") ("onblur")
     ("onchange") ("onclick") ("ondblclick") ("onfocus") ("onkeydown")
     ("onkeypress") ("onkeyup") ("onmousedown") ("onmousemove")
     ("onmouseout") ("onmouseover") ("onmouseup")
     ("property" . epo-xml-same-alist)
     ("style") ("styleClass") ("styleId") ("tabindex"))
    ("html:cancel" ("accesskey") ("value") ("disabled") ("onblur")
     ("onchange") ("onclick") ("ondblclick") ("onfocus") ("onkeydown")
     ("onkeypress") ("onkeyup") ("onmousedown") ("onmousemove")
     ("onmouseout") ("onmouseover") ("onmouseup")
     ("property" . epo-xml-same-alist) ("style")
     ("styleClass") ("styleId") ("tabindex") )
    ("html:checkbox" ("name" . epo-jsp-same-alist) ("accesskey")
     ("value") ("disabled") ("onblur")
     ("onchange") ("onclick") ("ondblclick") ("onfocus") ("onkeydown")
     ("onkeypress") ("onkeyup") ("onmousedown") ("onmousemove")
     ("onmouseout") ("onmouseover") ("onmouseup")
     ("property" . epo-xml-same-alist) ("style")
     ("styleClass") ("styleId") ("tabindex"))
    ("html:errors" ("name" . epo-jsp-same-alist) ("bundle")
     ("locale" . epo-xml-boolean) ("property" . epo-xml-same-alist))
    ("html:file" ("name" . epo-jsp-same-alist) ("accesskey") ("value")
     ("accept") ("disabled") ("maxlength") ("onblur") ("onchange")
     ("onclick") ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress")
     ("onkeyup") ("onmousedown") ("onmousemove") ("onmouseout")
     ("onmouseover") ("onmouseup") ("property" . epo-xml-same-alist)
     ("size") ("style") ("styleClass") ("styleId") ("tabindex"))
    ("html:form" ("name" . epo-jsp-same-alist) ("value")
     ("action" . epo-jsp-action-alist)
     ("enctype") ("focus") ("method") ("onreset") ("onsubmit")
     ("scope" . epo-scof-scope-alist)
     ("style") ("styleClass") ("styleId") ("target") ("type"))
    ("html:hidden" ("name" . epo-jsp-same-alist)
     ("property" . epo-xml-same-alist))
    ("html:html" ("locale" . epo-xml-boolean) ("xhtml"))
    ("html:image" ("value") ("src" . epo-xml-file-name)
     ("align" . epo-html-align-alist)
     ("border") ("alt". epo-html-image-alt)
     ("accesskey") ("altKey") ("bundle") ("disabled")
     ("locale" . epo-xml-boolean) ("onblur") ("onchange") ("onclick")
     ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress") ("onkeyup")
     ("onmousedown") ("onmousemove") ("onmouseout") ("onmouseover")
     ("onmouseup") ("page") ("pageKey") ("property" . epo-xml-same-alist)
     ("srcKey") ("style") ("styleClass") ("tabindex"))
    ("html:img" ("name" . epo-jsp-same-alist)
     ("src" . epo-html-image-file-name)
     ("align" . epo-html-align-alist)
     ("border") ("alt". epo-html-image-alt)
     ("width" . epo-html-image-width)
     ("height" . epo-html-image-height)
     ("accesskey") ("altKey") ("bundle") ("hspace") ("imageName")
     ("ismap") ("locale" . epo-xml-boolean)
     ("lowsrc") ("onkeydown") ("onkeypress") ("onkeyup") ("paramId")
     ("page") ("pageKey") ("paramName") ("paramProperty") ("paramScope")
     ("property" . epo-xml-same-alist) ("scope" . epo-scof-scope-alist)
     ("srcKey") ("style")
     ("styleClass") ("styleId") ("usemap") ("vspace"))
    ("html:link" ("name" . epo-jsp-same-alist) ("accesskey") ("anchor")
     ("forward" . epo-xml-file-name) ("href" . epo-xml-file-name)
     ("linkName") ("onblur") ("onclick") ("ondblclick") ("onfocus")
     ("onkeydown") ("onkeypress") ("onkeyup") ("onmousedown")
     ("onmousemove") ("onmouseout") ("onmouseover") ("onmouseup") ("page")
     ("paramId") ("paramName") ("paramProperty") ("paramScope")
     ("property" . epo-xml-same-alist) ("scope" . epo-scof-scope-alist)
     ("style") ("styleClass") ("styleId") ("tabindex") ("target") ("title")
     ("transaction"))
    ("html:multibox" ("name" . epo-jsp-same-alist) ("accesskey") ("value")
     ("disabled") ("onblur") ("onchange") ("onclick") ("ondblclick")
     ("onfocus") ("onkeydown") ("onkeypress") ("onkeyup") ("onmousedown")
     ("onmousemove") ("onmouseout") ("onmouseover") ("onmouseup")
     ("property" . epo-xml-same-alist) ("style") ("styleClass")
     ("styleId") ("tabindex"))
    ("html:option" ("key") ("value") ("bundle") ("disabled")
     ("locale" . epo-xml-boolean)
     ("style") ("styleClass"))
    ("html:options" ("name" . epo-jsp-same-alist) ("collection")
     ("labelName") ("labelProperty") ("property" . epo-xml-same-alist)
     ("style") ("styleClass"))
    ("html:password" ("name" . epo-jsp-same-alist) ("accesskey") ("value")
     ("disabled") ("maxlength") ("onblur") ("onchange") ("onclick")
     ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress") ("onkeyup")
     ("onmousedown") ("onmousemove") ("onmouseout") ("onmouseover")
     ("onmouseup") ("property" . epo-xml-same-alist) ("readonly")
     ("redisplay") ("style") ("styleClass") ("styleId") ("size") ("tabindex"))
    ("html:radio" ("name" . epo-jsp-same-alist) ("accesskey") ("value")
     ("disabled") ("onblur") ("onchange") ("onclick") ("ondblclick")
     ("onfocus") ("onkeydown") ("onkeypress") ("onkeyup")
     ("property" . epo-xml-same-alist)
     ("onmousedown") ("style") ("styleClass") ("styleId") ("tabindex"))
    ("html:reset" ("accesskey") ("value") ("disabled") ("onblur") ("onchange")
     ("onclick") ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress")
     ("onkeyup") ("onmousedown") ("onmousemove") ("onmouseout")
     ("onmouseover") ("onmouseup") ("style") ("styleClass") ("styleId")
     ("tabindex"))
    ("html:rewrite" ("name" . epo-jsp-same-alist) ("anchor")
     ("forward" . epo-xml-file-name) ("href" . epo-xml-file-name) ("page")
     ("paramId") ("paramName") ("paramProperty") ("paramScope")
     ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist) ("transaction"))
    ("html:select" ("name" . epo-jsp-same-alist) ("accesskey") ("value")
     ("disabled") ("multiple") ("onblur") ("onchange") ("onclick")
     ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress") ("onkeyup")
     ("onmousedown") ("onmousemove") ("onmouseout") ("onmouseover")
     ("onmouseup") ("property" . epo-xml-same-alist)
     ("style") ("styleClass") ("styleId") ("tabindex") ("size"))
    ("html:submit" ("accesskey") ("value") ("disabled") ("onblur") ("onchange")
     ("onclick") ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress")
     ("onkeyup") ("onmousedown") ("onmousemove") ("onmouseout")
     ("onmouseover") ("onmouseup") ("property" . epo-xml-same-alist)
     ("style") ("styleClass") ("styleId") ("tabindex"))
    ("html:text" ("name" . epo-jsp-same-alist) ("accesskey") ("value")
     ("disabled") ("maxlength") ("onblur") ("onchange") ("onclick")
     ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress") ("onkeyup")
     ("onmousedown") ("onmousemove") ("onmouseout") ("onmouseover")
     ("onmouseup") ("property" . epo-xml-same-alist) ("readonly") ("size")
     ("style") ("styleClass") ("styleId") ("tabindex"))
    ("html:textarea" ("name" . epo-jsp-same-alist) ("accesskey") ("value")
     ("cols") ("disabled") ("onblur") ("onchange") ("onclick")
     ("ondblclick") ("onfocus") ("onkeydown") ("onkeypress") ("onkeyup")
     ("onmousedown") ("onmousemove") ("onmouseout") ("onmouseover")
     ("onmouseup") ("property" . epo-xml-same-alist) ("readonly") ("rows")
     ("style") ("styleClass") ("styleId") ("tabindex"))
    ("logic:equal" ("name" . epo-jsp-same-alist) ("value") ("cookie")
     ("header") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:forward" ("name" . epo-jsp-same-alist))
    ("logic:greaterEqual" ("name" . epo-jsp-same-alist) ("value")
     ("cookie") ("header") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:greaterThan" ("name" . epo-jsp-same-alist) ("value")
     ("cookie") ("header") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:iterate" ("id" . epo-xml-same-alist)
     ("name" . epo-jsp-same-alist) ("collection")
     ("indexId") ("length") ("offset") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist) ("type"))
    ("logic:lessEqual" ("name" . epo-jsp-same-alist) ("value") ("cookie")
     ("header") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:lessThan" ("name" . epo-jsp-same-alist) ("value") ("cookie")
     ("header") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:match" ("name" . epo-jsp-same-alist) ("value") ("cookie")
     ("header") ("location") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:notEqual"  ("name" . epo-jsp-same-alist) ("value") ("cookie")
     ("header") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:notMatch" ("name" . epo-jsp-same-alist) ("value") ("cookie")
     ("header") ("location") ("parameter") ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist))
    ("logic:notPresent" ("name" . epo-jsp-same-alist) ("cookie") ("header")
     ("parameter") ("property" . epo-xml-same-alist) ("role")
     ("scope" . epo-scof-scope-alist) ("user"))
    ("logic:present" ("name" . epo-jsp-same-alist) ("cookie") ("header")
     ("parameter") ("property" . epo-xml-same-alist) ("role")
     ("scope" . epo-scof-scope-alist) ("user"))
    ("logic:redirect" ("name" . epo-jsp-same-alist) ("anchor")
     ("forward" . epo-xml-file-name) ("href" . epo-xml-file-name) ("page")
     ("paramId") ("paramName") ("paramProperty") ("paramScope")
     ("property" . epo-xml-same-alist)
     ("scope" . epo-scof-scope-alist) ("transaction"))
    ("template:insert" ("template"))
    ("template:put" ("name" . epo-jsp-same-alist) ("role") ("content")
     ("direct"))
    ("template:get" ("name" . epo-jsp-same-alist) ("role") )))

(defvar epo-jsp-block-table
  (append epo-jsp-common-table epo-xhtml-block-table))

(defvar epo-jsp-inline-table
  (append epo-jsp-common-table epo-html-inline-table))

(defvar epo-jsp-uri-alist
  '(("/WEB-INF/struts-bean.tld")
    ("/WEB-INF/struts-html.tld")
    ("/WEB-INF/struts-logic.tld")
    ("/WEB-INF/struts-temlate.tld") ))
(defvar epo-jsp-prefix-alist
  '(("bean") ("html") ("logic") ("temlate") ))
(defvar epo-jsp-taglib-table
  '(("" . 0) ("=" . 0) ("!" . 0)
    ("@ include" ("file" . epo-xml-file-name))
    ("@ page" ("language" . (("java"))) ("contentType" . epo-html-charset))
    ("@ taglib" ("uri" . epo-jsp-uri-alist)
     ("prefix" . epo-jsp-prefix-alist))))

(defvar epo-jsp-iteration-alist epo-xhtml-iteration-alist)
(defvar epo-jsp-relation-alist epo-xhtml-relation-alist)

;;;
;; Variables for Process Handler(EPOP)
;;;
(defvar epo-jsp-process-alist
  (if (getenv "ANT_HOME")
      (append
       '((?r (type . run) (prompt . t)
	     (command "preview" epo-xml-open-remote filename)))
       epo-ant-process-alist)
      epo-xhtml-process-alist))
(defvar epo-jsp-tagjump-alist
  (if (getenv "ANT_HOME") epo-ant-process-alist epo-xml-tagjump-alist))

(provide 'epo-jsp)

; Local variables: 
; fill-prefix: ";;	" 
; paragraph-start: "^$\\|\\|;;$" 
; paragraph-separate: "^$\\|\\|;;$" 
; End: 
