;;; epojava.el -- Editing Process Organizer / Ando Special settting file.
;;<plaintext>

;; Author: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Maintainer: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Created: 2001-2002 Feb.10
;; Version: $Lastupdate: Sun Jun 23 22:38:03 2002 $ on inspire.
;; Keywords: epo, c , c++ , Java , XML , RELAX , Xi , Apatch-Ant

;; Abstract.
;;     epojava is yet another Java/C/C++/XML(RELAX,Xi,Apatch-Ant)
;;    major-mode for emacs/Meadow/XEmacs. 
;;
;; Setting
;;   1. Install epo.
;;        http://www.yatex.org/epo/
;;
;;   2. Install epojava
;;      copy epojava files to same epo folder. 
;;
;;      This is example.
;;      % cp *.el  c:\Meadow\site-lisp\epo
;;      % cp *.jar c:\Meadow\site-lisp\epo
;;
;;   3. In your ~/.emacs there could be:
;;
;;       (require 'epoan)
;;
;----------------------------------------------------------------------

;; gloval
(autoload 'epo      "epo" "Editing Process Organizer" t)
(autoload 'epo-mode "epo" "Editing Process Organizer" t)
(autoload 'epoxml-mode  "epoxml"  "Epo-xml mode" t)
(autoload 'epo-zope-start  "epo-zope"  "EPO Zope init" t)

;; archive for java
(add-hook 'archive-zip-mode-hook 'epojava-arcive-mode-hook)
(autoload 'epojava-arcive-mode-hook  "epojava"  "Epo-java mode" t)

;; XML
(setq auto-mode-alist (cons (cons "\\.xml$" 'epoxml-mode) auto-mode-alist))

;; XML / XSL
(setq auto-mode-alist (cons (cons "\\.xsl$"  'epoxml-mode) auto-mode-alist))

;; XML / Relax
(setq auto-mode-alist
      (cons (cons "\\.r\\(lx\\|xm\\|xg\\)$" 'epoxml-mode) auto-mode-alist))

;; XML / Relax
(setq auto-mode-alist
      (cons (cons "\\.sdoc$" 'epoxml-mode) auto-mode-alist))

;; XML / tglib file
(setq auto-mode-alist (cons (cons "\\.tld$" 'epoxml-mode) auto-mode-alist))

;; XML / JSP
(setq auto-mode-alist (cons (cons "\\.jsp$" 'epoxml-mode) auto-mode-alist))

;; XML / jnlp
(setq auto-mode-alist
      (cons (cons "\\.[x]?jnlp$"  'epoxml-mode) auto-mode-alist))

;; XML / Xi
(setq auto-mode-alist (cons (cons "\\.xi$"  'epoxml-mode) auto-mode-alist))

;; XML / geml and gsml
(setq auto-mode-alist
      (cons (cons "\\.g[se]ml$" 'epoxml-mode) auto-mode-alist))

;; java
(setq auto-mode-alist
      (cons (cons "\\.\\(java\\|class\\)$" 'epojava-mode) auto-mode-alist))
(autoload 'epojava-mode "epojava" "Epo-java mode" t)

;; war(vs Sturtus)
(setq auto-mode-alist
      (cons (cons "\\.war$" 'archive-mode) auto-mode-alist))

;; CORBA/IDL
;(setq auto-mode-alist (cons (cons "\\.idl$" 'epoidl-mode) auto-mode-alist))
;(autoload 'epoidl-mode  "epocc"   "Epo-idl mode" t)

;; CORBA/C mapping
(setq auto-mode-alist
      (cons (cons "\\.\\(ih\\|hh\\|ic\\)$" 'epocc-mode) auto-mode-alist))

;; C/C++
(setq auto-mode-alist
      (cons (cons "\\.\\(C\\|cc\\|CC\\|cpp\\|cxx\\|h\\|H\\)$"
		  'epocc-mode) auto-mode-alist))
(setq auto-mode-alist (cons (cons "\\.c$" 'epoc-mode) auto-mode-alist))
(autoload 'epoc-mode    "epocc"   "Epo-c mode" t)
(autoload 'epocc-mode   "epocc"   "Epo-cc mode" t)

;; Makefile
(add-hook 'makefile-mode-hook
	  '(lambda () (interactive)
	     (define-key makefile-mode-map "\C-ct" 'epop-start-menu)
	     (require 'epo) (epo-enable "make")))

;  end.
(provide 'epoan)
;;; epoan.el ends here